package davidalves.net.movement.strategies;

import robocode.*;
import davidalves.net.*;
import davidalves.net.data.*;
import davidalves.net.movement.MovementInterface;
import davidalves.net.math.*;
import davidalves.net.util.*;
import java.util.*;
import java.io.*;

public class GoToCenter implements MovementInterface, Serializable {
	
	public void driveTank(AbstractAdvancedBot me, EnvironmentInterface environment){
			goTo(environment.getArenaCenter(), me, environment);
	}
	
	public void goTo(Point p, AbstractAdvancedBot me, EnvironmentInterface environment) {
		double angleInDegrees = me.getLocation().absoluteAngleTo(p);
		double newDirection = turnTo(angleInDegrees, me, environment);
		double distanceToTravel = Math.min(20,me.getLocation().distanceTo(p));
		me.setAhead(newDirection * distanceToTravel);
	}
	
	public double turnTo(double angleInDegrees, AbstractAdvancedBot me, EnvironmentInterface environment) {
		double ang;
		double dir;
		ang = DaveMath.angularDifferenceBetween(me.getHeading(), angleInDegrees);
		if (ang > DaveMath.QUARTERCIRCLE) {
			ang -= DaveMath.HALFCIRCLE;
			dir = -1;
		} else if (ang < -DaveMath.QUARTERCIRCLE) {
			ang += DaveMath.HALFCIRCLE;
			dir = -1;
		} else {
			dir = 1;
		}
		me.setTurnRight(ang);
		return dir;
	}
	
	public boolean isValid(AbstractAdvancedBot me, EnvironmentInterface environment){
		return me.getOthers() != 0 && environment.getTarget().getLastScannedTime() - me.getTime() > 20;
	}
	
	public String toString(){	
		return "GoToCenter";
	}
}