package fullsail;
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;

/**
 * Test2 - a robot by (your name here)
 */
public class SweetTea extends AdvancedRobot 
{
	double prevEnemyEnergy = 100;
	double energyChange = 0.0;
 	int direction = 1;
	double bulletDistance = -1.0;
	double bulletSpeed = 0.0;	

    public void run() 
	{
		// Set colors
		setBodyColor(Color.orange);
		setGunColor(Color.gray);
		setRadarColor(Color.yellow);
		setScanColor(Color.yellow);
		
    	while(true)
		{ 
			turnRadarRight(Double.POSITIVE_INFINITY);
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) 
	{
    	// Set the radar to follow the enemy bot
    	setTurnRadarRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getRadarHeadingRadians()));
		setTurnGunRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getGunHeadingRadians()));

		////////////////
		// Dodge Code //
		////////////////
		// Align correctly with the enemy for easier dodging
      	setTurnRight(e.getBearing()+90);

		// Check to see if the difference in energy is the amount of a bullet being fired
   		energyChange = prevEnemyEnergy - e.getEnergy();
    	if (energyChange > 0 && energyChange <= 3) 
		{
        	// Check to see if we are tracking a bullet, if not, start tracking one
			// This allows us to wait to move until the bullet is closer to help minimize the movement we make,
			// which could potentially make us run into previously "dodged" bullets
         	if(bulletDistance == -1.0)
			{
				bulletDistance = Math.abs(e.getDistance());
				out.println("Original Distance: " + bulletDistance);
				bulletSpeed = 20 - 3 * energyChange;
				out.println("Bullet Speed: " + bulletSpeed);
				out.println("Energy Change: " + energyChange);
			}
     	}
		
		// if we are tracking a bullet...
		if(bulletDistance > -1.0)
		{
			// if it is getting close, go ahead and move out of its way
			if(bulletDistance < 175.0)
			{
				out.println("Distance at Dodge: " + bulletDistance);
				out.println("====================================");
				direction = -direction;
         		setAhead(100 * direction);
				bulletDistance = -1.0;
			}
			else
			{
				bulletDistance -= bulletSpeed;
				out.println("Remaining Distance: " + bulletDistance); 
				if(bulletDistance < 0.0)
					bulletDistance = 1.0;
			}
		}
    
    	// Fire directly at target with variable power
		fire( 400 / e.getDistance());
    
    	// After everything has happened, update the enemies energy
    	prevEnemyEnergy = e.getEnergy();
	}

	public void onHitRobot(HitRobotEvent e)
	{
		// move away if we've been rammed
		setAhead(300);
	}
}
