package penguin;
import robocode.*;
import java.awt.Color;
import robocode.util.Utils;
import java.awt.*;
import java.awt.geom.*;
import java.util.ArrayList;

public class Ivy extends AdvancedRobot
{
//change this if u want to see a cool painting of all waves considered
	static final boolean paintTheoryShots = false;

	Alfred enemy = new Alfred();
	
	ArrayList<VineWave> _whipGroup;
	ArrayList<Batarang> _rangGroup;
	ArrayList<Point2D.Double> _positionGroup;
	
	static final double PI = Math.PI;
	static double heading;
	
	static Point2D.Double ourLocation;
	static Point2D.Double desiredLoc;
	
	double vinePower = 3;
	
	static final int BINS = 67;
	static final int MIDBIN = (BINS-1)/2;
	static final int DISTANCESEGMENTS = 5;
	static final int NEARWALLSEGMENTS = 3;
	static final int ACCELERATIONSEGMENTS = 3;
	static final int LATERALHEADINGSEGMENTS = 5;
	static final int VELOCITYSEGMENTS = 5;
	static final int TIMESINCESHOTSEGMENTS = 15;
	static final int TDIRECTIONCHANGESEGMENTS = 15;
	static double[][][][][][][][] vineLog = new double[BINS][DISTANCESEGMENTS][NEARWALLSEGMENTS]
													[ACCELERATIONSEGMENTS][LATERALHEADINGSEGMENTS][TIMESINCESHOTSEGMENTS]
													[VELOCITYSEGMENTS][TDIRECTIONCHANGESEGMENTS];
	static double[][][] quickLog = new double[BINS][DISTANCESEGMENTS][NEARWALLSEGMENTS];
	
	static double[][][][][][] rangLog = new double[BINS][DISTANCESEGMENTS][NEARWALLSEGMENTS][LATERALHEADINGSEGMENTS]
											[VELOCITYSEGMENTS][TDIRECTIONCHANGESEGMENTS];
	
	static long shotTime;
	
	static int distanceSegment = 0;
	static int nearWallSegment = 0;
	static int accelerationSegment = 0;
	static int lateralHeadSegment = 0;
	static int timeSinceShotSegment = 0;
	static int velocitySegment = 0;
	static int tDirectionChangeSegment = 0;
	static int ourNearWallSegment = 0;
	static int ourLateralHeadingSegment = 0;
	static int ourVelocitySegment = 0;
	static int ourTDirectionChangeSegment = 0;
	
	static Rectangle2D.Double playField;
	static int wallConsideration = 18;
	
	static double newBearing, oldBearing;
	static double newDeltaBearing, oldDeltaBearing;
	
/*	static double totalRadarTurn = Math.PI/25;
	static double avgRadarTurn = 2*Math.PI;
	static double radarInstances;
*/	
	static long fireTime = 200;
	
	static boolean quickLogShot = true;
	static float quickLogShots = 0;
	static float totalShots = 0;
	static float oldTotalShots = 0;
	static float theoryShots = 0;	

	static boolean orientated = false;
	
	static float roundNumber;

	static float timeOfLastShot;
	
	Color purple = Color.getHSBColor(.8f,.9f,.8f);
	
	static float timeSinceDirectionChange = 0;
	static float ourTimeSinceDirectionChange = 0;
	
	static int lateralDirection = 1;
	static double lateralVelocity  = 0;
	static int lastLateralDirection = 1;
	
	static double currDanger, nextDanger, lastDanger;
	
	static double lateralHeading;
	
	static boolean FIRING = true;
	static boolean MOVING = true;
	static boolean CAREFUL = true;
	static boolean FLATTEN = false;
	
	static float theirShots = 0;
	static float theirHits = 1;
	
	static boolean emptySurf;
	static int emptyDirection = 1;
	
	static double surfDir = 1;
	
	static float numSaves = 0;
	
	static double totalSaveAmount = 0;
	
	static double theoryRangs;
	static double realRangs;
	static double totalRangSaveAmount = 0;
	

	public void run() {
	

		setColors(Color.white,purple,Color.green);
		setBulletColor(Color.green);
		
		_whipGroup = new ArrayList<VineWave>();
		_rangGroup = new ArrayList<Batarang>();
		_positionGroup = new ArrayList<Point2D.Double>();
		
		playField = new Rectangle2D.Double(wallConsideration,wallConsideration,
			getBattleFieldWidth()-2*wallConsideration,getBattleFieldHeight()-2*wallConsideration);
			
		//playField = new Rectangle2D.Double(50,50,getBattleFieldWidth()-100,getBattleFieldHeight()-100);

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		
		desiredLoc = new Point2D.Double(getX(),getY());

//		setTurnRadarRightRadians(2*Math.PI);

		roundNumber ++;
		
		// Robot main loop
		while(true) {
			turnRadarRight(Double.POSITIVE_INFINITY);
		}
	}
	
	void update(){
	

			ourLocation = new Point2D.Double(getX(),getY());
			
			trackVinesAndRangs();

		//	whipVine(false);
			
			
		//	out.println(_whipGroup.size());
			long realTestCount = 0;
			if(FIRING){
			for(int i = 0; i < _whipGroup.size(); i ++){
				VineWave realTest = _whipGroup.get(i);
				if(realTest.real) realTestCount ++;
			}

			if(enemy.energy<=getEnergy()||!CAREFUL){
			if(fireTime==getTime()&getGunHeat()==0&getGunTurnRemaining()==0&(getEnergy()>=vinePower|!CAREFUL)/*&&_whipGroup.size()==0*/){
				whipVine(true,vinePower);
				timeOfLastShot = getTime();
				totalShots ++;
				if(quickLogShot) quickLogShots ++;
			} }
			else if(CAREFUL){
			if(fireTime==getTime()&&getGunHeat()==0&&getGunTurnRemaining()==0&&(getEnergy()>=vinePower)&&realTestCount==0/*&&_whipGroup.size()==0*/){
				whipVine(true,vinePower);
				timeOfLastShot = getTime();
				totalShots ++;
				if(quickLogShot) quickLogShots ++;
			} } }
			
			timeSinceShotSegment = (int)Math.round((getTime() - timeOfLastShot) / (/*8d/(Math.abs(enemy.velocity)+1)*/3d));
			timeSinceShotSegment = (int)limit(0, timeSinceShotSegment, TIMESINCESHOTSEGMENTS-1);
			
			tDirectionChangeSegment = (int)Math.round(timeSinceDirectionChange / 3d);
			tDirectionChangeSegment = (int)limit(0, tDirectionChangeSegment, TDIRECTIONCHANGESEGMENTS-1);
			
			ourTDirectionChangeSegment = (int)Math.round(ourTimeSinceDirectionChange / 3d);
			ourTDirectionChangeSegment = (int)limit(0, ourTDirectionChangeSegment, TDIRECTIONCHANGESEGMENTS-1);
			
			
			if(FIRING){
			if(getEnergy()>=vinePower&&oldTotalShots==totalShots&&timeSinceShotSegment!=0){
				whipVine(false,vinePower);
				theoryShots ++;
		//		out.println(timeSinceShotSegment);
			} }

			oldTotalShots = totalShots;
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
	
//		radarInstances ++;
		timeSinceDirectionChange ++;
		ourTimeSinceDirectionChange ++;
		
		update();

		enemy.name = e.getName();
		
		enemy.bearing = e.getBearingRadians();
		heading = getHeadingRadians();
		enemy.distance = e.getDistance();
		enemy.absBearing = (NormaliseBearing(enemy.bearing+heading));
		enemy.velocity = e.getVelocity();
		enemy.lateralHeading = e.getHeadingRadians() - enemy.absBearing;
		enemy.lateralVelocity = enemy.velocity * Math.sin(enemy.lateralHeading);
		
		enemy.lateralDirection = (int)(enemy.lateralVelocity>=0?1:-1);
		if(enemy.lateralVelocity==0) enemy.lateralDirection = enemy.recentDirection;
		
		if(enemy.lateralDirection!=enemy.recentDirection) timeSinceDirectionChange = 0;
		
		enemy.recentDirection = enemy.lateralDirection;
		
		enemy.position = project(ourLocation,enemy.absBearing,enemy.distance);
		
		enemy.absBearingToUs = absoluteBearing(enemy.position, ourLocation);
		
		newBearing = enemy.absBearing;
		newDeltaBearing = newBearing-oldBearing;
		oldBearing = newBearing;
		

		setTurnRadarRightRadians(Utils.normalRelativeAngle(enemy.absBearing - getRadarHeadingRadians())*2);

		///////////////////////
		lateralVelocity = getVelocity() * Math.sin(enemy.bearing);
		lateralDirection = (lateralVelocity>=0?1:-1);
		if(lateralVelocity == 0) lateralDirection = lastLateralDirection;
		if(lastLateralDirection != lateralDirection) ourTimeSinceDirectionChange = 0;
		lastLateralDirection = lateralDirection;
		
		lateralHeading = Utils.normalRelativeAngle(getHeadingRadians() - enemy.absBearingToUs);
		
		boolean theoryTravel = true;

		double energyDelta = enemy.energy - e.getEnergy();
		if(energyDelta > 0 && energyDelta <= 3){
			catalogBatarang(energyDelta, true);
			realRangs ++;
		}
		if(theoryTravel){
			catalogBatarang((float)(Math.random()*3), false);
			theoryRangs ++;
		}
		
		
		enemy.energy = e.getEnergy();
		
		distanceSegment = (int)limit(0,(int)Math.ceil(enemy.distance/(getBattleFieldWidth()/new Double(DISTANCESEGMENTS).doubleValue())),DISTANCESEGMENTS-1);
		
		Point2D.Double enemyProjection = project(enemy.position, Utils.normalRelativeAngle(e.getHeadingRadians()+(e.getVelocity()>=0?0:Math.PI)),
							enemy.position.distance(ourLocation)/(20-3*vinePower)*Math.abs(e.getVelocity()));
		nearWallSegment = (playField.contains(enemyProjection)?0:1);
		
		accelerationSegment = accelSegment(newDeltaBearing,oldDeltaBearing);
	
		lateralHeadSegment = (int)limit(0,(Math.round(Math.abs(enemy.lateralHeading / (Math.PI/2)) *
			(new Double(LATERALHEADINGSEGMENTS-1).doubleValue()))),LATERALHEADINGSEGMENTS-1);
		
		oldDeltaBearing = newDeltaBearing;
		
		velocitySegment = (int)limit(0,Math.ceil(enemy.velocity/2),VELOCITYSEGMENTS-1);
		
		//vinePower = limit(1,getEnergy(),3);
		if(MOVING){
		if(e.getEnergy() >= 3){
			vinePower = limit(.1,(((e.getVelocity()) + (5/(e.getDistance()/getBattleFieldWidth())) + (e.getEnergy()/getEnergy())) / 3),3);
		}
		else{
			vinePower = e.getEnergy()/3;
		}
		}

		if(getGunHeat()==0&&(getEnergy()>=vinePower|!CAREFUL)/*&&getGunTurnRemaining()==0*/){
			fireTime=getTime()+1;
		}
		
		Point2D.Double ourProjection = project(ourLocation, getHeadingRadians(), (enemy.position.distance(ourLocation)/(20))*getVelocity());
		ourNearWallSegment = (playField.contains(ourProjection)?0:1);
		ourLateralHeadingSegment = (int)limit(0,(Math.round(Math.abs(lateralHeading / (Math.PI/2)) *
			(new Double(LATERALHEADINGSEGMENTS-1).doubleValue()))),LATERALHEADINGSEGMENTS-1);
		ourVelocitySegment = (int)limit(0,Math.ceil(getVelocity()/2),VELOCITYSEGMENTS-1);
		
		if(MOVING)
		flexOnBatman();
		
		Entangle();
		

		execute();
	}
	
	int accelSegment(double deltaBearing, double oldDeltaBearing) {
        int delta = (int)(Math.round(5 * enemy.distance * (Math.abs(deltaBearing) - Math.abs(oldDeltaBearing))));
        if (delta < 0) {
            return 0;
        } else if (delta > 0) {
            return 2;
        }
        return 1;
    }
	
	public void whipVine(boolean realBullet, double bPower){
	
		VineWave vine = new VineWave();
		vine.targetName = enemy.name;
		vine.bearing = enemy.absBearing;
		vine.distance = enemy.distance;
		vine.distanceTraveled = 0;
		vine.targetLoc = enemy.position;
		vine.time = getTime();
		vine.direction = enemy.lateralDirection;
		vine.vineSpeed = 20-3*bPower;
		vine.shotLoc = ourLocation;
		vine.maxEscapeAngle = Math.asin(8/vine.vineSpeed)*vine.direction;
		vine.minBearingOffset = vine.bearing-vine.maxEscapeAngle;
		vine.maxBearingOffset = vine.bearing+vine.maxEscapeAngle;
		vine.distanceSeg = distanceSegment;
		vine.nearWallSeg = nearWallSegment;
		vine.accelSeg = accelerationSegment;
		vine.headSeg = lateralHeadSegment;
		vine.real = realBullet;
		vine.vSeg = velocitySegment;
		vine.timeSeg = timeSinceShotSegment;
		vine.tDSeg = tDirectionChangeSegment;
		
		
		_whipGroup.add(vine);

	//	shotTime = getTime();
		if(vine.real)
		setFire(bPower);

	}
	
	public void Entangle(){
	
		int targetBin = getHeaviestBin();
		
		double binOffset = (targetBin - MIDBIN) * enemy.lateralDirection;
		binOffset /= new Double(MIDBIN);
		double theta = NormaliseBearing(binOffset*Math.asin(8/(20-3*vinePower))+enemy.absBearing);
		
		setTurnGunRightRadians(NormaliseBearing(theta - getGunHeadingRadians()));
		
//		out.println("heavyBin: " + targetBin);

	}
	
	public int getHeaviestBin(){
		double weight = 0; int heavyBin = 0;
		
/*		double botWidth = Math.asin(18/(enemy.position.distance(ourLocation)));
		double binWidth = Math.asin(8/(20-3*vinePower))/(new Double(BINS).doubleValue());
		
		int deltaBin = new Double(Math.ceil(Math.abs(botWidth/binWidth))+1).intValue();
		int lowBin = (int)limit(0,MIDBIN - deltaBin,MIDBIN);
		int highBin = (int)limit(MIDBIN,MIDBIN + deltaBin,BINS-1);
		
		out.println("deltaBin : " + deltaBin);
		
		double tempWeight; 

		for(int i = 0; i < BINS; i ++){
			tempWeight = 0;
			lowBin = (int)limit(0,i - deltaBin,i);
			highBin = (int)limit(i,i + deltaBin,BINS-1);
			for(int q = lowBin; q <= highBin; q ++){
				tempWeight += vineLog[q];
			}
			if(tempWeight>weight){
				weight = tempWeight;
				heavyBin = i;
			} */
			/*if(tempWeight>weight){
				weight = tempWeight;
				heavyBin = i;
			} */

	//	} 
		weight = 0;
		for(int i = 0; i <= BINS-1; i ++){
			if(vineLog[i][distanceSegment][nearWallSegment][accelerationSegment][lateralHeadSegment][timeSinceShotSegment]
										[velocitySegment][tDirectionChangeSegment]>=weight){
				weight = vineLog[i][distanceSegment][nearWallSegment][accelerationSegment][lateralHeadSegment]
											[timeSinceShotSegment][velocitySegment][tDirectionChangeSegment];
				heavyBin = i;
			}
		}
		if(weight==0||heavyBin==(BINS-1)){ quickLogShot=true;
		//weight = 0;
			for(int i = 0; i <= BINS-1; i ++){
				if(quickLog[i][distanceSegment][nearWallSegment]>=weight){
					weight = quickLog[i][distanceSegment][nearWallSegment];
					heavyBin = i;
				}
			}
		}
		else quickLogShot = false;
		return heavyBin;
	}
	
	public void trackVinesAndRangs(){
	
		for(int i = 0; i < _whipGroup.size(); i ++) {	
			VineWave vine = _whipGroup.get(i);
			vine.distanceTraveled = vine.vineSpeed * (getTime() - vine.time);
			if(vine.distanceTraveled >= vine.shotLoc.distance(enemy.position)){
				saveVineData(vine);
				_whipGroup.remove(i);
				i--;
			}
		}
		
		for(int i = 0; i < _rangGroup.size(); i ++){
			Batarang rang = _rangGroup.get(i);
			rang.distanceTraveled = rang.rangSpeed * (getTime() - rang.time);
			if(rang.distanceTraveled >= rang.shotLoc.distance(ourLocation) + 18){
				if(FLATTEN) flatten(rang,ourLocation);
			//	logHit(ourLocation);
				_rangGroup.remove(i);
				i--;
			}
		}

	}
	

	public void saveVineData(VineWave saver){
		
		int bin = getResultVineBin(saver,enemy.position);
		
	//	out.println("saving : " + bin);
	//	out.println("whipG size: " + _whipGroup.size());
	/*	double botWidth = Math.asin(18/(enemy.position.distance(ourLocation)));
		double binWidth = Math.asin(8/saver.vineSpeed)/(new Double(BINS).doubleValue());
		
		int deltaBin = new Double(Math.ceil(Math.abs(botWidth/binWidth))+1).intValue();
		int lowBin = (int)limit(0,bin - deltaBin,bin);
		int highBin = (int)limit(bin,bin + deltaBin,BINS-1); */
		
/*		if(lowBin == 0) bin = deltaBin;
		if(highBin > BINS-1) bin = BINS - deltaBin - 1;
		lowBin = (int)limit(0,bin - deltaBin,bin);
		highBin = (int)limit(bin,bin + deltaBin,BINS-1);
*/		
	//	for(int i = lowBin; i <= highBin; i ++){
		double modifier = 1;// if(saver.real) modifier/=2;
		float theoryShotWeightRatio = theoryShots/*totalShots/(theoryShots+totalShots) * theoryShots*/;
	//	if(saver.real) numSaves++;
		numSaves ++;
		if(!saver.real){
	//	for(int b = 0; b < BINS; b ++){
			vineLog[bin][saver.distanceSeg][saver.nearWallSeg][saver.accelSeg][saver.headSeg][saver.timeSeg][saver.vSeg][saver.tDSeg] += 1;// / (theoryShotWeightRatio/roundNumber);
			quickLog[bin][saver.distanceSeg][saver.nearWallSeg] += 1;// / (theoryShotWeightRatio/roundNumber);
			
		/*	for(int t = 0; t < TIMESINCESHOTSEGMENTS; t ++){
				vineLog[bin][saver.distanceSeg][saver.nearWallSeg][saver.accelSeg][saver.headSeg][t][saver.vSeg] += (1/(Math.pow(t-saver.timeSeg,2)+1));
			} */
	//		out.println("logging at bin: " + bin);
		}// }
//		theoryShotWeightRatio = 1;
//	for(int i = 0; i < BINS; i ++){
//			modifier = (theoryShotWeightRatio/(Math.pow(bin-i,2)+1)) ;
					/* (((1/(Math.pow((lateralHeadSegment-saver.headSeg),2)+1)) +
						(1/(Math.pow((distanceSegment - saver.distanceSeg),2+1)) +
						(1/(Math.pow((nearWallSegment - saver.nearWallSeg),2)+1)) +
						(1/(Math.pow((accelerationSegment - saver.accelSeg),2)+1)) +
						(1/(Math.pow((timeSinceShotSegment - saver.timeSeg),2)+1)) +
						(1/(Math.pow((velocitySegment - saver.vSeg),2)+1)))) ); */

	//	if(!saver.real){
//			vineLog[i][saver.distanceSeg][saver.nearWallSeg][saver.accelSeg][saver.headSeg][saver.timeSeg][saver.vSeg][saver.tDSeg] += modifier;// / (theoryShotWeightRatio/roundNumber);
//			quickLog[i][saver.distanceSeg][saver.nearWallSeg] += modifier;// / (theoryShotWeightRatio/roundNumber);
	//	}
	/*	if(saver.real){
			vineLog[i][saver.distanceSeg][saver.nearWallSeg][saver.accelSeg][saver.headSeg][saver.timeSeg][saver.vSeg] += modifier;
			quickLog[i][saver.distanceSeg][saver.nearWallSeg] += modifier;
		} */
		
//		}
		
		if(saver.real){
		double saveRatio = Math.sqrt((theoryShots-totalSaveAmount));
	//	double saveRatio = 1;
		out.println(saveRatio + " : saveRatio");
		totalSaveAmount += saveRatio*saveRatio;
//		if(false){
	//	out.println("savingRealShots");
		for(int i = 0; i < BINS; i ++){
	//		vineLog[i] *= (1/(Math.pow(bin-i,2)+1));
		//	modifier = (1/(Math.pow(bin-i,2)+1)) / (theoryShotWeightRatio/roundNumber);
		//	modifier = (1/(Math.pow(bin-i,2)+1)) / (theoryShotWeightRatio/roundNumber);
	//		vineLog[i] *= .8;
	//		if(!saver.real){
		//	vineLog[i][saver.distanceSeg][saver.nearWallSeg][saver.accelSeg][saver.headSeg][saver.timeSeg] += modifier;//[saver.distanceSeg][saver.nearWallSeg][saver.accelSeg][saver.headSeg] += modifier;
		//	quickLog[i][saver.distanceSeg][saver.nearWallSeg] += modifier;
	//		}
			modifier = (saveRatio/(Math.pow(bin-i,2)+1));// / (totalShots/roundNumber);
	//		vineLog[i][saver.distanceSeg][saver.nearWallSeg][saver.accelSeg][saver.headSeg][saver.timeSeg][saver.vSeg][saver.tDSeg] += modifier;
	//		quickLog[i][saver.distanceSeg][saver.nearWallSeg] += modifier;
	//	}
/*	static final int DISTANCESEGMENTS = 5;
	static final int NEARWALLSEGMENTS = 3;
	static final int ACCELERATIONSEGMENTS = 3;
	static final int LATERALHEADINGSEGMENTS = 5;
	static final int VELOCITYSEGMENTS = 5;
	static final int TIMESINCESHOTSEGMENTS = 15;
	static final int TDIRECTIONCHANGESEGMENTS = 15;*/
		for(int d = 0; d < DISTANCESEGMENTS; d ++){

			vineLog[i][d][saver.nearWallSeg][saver.accelSeg][saver.headSeg][saver.timeSeg][saver.vSeg][saver.tDSeg] = (saveRatio/(Math.pow(d-saver.distanceSeg,2)+1)) * modifier * 1/46;
			quickLog[i][d][saver.nearWallSeg] += (saveRatio/(Math.pow(d-saver.distanceSeg,2)+1)) * modifier * 1/3;	

		} 
		for(int nw = 0; nw < NEARWALLSEGMENTS; nw ++){
				vineLog[i][saver.distanceSeg][nw][saver.accelSeg][saver.headSeg][saver.timeSeg][saver.vSeg][saver.tDSeg] += (saveRatio/(Math.pow(nw-saver.nearWallSeg,2)+1)) * modifier * 1/48;			
		//	quickLog[i][d][nw] += modifier;
	//		quickLog[i][d][nw] += modifier;
		//	quickLog[i][saver.distanceSeg][nw] += (1/(Math.pow(nw-saver.nearWallSeg,2)+1)) * modifier;
			quickLog[i][saver.distanceSeg][nw] += (saveRatio/(Math.pow(nw-saver.nearWallSeg,2)+1)) * modifier * 1/5;
		}
		for(int a = 0; a < ACCELERATIONSEGMENTS; a ++){

		vineLog[i][saver.distanceSeg][saver.nearWallSeg][a][saver.headSeg][saver.timeSeg][saver.vSeg][saver.tDSeg] += (saveRatio/(Math.pow(a-saver.accelSeg,2)+1)) * modifier * 1/48;
		
		}
		for(int h = 0; h < LATERALHEADINGSEGMENTS; h ++){
			
			vineLog[i][saver.distanceSeg][saver.nearWallSeg][saver.accelSeg][h][saver.timeSeg][saver.vSeg][saver.tDSeg] += (saveRatio/(Math.pow(h-saver.headSeg,2)+1)) * modifier * 46;
		}
		
		for(int t = 0; t < TIMESINCESHOTSEGMENTS; t ++){
			
	/*		vineLog[i][d][nw][a][h][t] += (1/(Math.pow(nw-saver.nearWallSeg,2)+1)) * (1/(Math.pow(a-saver.accelSeg,2)+1)) *
					(1/(Math.pow(d-saver.distanceSeg,2)+1)) * (1/(Math.pow(h-saver.headSeg,2)+1)) *
						(1/(Math.pow(t-saver.timeSeg,2)+1)) * modifier; */
			vineLog[i][saver.distanceSeg][saver.nearWallSeg][saver.accelSeg][saver.headSeg][t][saver.vSeg][saver.tDSeg] += (saveRatio/(Math.pow(t-saver.timeSeg,2)+1)) * modifier * 1/36;
		}
		for(int v = 0; v < VELOCITYSEGMENTS; v ++){
			
			vineLog[i][saver.distanceSeg][saver.nearWallSeg][saver.accelSeg][saver.headSeg][saver.timeSeg][v][saver.tDSeg] += (saveRatio/(Math.pow(v-saver.vSeg,2)+1)) * modifier * 1/46;
		}
		for(int td = 0; td < TDIRECTIONCHANGESEGMENTS; td ++){

			vineLog[i][saver.distanceSeg][saver.nearWallSeg][saver.accelSeg][saver.headSeg][saver.timeSeg][saver.vSeg][td] += (saveRatio/(Math.pow(td-saver.tDSeg,2)+1)) * modifier * 1/36;
		
		}		
	//	}					
	//	}
	//	}
	//	} 
		}
		}
	//	vineLog[bin] += 1;
	}
	
	public int getResultVineBin(VineWave saver, Point2D.Double position){
		
		double angleOffset = NormaliseBearing(absoluteBearing(saver.shotLoc,enemy.position) - saver.bearing);
		double escapedAnglePercent = angleOffset/saver.maxEscapeAngle;
		int bin = (int)Math.round(limit(0, escapedAnglePercent*MIDBIN + MIDBIN,BINS-1));

		return bin;
	}
/////////////////////////////////////////////////////////////////////
/////////////////////MOVEMENT CODE///////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

	public void catalogBatarang(double energyDelta, boolean real){
		
		Batarang rang = new Batarang();
		rang.absBearingToUs = enemy.absBearingToUs;
		rang.rangPower = energyDelta;
		rang.rangSpeed = 20-3*rang.rangPower;
 		rang.distance = enemy.distance;
		rang.distanceTraveled = rang.rangSpeed;
		rang.ourLoc = ourLocation;
		rang.shotLoc = enemy.position;
		rang.time = getTime()-1;
		rang.direction = lateralDirection;
		rang.maxEscapeAngle = Math.asin(8/rang.rangSpeed) * rang.direction;
		rang.maxBearingOffset = NormaliseBearing(rang.absBearingToUs + rang.maxEscapeAngle);
		rang.minBearingOffset = NormaliseBearing(rang.absBearingToUs - rang.maxEscapeAngle);
		rang.distSeg = distanceSegment;
		rang.headSeg = ourLateralHeadingSegment;
		rang.vSeg = ourVelocitySegment;
		rang.nearWallSeg = ourNearWallSegment;
		rang.tDSeg = ourTDirectionChangeSegment;
		rang.isReal = real;
		
		theirShots ++;
		
		_rangGroup.add(rang);
	}
	
	public Batarang getClosestBatarang(){
		Batarang closeRang = null;
		double distance = 1000000;
		for(int i = 0; i < _rangGroup.size(); i ++){
			Batarang testRang = _rangGroup.get(i);
			if(testRang.isReal){
			if((ourLocation.distance(testRang.shotLoc)-testRang.distanceTraveled)<distance){
				closeRang = testRang;
				distance = (ourLocation.distance(testRang.shotLoc)-testRang.distanceTraveled);
			}}
		}
		return closeRang;
	}
	
	public Batarang getClosestSurfableBatarang(){
		Batarang closeRang = null;
		double testDistance, timeTillHit = 1000000;
		for(int i = 0; i < _rangGroup.size(); i ++){
			Batarang testRang = _rangGroup.get(i);
			testRang.isActive = false;
			if(testRang.isReal){
			testDistance = (ourLocation.distance(testRang.shotLoc)-testRang.distanceTraveled);
			if(testDistance/testRang.rangSpeed < timeTillHit && testDistance > testRang.rangSpeed){
				closeRang = testRang;
				timeTillHit = testDistance/testRang.rangSpeed;
			} }
		}
		if(closeRang!=null) closeRang.isActive = true;
		return closeRang;
	}
	
	public double getDanger(Point2D.Double position, Batarang rang){
		double danger = 0;
		int bin, deltaBin, lowBin, highBin;
		double botWidth, binWidth, distanceOut=1;
	//	for(int i = 0; i < _rangGroup.size(); i ++){
	//		rang = _rangGroup.get(i);
		if(rang!=null&&rang.isReal){
			bin = getRangBin(position,rang);
			
			botWidth = Math.asin(36/(rang.shotLoc.distance(position)))/2;
			binWidth = Math.abs(rang.maxEscapeAngle)/(new Double(MIDBIN).doubleValue());
		
			deltaBin = new Double(Math.ceil(Math.abs(botWidth/binWidth))+1).intValue();
			//deltaBin = new Double(botWidth%binWidth + Math.ceil(botWidth/binWidth)).intValue();
			
			lowBin = bin - deltaBin; highBin = bin + deltaBin;
		
		/*	if(lowBin <= 0) bin = deltaBin;
			if(highBin >= BINS-1) bin = BINS - deltaBin - 1; */
		
		//	lowBin = (int)limit(0,bin - deltaBin,bin);
		//	highBin = (int)limit(bin,bin + deltaBin,BINS-1);
			
//			int tempLowBin = lowBin;
//			int tempHighBin = highBin;
			
	//		boolean duplicated = false;
			
	//		if(lowBin < 0 || highBin > BINS-1)
	//		duplicated = true;
			
			///lowBin = (int)limit(0,Math.abs(bin - deltaBin),bin);
			///highBin = (int)limit(bin,Math.abs(bin + deltaBin),BINS-1);

			distanceOut = Math.pow(rang.shotLoc.distance(position) - rang.distanceTraveled,2);
			
			int c = 0;
			for(int b = lowBin; b <= highBin; b ++){
				c = b;
				if((b)<0)
				c = 0;
				if(b>BINS-1)
				c = BINS-1;
				danger += rangLog[c][rang.distSeg][rang.nearWallSeg][rang.headSeg][rang.vSeg][rang.tDSeg] / (distanceOut) * Math.pow(rang.rangPower,2);
			//	if(duplicated) b--;
	//			c = b;
			}

		//	danger += rangLog[bin][rang.distSeg][rang.nearWallSeg][rang.headSeg][rang.vSeg][rang.tDSeg] / (distanceOut);
		}
	//	}
		return danger;
	}

	public void flexOnBatman(){
		Batarang rang = getClosestSurfableBatarang();
		double turnAmount = getTurnAmount(ourLocation, enemy.position, sign(getVelocity()), getHeadingRadians());
		double goDistance = getVelocity();
		if(rang!=null){
			
			emptySurf = false;

		//	int Dir = surfDir;
		//	if(ourLocation.distance(desiredLoc)<=Math.abs(getVelocity()));
			desiredLoc = setPosition(rang);
		
			int currBin = getRangBin(ourLocation,rang);
			int stopBin = getRangBin(desiredLoc,rang);
			
		//	if(currBin>stopBin) Dir = (int)new Double(-1*rang.direction).intValue();
		//	if(stopBin>currBin) Dir = (int)new Double(rang.direction).intValue();
			
		//	turnAmount = getTurnAmount(ourLocation, rang.shotLoc, sign(getVelocity()), getHeadingRadians());
			
			goDistance = desiredLoc.distance(ourLocation);
			
			turnAmount = NormaliseBearing(Utils.normalRelativeAngle(absoluteBearing(ourLocation, desiredLoc)) - getHeadingRadians());
			
	//		turnAmount = NormaliseBearing(angleToPoint - getHeadingRadians());

			setMaxVelocity(8);
			
			if(Math.abs(turnAmount)>PI/2){
				goDistance *= -1;
				if(turnAmount>PI/2) turnAmount -= PI;
				if(turnAmount<-PI/2) turnAmount += PI;
			}
		//	out.println("idealBin : " + (stopBin-MIDBIN));
	//		if(getDanger(ourLocation,rang)<=getDanger(desiredLoc,rang)){//stopBin==currBin){
	//			setMaxVelocity(0);}// out.println("stopping at bin: " + (currBin-MIDBIN)); }
			
			//BasicGTSurfer's hacked way
			setAhead(goDistance);
			
			emptyDirection = lateralDirection;			
		//	if(FLATTEN) flatten(rang,ourLocation);
			
		//	if(FLATTEN)
		//	flatten(rang,desiredLoc);
		}
		else { emptySurf = true; }
		
		setTurnRightRadians(turnAmount*Math.signum(Math.abs((int)goDistance)));
		
		if(emptySurf){
			setAhead(160*emptyDirection);
			setMaxVelocity(PI/getTurnRemainingRadians());
			Point2D.Double nextPos = project(ourLocation,getHeadingRadians(),160*emptyDirection);
			if(!playField.contains(nextPos)&&enemy.position.distance(nextPos)<enemy.distance)
		    emptyDirection*=-1;
		}
	}
	
	public double getTurnAmount(Point2D.Double position, Point2D.Double rotationLocation, double dir, double heading){
		
		double absBearingToIncident = absoluteBearing(position,rotationLocation);
		double tangentLine = Utils.normalRelativeAngle(absBearingToIncident - PI/2 - PI/8*dir);
		double turnAmount = NormaliseBearing(tangentLine - heading);
		
		Point2D.Double projectPosition = project(position,Utils.normalRelativeAngle(heading+turnAmount),160*dir);
		long itterations = 0;
		
		while(!playField.contains(projectPosition)){
			turnAmount += .01*dir;
			projectPosition = project(position,Utils.normalRelativeAngle(heading+turnAmount),160*dir);
			itterations ++;
			if(itterations>500) break;
		}
		
		return NormaliseBearing(turnAmount);
	}
	
	public void logHit(Point2D.Double bulletPosition){
		
		//Point2D.Double bulletPosition = new Point2D.Double(bullet.getX(),bullet.getY());
		Batarang rang = getClosestBatarang();
		theirHits++;

		if(rang!=null){
			double saveRatio = Math.sqrt((theoryRangs-totalRangSaveAmount));
			totalRangSaveAmount += saveRatio*saveRatio;
			double multiplier;
			int hitBin = getRangBin(bulletPosition, rang);
			out.println("hit at bin : " + (hitBin-MIDBIN));
			for(int i = 0; i < BINS; i ++){
				
				multiplier = saveRatio/(Math.pow(i-hitBin,2)+1);
		//		if(FLATTEN)
		//		multiplier = (theirShots/theirHits)/(Math.pow(i-hitBin,2)+1);
				rangLog[i][rang.distSeg][rang.nearWallSeg][rang.headSeg][rang.vSeg][rang.tDSeg] += multiplier;
				
				for(int d = 0; d < DISTANCESEGMENTS; d ++){
					rangLog[i][d][rang.nearWallSeg][rang.headSeg][rang.vSeg][rang.tDSeg] += saveRatio/(Math.pow(d-rang.distSeg,2)+1) * multiplier;
				}
				for(int w = 0; w < NEARWALLSEGMENTS; w ++){
					rangLog[i][rang.distSeg][w][rang.headSeg][rang.vSeg][rang.tDSeg] += saveRatio/(Math.pow(w-rang.nearWallSeg,2)+1) * multiplier;
				}
				for(int h = 0; h < LATERALHEADINGSEGMENTS; h ++){
					rangLog[i][rang.distSeg][rang.nearWallSeg][h][rang.vSeg][rang.tDSeg] += saveRatio/(Math.pow(h-rang.headSeg,2)+1) * multiplier;
				}
				for(int v = 0; v < VELOCITYSEGMENTS; v ++){
					rangLog[i][rang.distSeg][rang.nearWallSeg][rang.headSeg][v][rang.tDSeg] += saveRatio/(Math.pow(v-rang.vSeg,2)+1) * multiplier;

				}
				for(int td = 0; td < TDIRECTIONCHANGESEGMENTS; td ++){
					rangLog[i][rang.distSeg][rang.nearWallSeg][rang.headSeg][rang.vSeg][td] += saveRatio/(Math.pow(td-rang.tDSeg,2)+1) * multiplier;
		//			rangLog[i][d][w][h][v][td] += 1/(Math.pow(d-rang.distSeg,2)+1) * 1/(Math.pow(w-rang.nearWallSeg,2)+1) *
		//										1/(Math.pow(h-rang.headSeg,2)+1)* 1/(Math.pow(v-rang.vSeg,2)+1) * 1/(Math.pow(td-rang.tDSeg,2)+1) * multiplier;
				}
	//}}}}
			}
		
		}
	}
	
	public int getRangBin(Point2D.Double bPos, Batarang rang){
		
		double bearingOffsetPercent = Utils.normalRelativeAngle(absoluteBearing(rang.shotLoc,bPos)-rang.absBearingToUs)/rang.maxEscapeAngle;
		int bin = ((int)Math.round(bearingOffsetPercent*MIDBIN)+MIDBIN);
		
		return bin;
	}
	
	public Point2D.Double setPosition(Batarang rang){
		
	//	Point2D.Double nextLocation = anticipateMovement(ourLocation, new Double(-1*rang.direction).intValue(), rang);
	//	Point2D.Double backLocation = anticipateMovement(ourLocation, new Double(rang.direction).intValue(), rang);
	//	anticipateMovement(ourLocation, new Double(-1*rang.direction).intValue(), rang);
	//	anticipateMovement(ourLocation, new Double(1*rang.direction).intValue(), rang);
		ArrayList<Point2D.Double> _forwardMoves = anticipateMovement(ourLocation, new Double(rang.direction).intValue(), rang);
		ArrayList<Point2D.Double> _backwardMoves = anticipateMovement(ourLocation, new Double(-1*rang.direction).intValue(), rang);
		
		Point2D.Double possibleStopPoint = ourLocation;
		Point2D.Double stopPoint = _backwardMoves.get(_backwardMoves.size()-1);
		
	//	if (getRangBin(stopPoint, rang)!=getRangBin(ourLocation,rang))
	//	if(stopPoint.distance(ourLocation)!=0)
	//	return stopPoint;
		
		double danger = Double.POSITIVE_INFINITY;
		double tempDanger = 0;
		

		for(int i = 0; i < _forwardMoves.size(); i ++){
			possibleStopPoint = (Point2D.Double)_forwardMoves.get(i);
			tempDanger = getDanger(possibleStopPoint, rang);
			if(tempDanger<danger){
				//BasticGTSurfer's requirement
		//		if(possibleStopPoint.distanceSq(ourLocation)>20*20*1.1){
					surfDir = rang.direction;
					danger = tempDanger;
					stopPoint = possibleStopPoint;
		//		}
			}
		}
		for(int i = 0; i < _backwardMoves.size(); i ++){
			possibleStopPoint = (Point2D.Double)_backwardMoves.get(i);
			tempDanger = getDanger(possibleStopPoint, rang);
			if(tempDanger<danger){
		//		if(possibleStopPoint.distanceSq(ourLocation)>20*20*1.1){
					danger = tempDanger;
					stopPoint = possibleStopPoint;
					surfDir = rang.direction*-1;
		//	 	}
			}
		}
		_positionGroup.clear();
		_forwardMoves.clear();
		_backwardMoves.clear();
		
	//	currDanger = getDanger(ourLocation, rang);
	//	nextDanger = getDanger(nextLocation, rang);
	//	lastDanger = getDanger(backLocation, rang);
		
		return stopPoint;

	}
	
	public ArrayList<Point2D.Double> anticipateMovement(Point2D.Double tempPosition, int direction, Batarang rang){
		
		boolean interrupted = false;
		long itterations = 1;
		double tempHeading = getHeadingRadians();
		ArrayList<Point2D.Double> _movePoints = new ArrayList<Point2D.Double>();
		double tempVelocity = getVelocity();
		double turnAmount;// = getTurnAmount(tempPosition,rang.shotLoc,direction*lateralDirection,heading);
		direction *= rang.direction;
		double maxTurn;
		_movePoints.add(ourLocation);
		
		do{
			
			if(tempVelocity!=0) {
			tempVelocity += (direction*tempVelocity>0?direction:2*direction); }
			else {
			tempVelocity = direction; }
			tempVelocity = limit(-8, tempVelocity, 8);
			
			turnAmount = NormaliseBearing(getTurnAmount(tempPosition,rang.shotLoc,sign(tempVelocity),tempHeading));

			maxTurn = PI/720d*(40d - 3d*Math.abs(tempVelocity));
			
			if(turnAmount>PI/2) { turnAmount -= PI; direction*=-1; }
			if(turnAmount<-PI/2) { turnAmount += PI; direction*=-1; }
			tempHeading += limit(-maxTurn,turnAmount,maxTurn);
			tempHeading = Utils.normalRelativeAngle(tempHeading);
			
			tempPosition = project(tempPosition,tempHeading,tempVelocity);
			
			_positionGroup.add(tempPosition);
			_movePoints.add(tempPosition);

			double distRangTraveled = itterations * rang.rangSpeed + rang.distanceTraveled;
			
			if(distRangTraveled>=tempPosition.distance(rang.shotLoc)-rang.rangSpeed*4) interrupted = true;

			//if(itterations > tempPosition.distance(rang.shotLoc)/rang.rangSpeed) break;
			
			itterations ++;
			
		}while(!interrupted);
		

	
		return _movePoints;
	}
	
	public void flatten(Batarang rang, Point2D.Double loc){
		int bin = (int)Math.round(Math.random() * ((BINS-1)));
		for(int i = 0; i < BINS; i ++){
			rangLog[i][rang.distSeg][rang.nearWallSeg][rang.headSeg][rang.vSeg][rang.tDSeg] += 1/(Math.pow(i-bin,2)+1);
		}
//		else
	//		rangLog[bin][rang.distSeg][rang.nearWallSeg][rang.headSeg][rang.vSeg][rang.tDSeg] += 1/(Math.pow(i-MIDBIN,2)+1);
	}

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {

		logHit(new Point2D.Double(e.getBullet().getX(),e.getBullet().getY()));

	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {

	}
	
	public void onDeath(DeathEvent e) {
		out.println("quickLogShots: " + quickLogShots);
		out.println("totalShots   : " + totalShots);
		out.println("percent QL/T : " + (quickLogShots/totalShots*100));
		out.println("theoryShots  : " + theoryShots);//(totalShots/(theoryShots+totalShots)*theoryShots));
		orientated = false;
	}
	public void onWin(WinEvent e) {
		out.println("quickLogShots: " + quickLogShots);
		out.println("totalShots   : " + totalShots);
		out.println("percent QL/T : " + (quickLogShots/totalShots)*100);
		out.println("theoryShots  : " + theoryShots);//(totalShots/(theoryShots+totalShots)*theoryShots));
		orientated = false;
	}
	




	double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }
	double absoluteBearing(double sourcex, double sourcey,double targetx,double targety){
		return Math.atan2(targetx - sourcex, targety - sourcey);
	}	
	Point2D.Double project(Point2D sourceLocation, double angle, double length) {
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
				sourceLocation.getY() + Math.cos(angle) * length);
	}
	double NormaliseBearing(double ang) {
		if (ang > PI)
			ang -= 2*PI;
		if (ang < -PI)
			ang += 2*PI;
		return Utils.normalRelativeAngle(ang);
	}
	double limit(double min, double value, double max){
		if(max>=min)
		return Math.min(Math.max(min,value),max);
		if(max<min)
		return Math.min(Math.max(max,value),min);
		return Math.min(Math.max(min,value),max);
	}
	int sign(double number){
		return (number>=0?1:-1);
	}
	

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

public void onPaint(Graphics2D g) {

	//	g.drawString("Fighting: " + enemy.name, 2, new Double(this.getBattleFieldHeight()).intValue()-10);
	g.setColor(Color.green);
	g.drawOval(new Double(getX() - 25).intValue(), new Double(getY() - 25).intValue(), 50, 50);
	double radius = 0;
	Point2D.Double midBin = ourLocation;
	Point2D.Double maxBin = ourLocation;
	Point2D.Double minBin = ourLocation;
	if(_whipGroup!=null)
	for(int i = 0; i < _whipGroup.size(); i ++){
		VineWave gW = (VineWave)_whipGroup.get(i);
		radius = gW.distanceTraveled+gW.vineSpeed;
		midBin = new Point2D.Double((radius*Math.sin(gW.bearing)) + gW.shotLoc.getX(), (radius*Math.cos(gW.bearing)) + gW.shotLoc.getY());
		maxBin = new Point2D.Double((radius*Math.sin(gW.maxBearingOffset)) + gW.shotLoc.getX(), (radius*Math.cos(gW.maxBearingOffset)) + gW.shotLoc.getY());
		minBin = new Point2D.Double((radius*Math.sin(gW.minBearingOffset)) + gW.shotLoc.getX(), (radius*Math.cos(gW.minBearingOffset)) + gW.shotLoc.getY());
	/*	if(!gW.real&& paintTheoryShots){
		g.setColor(Color.RED);
		g.drawOval(new Double(gW.shotLoc.getX() - (radius)).intValue(), new Double(gW.shotLoc.getY() - (radius)).intValue(), new Double(radius*2).intValue(), new Double(radius*2).intValue());
		g.setColor(Color.YELLOW);
		g.drawOval(new Double(midBin.x - 5).intValue(), new Double(midBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.BLUE);
		g.drawOval(new Double(maxBin.x - 5).intValue(), new Double(maxBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.WHITE);
		g.drawOval(new Double(minBin.x - 5).intValue(), new Double(minBin.y - 5).intValue(), 10, 10);
		}
		else*/ if(gW.real || paintTheoryShots){
		g.setColor(purple);
		g.drawOval(new Double(gW.shotLoc.getX() - (radius)).intValue(), new Double(gW.shotLoc.getY() - (radius)).intValue(), new Double(radius*2).intValue(), new Double(radius*2).intValue());
		g.setColor(Color.YELLOW);
		g.drawOval(new Double(midBin.x - 5).intValue(), new Double(midBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.BLUE);
		g.drawOval(new Double(maxBin.x - 5).intValue(), new Double(maxBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.WHITE);
		g.drawOval(new Double(minBin.x - 5).intValue(), new Double(minBin.y - 5).intValue(), 10, 10);
		}
	}
	for(int i = 0; i < _rangGroup.size(); i ++){
		Batarang gW = _rangGroup.get(i);
		radius = gW.distanceTraveled+gW.rangSpeed;
		if(gW.isReal || paintTheoryShots){
		midBin = new Point2D.Double((radius*Math.sin(gW.absBearingToUs)) + gW.shotLoc.getX(), (radius*Math.cos(gW.absBearingToUs)) + gW.shotLoc.getY());
		maxBin = new Point2D.Double((radius*Math.sin(gW.maxBearingOffset)) + gW.shotLoc.getX(), (radius*Math.cos(gW.maxBearingOffset)) + gW.shotLoc.getY());
		minBin = new Point2D.Double((radius*Math.sin(gW.minBearingOffset)) + gW.shotLoc.getX(), (radius*Math.cos(gW.minBearingOffset)) + gW.shotLoc.getY());
		
		if(gW.isActive) g.setColor(purple);
		else g.setColor(Color.green);
		g.drawOval(new Double(gW.shotLoc.getX() - (radius)).intValue(), new Double(gW.shotLoc.getY() - (radius)).intValue(), new Double(radius*2).intValue(), new Double(radius*2).intValue());
		g.setColor(Color.YELLOW);
		g.drawOval(new Double(midBin.x - 5).intValue(), new Double(midBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.BLUE);
		g.drawOval(new Double(maxBin.x - 5).intValue(), new Double(maxBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.WHITE);
		g.drawOval(new Double(minBin.x - 5).intValue(), new Double(minBin.y - 5).intValue(), 10, 10);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

	
}





class Alfred {
	
	String name;
	
	Point2D.Double position;
	double energy = 100d;
	double distance;
	double absBearing;
	double absBearingToUs;
	double bearing;
	double velocity;
	double lateralHeading;
	double lateralVelocity;
	
	int lateralDirection;
	int recentDirection;
	
	
}

class VineWave {
	
	String targetName;
	double bearing;
	double vineSpeed;
	double distance;
	double distanceTraveled;
	Point2D.Double targetLoc;
	double time;
	double direction;
	Point2D.Double shotLoc;
	double maxEscapeAngle;
	double maxBearingOffset;
	double minBearingOffset;
	int distanceSeg;
	int nearWallSeg;
	int accelSeg;
	int headSeg;
	int timeSeg;
	int vSeg;
	int tDSeg;
	boolean real;
	
}

class Batarang {

	double absBearingToUs;
	double rangSpeed;
	double rangPower;
	double distance;
	double distanceTraveled;
	Point2D.Double ourLoc;
	Point2D.Double shotLoc;
	double time;
	double direction;
	double maxEscapeAngle;
	double maxBearingOffset;
	double minBearingOffset;
	int distSeg;
	int nearWallSeg;
	int headSeg;
	int vSeg;
	int tDSeg;
	
	boolean isReal;
	boolean isActive;

}