package gio;
import java.awt.Color;

import robocode.*;


public class RealGioBot extends AdvancedRobot {
	
	public boolean found = false;
	public long timeSinceScan;
	

	  	  public void run() {
		 	setColors(Color.darkGray,Color.darkGray,Color.darkGray);
		 	setAdjustGunForRobotTurn(true);
		 	while(true) {
				setTurnRadarLeft(360);
				setAhead(100);
				setTurnRight(10);
				execute();
		    }
		 }
	public void onScannedRobot(ScannedRobotEvent e) {
		double power;
		double absoluteBearing = getHeading() + e.getBearing();
		double bearingFromGun = normalRelativeAngle(absoluteBearing - getGunHeading());
		double rnd = Math.random()*10;
		if (Math.random() > 0.5)
			rnd = -1 * rnd;
		turnGunRight(bearingFromGun);
		if (e.getDistance() < 30)
			power = 3;
		else
			power = 2;
		fire(power);
		if (bearingFromGun == 0)
			scan();
		found = false;
	}
	
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180)
			return angle;
		double fixedAngle = angle;
		while (fixedAngle <= -180)
			fixedAngle += 360;
		while (fixedAngle > 180)
			fixedAngle -= 360;
		return fixedAngle;
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		setTurnLeft(90 - e.getBearing());
		setAhead(50);
		execute();
	}
	
	public void onHitRobot(HitRobotEvent e) {
		setBack(50);
	}

	public void onHitWall(HitWallEvent event){
		setTurnRight(180);
		setAhead(50);
		execute();
		}
	   
}

				