/*
 * Created on 2004-10-14
 */
package tide.pear;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import tide.EventListener;
import tide.RobotConsole;
import tide.ScannedRobotEvent;
import tide.util.BotInfo;
import tide.util.BotInfoManager;
import tide.util.Bullet;
import tide.util.MathUtils;
import tide.util.Utils;

/**
 * Mutiplex Strategy Gun Controller.
 * It contain different fire strategy to compute the fire heaidng,
 * and it select the best heading to fire a bullet base on the 
 * strategy's scorce.
 * @author xiemin
 */
public class MultGunController extends EventListener
{
	/*
	 * extends Bullet, add field to recorder the strategy that 
	 * compute the bullet's heading
	 */
	private class VirtualBullet extends Bullet
	{
		private Object strategy;
		private boolean flyOff;
		
		public VirtualBullet() {
			super();
		}
		/**
		 * @param fireLocation
		 * @param fireTime
		 * @param heading
		 * @param power
		 */
		public VirtualBullet(Point2D fireLocation, long fireTime,
				double heading, double power) {
			super(fireLocation, fireTime, heading, power);
		}
		
		/**
		 * @return Returns the flyOff.
		 */
		public boolean isFlyOff() {
			return flyOff;
		}
		
		
		/**
		 * @param flyOff The flyOff to set.
		 */
		public void setFlyOff(boolean flyOff) {
			this.flyOff = flyOff;
		}
		
		public void setStrategy(Object strategy)
		{
			this.strategy = strategy;
		}
		
		public Object getStrategy()
		{
			return strategy;
		}
	}
	
	public static final double NORMAL_POWER = 1.9d;
	
	private List strategies = new ArrayList();
	private Hashtable scores = new Hashtable();
	private List bullets = new ArrayList();
	
	private BotInfoManager infoManager;
	private FireStrategy currentGun;
	private String enemyName;
	private Point2D enemyPos;
	private Point2D myPos;
	private BotInfo myInfo;
	private BotInfo enemyInfo;
	private double firePower = NORMAL_POWER;
	private double gunTurn;
	
	/**
	 * @param console
	 */
	public MultGunController(RobotConsole console)
	{
		super(console);
		infoManager = Pear.getBotInfoRecorder().getBotInfoManager();
	}
	
	/**
	 * register a strategy
	 * @param strategy
	 */
	public void addStrategy(FireStrategy strategy)
	{
		strategies.add(strategy);
		scores.put(strategy, new Double(0));

		currentGun = getBestStrategy();
	}
	
	/* (non-Javadoc)
	 * @see tide.EventListener#onRoundFinish()
	 */
	public void onRoundFinish() {
		bullets.clear();
		for(int i=0; i<strategies.size(); i++){
			logStrategyScore((FireStrategy)strategies.get(i));
		}
	}
	/* (non-Javadoc)
	 * @see tide.EventListener#onWork()
	 */
	public void onWork()
	{
		if(console.getTime() < 20){
			return;
		}
		enemyPos = infoManager.getInfoMustHaveOne(enemyName, console.getTime()).getLocation();
		myPos = new Point2D.Double(console.getX(), console.getY());
		
		boolean isFired = false;
		if(console.getFirePrepareTime() <= 0 
				&& Math.toDegrees(Math.abs(gunTurn)) < 20.0001
				&& console.getEnergy() > firePower-0.1){
			isFired = true;
			console.fire(firePower);
		}
		
		enemyInfo = infoManager.getInfo(enemyName, 
				console.getTime());
		myInfo = infoManager.getInfo(console.getName()+enemyName, 
				console.getTime());
		
		update();
		
		if(enemyInfo == null || myInfo == null){
			return;
		}

		firePower = NORMAL_POWER;
		if(enemyInfo.getDistance() <= 200){
			firePower = 3d;
		}
		firePower = Math.min(enemyInfo.getEnergy()/4d+0.0001, firePower);
		//firePower = 1.9;
		
		if(isFired){
			
			fireVitrulBullets();
			
			FireStrategy gun = getBestStrategy();
			if(currentGun != gun){
				currentGun = gun;
				Pear.log("--------- Change Gun ---------");
				logStrategyScore(gun);
			}
			console.turnGun(0);
		}else{
			double heading = MathUtils.heading(myPos, enemyPos);
			if (console.getFirePrepareTime() < 4 && console.getEnergy() > firePower-0.1) {
				heading = currentGun.getFireHeading(firePower);
			}
			gunTurn = MathUtils.anglePI(heading - console.getGunHeading());
			console.turnGun(gunTurn);
		}
		
	}
	
	/**
	 * @param gun
	 */
	private void logStrategyScore(FireStrategy gun) {
		Pear.log("Gun : " + gun.getClass().getName()
				+ " Score : " + getStrategyScore(gun));
	}

	private void fireVitrulBullets(){
		for(int i=0; i<strategies.size(); i++){
			FireStrategy gun = (FireStrategy)strategies.get(i);
			VirtualBullet bullet = new VirtualBullet(
					new Point2D.Double(myPos.getX(), myPos.getY()),
					myInfo.getTime(),
					gun.getFireHeading(firePower),
					firePower);
			bullet.setStrategy(gun);
			bullets.add(bullet);
			gun.onFire();
		}
	}
	
	//Return the best strategy
	private FireStrategy getBestStrategy()
	{
		int bestIndex = 0;
		for(int i=0; i<strategies.size(); i++)
		{
			double score = getStrategyScore(strategies.get(i));
			double bestScore = getStrategyScore(strategies.get(bestIndex));
			if( score > bestScore)
				bestIndex = i;
		}
		return (FireStrategy)strategies.get(bestIndex);
	}
	
	private double getStrategyScore(Object strategy){
		return ((Double)scores.get(strategy)).doubleValue();
	}
	
	//updage the bullets information
	private void update()
	{
		for(int i=bullets.size()-1; i>=0; i--)
		{
			VirtualBullet bullet = (VirtualBullet)bullets.get(i);
			if (!bullet.isFlyOff()) {
				Point2D bulletLocation = bullet.getLocation(console.getTime());

				if (bulletLocation.distance(getEnemyLocation()) < 18) {
					//hited enemy
					modifyScore(bullet.getStrategy(), Utils.bulletDamage(bullet.getPower()));
					bullet.setFlyOff(true);
				}
			}
		}
	}
	
	//modigy strategy score
	private void modifyScore(Object strategy, double d)
	{
		//the strategy score +1
		Double score = (Double)scores.get(strategy);
		scores.put(strategy, new Double(score.doubleValue() + d));
	}
	
	//Return the enemy location
	private Point2D getEnemyLocation()
	{
		return enemyPos;
	}
	
	public void onScannedRobot(ScannedRobotEvent event) {
		if(enemyName == null){
			enemyName = event.getName();
		}
	}
}










