package theo.avenge;
import theo.avenge.utils.WaveUtils;
import theo.avenge.enemy.Enemy;
import theo.avenge.gun.GHandler;
import theo.avenge.surf.SurfHandler;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import java.awt.Graphics2D;
import robocode.util.Utils;

/**
 * Pequod - a robot by theo
 */
public class Pequod extends TeamRobot
{
	
	public static boolean isMC = false, isTC = false;
	
	public static Rectangle2D.Double playField;

	Enemy enemy;
	GHandler gHandler;
	SurfHandler sHandler;
	
	public static double maxDistance;
	
	public Point2D.Double ourPos;
	
	public double energy, heading, velocity;
	public double lastVelocity, lastHeading;
	
	public double latDirection;
	public double lastLatDirection;
	
	static{
		
	}


	public void run() {
	
		maxDistance = Math.sqrt(WaveUtils.square(getBattleFieldWidth())
						+ WaveUtils.square(getBattleFieldHeight()));
	
		if(enemy == null){
			enemy = new Enemy();
		}
		if(gHandler == null){
			gHandler = new GHandler(this, enemy);
		}
		if(sHandler == null){
			sHandler = new SurfHandler(this, enemy);
		}
	
		setColors(Color.green,Color.blue,Color.red);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		
		playField = new Rectangle2D.Double(20,20,super.getBattleFieldWidth()-40,super.getBattleFieldHeight()-40);

		Enemy.timeSinceDirChange = 0;

		// Robot main loop
		while(true) {
			
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
			
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		
		updateSelf();

		double absbearing_rad = (getHeadingRadians()+e.getBearingRadians())%(2*Math.PI);
		double h = Utils.normalRelativeAngle(e.getHeadingRadians() - Enemy.heading);
		h = h/(getTime() - Enemy.cTime);
		Enemy.changeHead = h;

		Enemy.cTime = super.getTime();
		Enemy.distance = e.getDistance();
		Enemy.bearing = e.getBearingRadians();
		Enemy.heading = e.getHeadingRadians();
		Enemy.energy = e.getEnergy();
		Enemy.width = 36.0/Enemy.distance;

		Enemy.absBearing = Utils.normalRelativeAngle(this.heading + Enemy.bearing);
		Enemy.absAngle = Utils.normalAbsoluteAngle(this.heading + Enemy.bearing);
		double enemyX = ourPos.x + Enemy.distance*Math.sin(Enemy.absAngle);
		double enemyY = ourPos.y + Enemy.distance*Math.cos(enemy.absAngle);
		Enemy.pos = new Point2D.Double(enemyX,enemyY);
		Enemy.velocity = e.getVelocity();
		Enemy.latVelocity = Enemy.velocity * Math.sin (
				Utils.normalAbsoluteAngle(Enemy.heading - Enemy.absBearing));
		
		if(Enemy.latVelocity!=0){
			Enemy.latDirection = (Enemy.latVelocity<0?-1:1);
		}
		else{
			Enemy.latDirection = Enemy.lastLatDirection;
		}

		double radarOffset = Utils.normalRelativeAngle(getRadarHeadingRadians() - Enemy.absAngle);
		setTurnRadarLeftRadians(2.0*radarOffset);

		if(!Pequod.isTC){
			gHandler.update(e);
		}
		if(!Pequod.isMC){
			sHandler.update(e);
		}
		
		Enemy.timeSinceDirChange ++;
		if(Enemy.latDirection!=Enemy.lastLatDirection){
			Enemy.timeSinceDirChange = 0;
		}

		Enemy.lastEnergy = Enemy.energy;
		Enemy.lastVelocity = Enemy.velocity;
		Enemy.lastLatDirection = Enemy.latDirection;
		
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		sHandler.handleHit(new Point2D.Double(e.getBullet().getX(),e.getBullet().getY()),e.getPower());
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e){
		sHandler.handleHit(new Point2D.Double(e.getHitBullet().getX(),e.getHitBullet().getY()),e.getHitBullet().getPower());
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
		
	}
	
	public void onWin(WinEvent e){
		sHandler.waveList.clear();
		sHandler.spotList.clear();
		sHandler.statsBuffer.clear();
		SurfHandler.emptyDir = this.latDirection;
	}

	public void onDeath(DeathEvent e){
		sHandler.waveList.clear();
		sHandler.spotList.clear();
		sHandler.statsBuffer.clear();
		SurfHandler.emptyDir = this.latDirection;
	}
	
	private void updateSelf(){
		this.energy = getEnergy();
		this.ourPos = WaveUtils.setCoordinates(getX(), getY());
		this.heading = getHeadingRadians();
		this.lastVelocity = this.velocity;
		this.velocity = super.getVelocity();
		this.lastLatDirection = this.latDirection;
		this.latDirection = (this.sign(Enemy.bearing)*
								this.signL(this.velocity,(int)this.lastLatDirection));
	}
	
	private int sign(double var){
		return (var<0?-1:1);
	}
	
	private int signL(double var, int last){
		if (var==0.0){
			return last;
		}
		return sign(var);
	}


	public void onPaint(Graphics2D g){
		if(!Pequod.isTC){
			gHandler.paint(g);
		}
		if(!Pequod.isMC){
			sHandler.paint(g);
		}
	}

}
