/*
 * SpinSpiral.java
 * TAKEchi Masashi
 * $Id: SpinSpiral.java,v 1.16 2002/06/25 14:58:08 take Exp $
 */
package takeBot;
import robocode.*;
import java.awt.Color;

/**
 * @author TAKEchi Masashi
 * @version $Revision: 1.16 $
 */
public class SpinSpiral extends AdvancedRobot
{
    /**
     * Distance intervals at which to increase wall avoidance priority.
     */
    //private static final double WALL_AVOID_INTERVAL = 10;
    
    /**
     * The number of wall avoidance intervals.
     */
    //private static final double WALL_AVOID_FACTORS = 20;
    
    /**
     * Distance at which to begin avoiding walls.
     */
    //    private static final double WALL_AVOID_DISTANCE =
    //    (WALL_AVOID_INTERVAL * WALL_AVOID_FACTORS);
    private static final double WALL_AVOID_DISTANCE = 80.0;

    private double fieldHeight;
    private double fieldWidth;
    private Enemy target;
    private final double PI = Math.PI;
    private double firePower;
    private final double atackAngle = Math.PI / 3.0;
    private final double atackAngleR = Math.PI / 2.0;
    private final double atackAngleBack = Math.PI / 2.0 + Math.PI / 8.0;
    private boolean isRight = false;
    private boolean isAhead = true;
    private double lastFireTime;
    private double nextFireTime;
    private double turnTime;
    private double tAngle;
    private boolean radarWise = true;
    private boolean nearWall = false;
    private final int turnTimes = 30;
    private String lastHittedRobot = null;

    private final int AWAY = 0;
    private final int GO = 1;
    private int atackMode = AWAY;

    public void run() {
        fieldHeight = getBattleFieldHeight();
        fieldWidth = getBattleFieldWidth();
        this.target = new Enemy();
        this.target.setDistance(100000); // $B=i4|CM$OL58B1s(B
        turnTime = getTime();
        setColors(Color.red, Color.yellow, Color.red);
        
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        turnRadarRightRadians(2.0 * PI);
        while(true) {
            doMovement(); //Move the bot
            doFirePower(); //select the fire power to use
            doScanner(); //Oscillate the scanner over the bot
            doGun3();
            execute(); //execute all commands
        }
    }
    
    void doFirePower() {
        this.firePower = 400 / this.target.getDistance();
        if(this.firePower > 3.0) {
            this.firePower = 3.0;
        }
    }
    
    private void checkWall() {
        // Assume we're not close to a wall
        double myDirection;
        //double myDirectionRad;
        nearWall = false;
        double x = getX();
        double y = getY();

        if(this.isAhead) {
            //myDirection = getHeading() * PI / 180.0;
            myDirection = getHeadingRadians();// * PI / 180.0;
        }
        else {
            //myDirection = getHeading() * PI / 180.0 + PI;
            myDirection = getHeadingRadians() + PI;// * PI / 180.0 + PI;
        }
        myDirection = normalRelativeAngle(myDirection); // -PI - +PI
        //myDirectionRad = normalRelativeAngle(myDirectionRad); // -PI - +PI
        /*
        out.println("(" + x + ", " + y + ")");
        out.println("myD = " + myDirection + "(" + myDirection *180.0 /PI + ")");
        out.println("myDR= " + myDirectionRad + "(" + myDirectionRad *180.0 /PI + ")");
        */

        if((-PI / 2.0) < myDirection 
           && myDirection <= (PI / 2.0)) {
            //out.println("up");
            if((fieldHeight - y) < WALL_AVOID_DISTANCE) {
                nearWall = true;
                //out.println("Wup");
            }
        }
        if((-PI / 2.0) >= myDirection 
           || myDirection > (PI / 2.0)) {
            //out.println("down");
            if(y < WALL_AVOID_DISTANCE) {
                nearWall = true;
                //out.println("Wdown");
            }
        }
        if(myDirection > 0.0) {
            //out.println("right");
            if((fieldWidth - x) < WALL_AVOID_DISTANCE) {
                nearWall = true;
                //out.println("Wright");
            }
        }
        if(myDirection <= 0.0) {
            //out.println("left");
            if(x < WALL_AVOID_DISTANCE) {
                nearWall = true;
                //out.println("Wleft");
            }
        }

        if(nearWall) {
            //out.println("Reverse!");
            if(isRight) {
                isRight = false;
            }
            else {
                isRight = true;
            }
        }
        /*
        if ((y < WALL_AVOID_DISTANCE) ||
            ((fieldHeight - y) < WALL_AVOID_DISTANCE)) {
            nearWall = true;
        }
        if ((x < WALL_AVOID_DISTANCE) ||
            ((fieldWidth - x) < WALL_AVOID_DISTANCE)) {
            nearWall = true;
        }
        if(nearWall) {
            if(isRight) {
                isRight = false;
            }
            else {
                isRight = true;
            }
        }
        */
    }

    void doMovement() {
        if (getTime() - turnTime > turnTimes) {
            //out.println("Turn!");
            turnTime = getTime();
            if(isRight) {
                isRight = false;
            }
            else {
                isRight = true;
            }
        }
        checkWall();
        if(getOthers() > 1) {
            if(nearWall) {
                setTurnAndAheadValue(this.atackAngle);
            }
            else {
                if(atackMode == GO) {
                    if(this.target.getDistance() > 200.0) {
                        setTurnAndAheadValue(this.atackAngle);
                    }
                    else {
                        setTurnAndAheadValue(this.atackAngleR);
                    }
                }
                else {
                    setTurnAndAheadValue(this.atackAngleBack);
                }
            }
        }
        else {
            if(this.target.getDistance() > 200.0) {
                setTurnAndAheadValue(this.atackAngle);
            }
            else {
                setTurnAndAheadValue(this.atackAngleR);
            }
        }
    }

    private void setTurnAndAheadValue(double angle) {
        if(isRight) {
            this.tAngle = normalRelativeAngle(this.target.getBearing() - angle);
            if(tAngle > PI / 2.0 || tAngle < -PI / 2.0) {
                this.isAhead = false;
                setTurnLeftRadians(normalRelativeAngle(PI - tAngle));
                //out.println("-L " + normalRelativeAngle(PI - tAngle));
            }
            else {
                this.isAhead = true;
                setTurnRightRadians(tAngle);
                //out.println("-R " + tAngle);
            }

        }
        else {
            this.tAngle = normalRelativeAngle(-this.target.getBearing()
                                                - angle);
            if(tAngle > PI / 2.0 || tAngle < -PI / 2.0) {
                this.isAhead = false;
                setTurnRightRadians(normalRelativeAngle(PI - tAngle));
                //out.println("-R " + normalRelativeAngle(PI - tAngle));
            }
            else {
                this.isAhead = true;
                setTurnLeftRadians(tAngle);
                //out.println("-L " + tAngle);
            }
        }
        if(this.isAhead) {
            //out.println("++");
            setAhead(100);
        }
        else {
            //out.println("--");
            setBack(100);
        }
    }
    
    void doScanner() {
        double radarOffset;
        setTurnRadarLeftRadians(2.0 * PI);
        if (getTime() - this.target.getCtime() > 4) {
            setTurnRadarLeftRadians(2.0 * PI);
            //out.println("T+");
        }
        else {
            /*
            double myDirection;
            if(this.isAhead) {
                myDirection = getHeadingRadians(); // * PI / 180.0;
            }
            else {
                myDirection = getHeadingRadians() + PI; // * PI / 180.0 + PI;
            }
            myDirection = normalRelativeAngle(myDirection); // -PI - +PI

            //if(radarWise) { // set to front
            radarOffset = getRadarHeadingRadians() - myDirection;
            */
            /**/
            radarOffset = getRadarHeadingRadians() 
                - absbearing(getX(), getY()
                             , this.target.getX(), this.target.getY());
            
            if (radarOffset < 0.0) {
                if(getOthers() > 1) {
                    radarOffset += PI / 2.0;
                }
                else {
                    radarOffset -= PI / 8.0;
                }
            }
            else {
                if(getOthers() > 1) {
                    radarOffset -= PI / 2.0; 
                }
                else {
                    radarOffset += PI / 8.0; 
                }
            }
            /**/
            setTurnRadarLeftRadians(normalRelativeAngle(radarOffset));
        }
    }

    void doGun3() {
        //double preTime = 0.0;
        double time =0.0;
        double hitDis = 0.0;
        double preHitDis = 0.0;
        double bulletV = 20.0 - (3.0 * firePower);
        double posX = getX();
        double posY = getY();

        for(int iterationCount = 0; iterationCount < 15; iterationCount++) {
            time = getTime() 
                + (this.target.getDistance() / bulletV);

            hitDis = calcDistance(posX, posY
                                , target.guessX(time), target.guessY(time));
            if((preHitDis - hitDis) == 0.0) {
                break;
            }
            preHitDis = hitDis;
        }
        time = getTime() + (hitDis / bulletV);

        double tGuessX = this.target.guessX(time);
        double tGuessY = this.target.guessY(time);
        double gunOffset = getGunHeadingRadians() 
            - absbearing(posX, posY, tGuessX ,tGuessY);
        setTurnGunLeftRadians(normalRelativeAngle(gunOffset));

        if(tGuessX > 0.0 && tGuessX < getBattleFieldWidth()
           & tGuessY > 0.0 && tGuessY < getBattleFieldHeight()) {
            fire(firePower);
        }
    }
    private double calcDistance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }
    
    private double guessMyX(double when) {
        double myDirection;
        if(this.isAhead) {
            myDirection = getHeadingRadians() + tAngle;// * PI / 180.0 + tAngle;
        }
        else {
            myDirection = getHeadingRadians() + PI - tAngle;// * PI / 180.0 + PI - tAngle;
        }

        return getX() + Math.sin(normalRelativeAngle(myDirection))
            * getVelocity() * when;
    }

    private double guessMyY(double when) {
        double myDirection;
        if(this.isAhead) {
            myDirection = getHeadingRadians() + tAngle;// * PI / 180.0;
        }
        else {
            myDirection = getHeadingRadians() + PI - tAngle;// * PI / 180.0 + PI;
        }
        return getY() + Math.cos(
            normalRelativeAngle(myDirection)
            ) * getVelocity() * when;
    }

    
    /**
     * normalRelativeAngle:  returns angle such that -PI < angle <= PI
     */	
    double normalRelativeAngle(double angle) {
        if (angle > -PI && angle <= PI) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -PI) {
            fixedAngle += 2.0 * PI;
        }
        while (fixedAngle > PI) {
            fixedAngle -= 2.0 * PI;
        }
        return fixedAngle;
    }

    /**
     * normalAbsoluteAngle:  returns angle such that PI <= angle < 2.0 * PI
     */	
    public double normalAbsoluteAngle(double angle) {
        if (angle >= 0.0 && angle < 2.0 * PI) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0) {
            fixedAngle += 2.0 * PI;
        }
        while (fixedAngle >= 2.0 * PI) {
            fixedAngle -= 2.0 * PI;
        }
        return fixedAngle;
    }
    
    //returns the distance between two x,y coordinates
    public double getrange( double x1,double y1, double x2,double y2 )
    {
        double xo = x2-x1;
        double yo = y2-y1;
        double h = Math.sqrt( xo*xo + yo*yo );
        return h;	
    }
    
    //gets the absolute bearing between to x,y coordinates
    public double absbearing( double x1,double y1, double x2,double y2 ) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = getrange(x1, y1, x2, y2);
        if(xo > 0.0 && yo > 0.0) {
                return Math.asin(xo / h);
        }
        if(xo > 0.0 && yo < 0.0) {
            return PI - Math.asin(xo / h);
        }
        if(xo < 0.0 && yo < 0.0) {
            return PI + Math.asin(-xo / h);
        }
        if(xo < 0.0 && yo > 0.0) {
            return 2.0 * PI - Math.asin(-xo / h);
        }
        return 0.0;
    }
    
    
    /**
     * onScannedRobot: What to do when you see another robot
     */
    public void onScannedRobot(ScannedRobotEvent e) {
        if ((e.getDistance() < this.target.getDistance())
            || (this.target.getName() == e.getName())) {

            double absbearing_rad = (getHeadingRadians()
                                     + e.getBearingRadians()) % (2*PI);

            this.target.setName(e.getName());
            this.target.setX(getX() 
                             + Math.sin(absbearing_rad) * e.getDistance());
            this.target.setY(getY()
                             + Math.cos(absbearing_rad) * e.getDistance());
            this.target.setBearing(e.getBearingRadians());
            this.target.setHead(e.getHeadingRadians());
            this.target.setCtime(getTime());
            this.target.setSpeed(e.getVelocity());
            this.target.setDistance(e.getDistance());
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        this.target.setName(e.getName());
        this.target.setX(getX());
        this.target.setY(getY());
        this.target.setBearing(e.getBearingRadians());
        this.target.setHead(0.0);
        this.target.setCtime(getTime());
        this.target.setSpeed(0.0);
        this.target.setDistance(0.0);
        atackMode = AWAY;
        out.println("atackMode AWAY");
    }    
    public void onHitWall(HitWallEvent e) {
        //out.println("hit Wall");
        if(isRight) {
            isRight = false;
        }
        else {
            isRight = true;
        }
    }
    public void onHitByBullet(HitByBulletEvent e) {
        if(lastHittedRobot  == e.getName()) {
            atackMode = GO;
            out.println("atackMode GO");
        }
        lastHittedRobot = e.getName();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.target.getName())
            this.target.setDistance(10000);
    }
    
}
