package nat.nano;

import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class OcnirpSNG extends AdvancedRobot {
	static int dir = 1;
	static double en;
	static int death;

	public void run() {
		setAdjustGunForRobotTurn(true);
		// setAdjustRadarForGunTurn(true);
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double angle, dist;

		// Radar
		setTurnRadarLeftRadians(getRadarTurnRemaining());

		// Movement (Perpendicular and Random)
		setTurnRightRadians(Math.cos(angle = e.getBearingRadians()));

		if ((en > (en = e.getEnergy())) || death >= 2)
			// for 47, robot will take 12 turns to reach.
			setAhead(47 * dir);

		// Random and EnergyDropSurfing
		if (Math.random() > 0.92 && death >= 2)
			onHitWall(null);

		// Eric Simonton's Pattern Matching
		int i;
		// String enemyHistory = this.enemyHistory;
		enemyHistory = String.valueOf(
				(char) (e.getVelocity() * Math.sin(e.getHeadingRadians()
						- (angle += getHeadingRadians()))))
				.concat(enemyHistory);
		int matchPos, matchLen = 45;
		while ((matchPos = enemyHistory.indexOf(enemyHistory.substring(0,
				matchLen--), i = (int) ((dist = e.getDistance()) / 12.5D))) < 0)
			;
		do
			angle += (short) enemyHistory.charAt(--matchPos) / dist;
		while (--i > 0);
		setTurnGunRightRadians(Utils.normalRelativeAngle(angle
				- getGunHeadingRadians()));
		setFire(2.5D);
	}

	public void onHitWall(HitWallEvent e) {
		dir = -dir;
	}

	public void onDeath(DeathEvent e) {
		death++;
	}

	static String enemyHistory = "" + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 1 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 2 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) -1 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) -2 + (char) -4
			+ (char) -6 + (char) -8 + (char) -8 + (char) -8 + (char) -8
			+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
			+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
			+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
			+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
			+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
			+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
			+ (char) -8 + (char) -8 + (char) -8 + (char) -8 + (char) -8
			+ (char) -8 + (char) -7 + (char) -6 + (char) -5 + (char) -4
			+ (char) -3 + (char) -2 + (char) -1 + (char) 0 + (char) 2
			+ (char) 4 + (char) 6 + (char) 8 + (char) 8 + (char) 8 + (char) 8
			+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
			+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
			+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
			+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
			+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
			+ (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8 + (char) 8
			+ (char) 8 + (char) 7 + (char) 6 + (char) 5 + (char) 4 + (char) 3
			+ (char) 2 + (char) 1 + (char) 0;
}
