/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.ws.path;

import dsekercioglu.mega.rMove.ws.path.State;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import robocode.util.Utils;

public class Path {
    private final List<State> STATES;
    private final List<double[]> INSTRUCTIONS;
    private State currentState;
    private int instructionIndex = 0;

    public Path(State rootState) {
        this.currentState = rootState;
        this.STATES = new ArrayList<State>();
        this.STATES.add(rootState);
        this.INSTRUCTIONS = new ArrayList<double[]>();
    }

    public void setMaxVelocity(double maxVelocity) {
        this.currentState.setMaxVelocity(maxVelocity);
    }

    public State getLastState() {
        return this.STATES.get(this.numberOfStates() - 1);
    }

    public void moveTowards(double angle) {
        State nextState = this.currentState.moveTowards(angle);
        this.add(nextState);
    }

    public void moveTo(Point2D.Double targetLocation) {
        State nextState = this.currentState.moveTo(targetLocation);
        this.add(nextState);
    }

    public void brake() {
        State nextState = this.currentState.brake();
        this.add(nextState);
    }

    private void add(State nextState) {
        double[] instructions = new double[]{nextState.getVelocity(), Utils.normalRelativeAngle((double)(nextState.getHeading() - this.currentState.getHeading()))};
        this.INSTRUCTIONS.add(instructions);
        this.STATES.add(nextState);
        this.currentState = nextState;
    }

    public int stopTime() {
        return this.currentState.stopTime();
    }

    public void removeLast() {
        int removeIndex = this.STATES.size() - 1;
        this.STATES.remove(removeIndex);
        this.INSTRUCTIONS.remove(removeIndex - 1);
        this.currentState = this.STATES.get(this.STATES.size() - 1);
    }

    public State getState(int index) {
        return this.STATES.get(index);
    }

    public boolean hasNext() {
        return this.instructionIndex < this.numberOfInstructions();
    }

    public double[] next() {
        return this.INSTRUCTIONS.get(this.instructionIndex++);
    }

    public int numberOfStates() {
        return this.STATES.size();
    }

    public int numberOfInstructions() {
        return this.INSTRUCTIONS.size();
    }

    public void reset() {
        this.instructionIndex = 0;
    }

    public void mergePath(Path path) {
        this.STATES.addAll(path.STATES);
    }

    public String toString() {
        return "Path{STATES=" + this.STATES + '}';
    }
}

