/*
 * Decompiled with CFR 0.152.
 */
package drm;

import drm.common3.Brain;
import drm.common3.Driver;
import drm.common3.Gun;
import drm.common3.Mech;
import drm.common3.Motor;
import drm.common3.Radar;
import drm.parts.TricoloreDriver;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CobraBora
extends AdvancedRobot {
    AdvancedRobot robot;
    Driver driver;
    Mech[] mechas;
    Brain brain;

    public void run() {
        this.initialize();
        while (true) {
            this.move();
            this.execute();
        }
    }

    void initialize() {
        this.out.println("Brain  name : " + this.brain.getClass().toString());
        this.out.println("Driver name : " + this.driver.getClass().toString());
        this.out.println("Mech 0 name : " + this.mechas[0].getClass().toString());
        this.out.println("Mech 1 name : " + this.mechas[1].getClass().toString());
        this.out.println("Mech 2 name : " + this.mechas[2].getClass().toString());
        this.setColors(Color.green, Color.black, Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.driver.initialize();
        int i = 0;
        while (this.mechas.length > i) {
            this.mechas[i].initialize();
            ++i;
        }
    }

    void move() {
        this.driver.move();
        Driver d = this.driver.nextDriver();
        if (d != null) {
            d.initialize();
            this.out.println("[Changed] Driver name : " + d.getClass().toString());
            this.driver = d;
        }
        int i = 0;
        while (this.mechas.length > i) {
            this.mechas[i].move();
            Mech m = this.mechas[i].nextMech();
            if (m != null) {
                m.initialize();
                this.out.println("[Changed] Mech " + i + " name : " + m.getClass().toString());
                this.mechas[i] = m;
            }
            ++i;
        }
        Gun gun = (Gun)this.mechas[2];
        this.brain.setLastBullet(gun.getLastBullet());
        this.brain.setShooted(gun.isShooted());
    }

    public void onBulletHit(BulletHitEvent e) {
        this.driver.onBulletHit(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.driver.onBulletHitBullet(e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.driver.onBulletMissed(e);
    }

    public void onDeath(DeathEvent e) {
        this.driver.onDeath(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.driver.onHitByBullet(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.driver.onHitRobot(e);
    }

    public void onHitWall(HitWallEvent e) {
        this.driver.onHitWall(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.driver.onRobotDeath(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.driver.onScannedRobot(e);
    }

    public void onWin(WinEvent e) {
        this.driver.onWin(e);
    }

    private final /* synthetic */ void this() {
        this.mechas = new Mech[3];
        this.brain = null;
    }

    public CobraBora() {
        this.this();
        this.robot = this;
        this.mechas[0] = new Radar(this);
        this.mechas[1] = new Motor(this);
        this.mechas[2] = new Gun(this);
        this.brain = new Brain(this);
        this.driver = new TricoloreDriver(this, this.mechas, this.brain);
    }
}

