/*
 * Decompiled with CFR 0.152.
 */
package sqTank.neuralib;

import java.io.Serializable;

public class NeuronLayer
implements Serializable {
    private double learningRate = 0.3;
    private double momentum = 0.3;
    private int in;
    private int out;
    private double[] output;
    private double[] delta;
    private double[] input;
    private double[][] weight;
    private double[][] lastWeightChange;

    public NeuronLayer(int in, int out) {
        this.in = in;
        this.out = out;
        this.input = new double[in];
        this.output = new double[out];
        this.lastWeightChange = new double[in + 1][out];
        this.init();
        this.weight = new double[in + 1][out];
        int i = 0;
        while (i <= in) {
            int o = 0;
            while (o < out) {
                this.weight[i][o] = Math.random() - 0.5;
                ++o;
            }
            ++i;
        }
    }

    public double[] getOutput(double[] inp) {
        int i = 0;
        while (i < this.in) {
            this.input[i] = inp[i];
            ++i;
        }
        System.arraycopy(inp, 0, this.input, 0, this.in);
        this.input = (double[])inp.clone();
        int o = 0;
        while (o < this.out) {
            this.output[o] = 0.0;
            int i2 = 0;
            while (i2 <= this.in) {
                int n = o;
                this.output[n] = this.output[n] + this.weight[i2][o] * (i2 == this.in ? 1.0 : this.input[i2]);
                ++i2;
            }
            int n = o;
            this.output[n] = this.output[n] + this.weight[this.in][o];
            this.output[o] = 1.0 / (1.0 + Math.exp(-this.output[o]));
            ++o;
        }
        return (double[])this.output.clone();
    }

    public double[] propagate(double[] error) {
        double[] deltaE = new double[this.out];
        double[] delta = new double[this.in];
        int o = 0;
        while (o < this.out) {
            deltaE[o] = error[o] * (this.output[o] * (1.0 - this.output[o]));
            int i = 0;
            while (i <= this.in) {
                double[] dArray = this.weight[i];
                int n = o;
                dArray[n] = dArray[n] + this.lastWeightChange[i][o] * 0.3;
                double[] dArray2 = this.weight[i];
                int n2 = o;
                double d = 0.3 * deltaE[o] * (i == this.in ? 1.0 : this.input[i]);
                this.lastWeightChange[i][o] = d;
                dArray2[n2] = dArray2[n2] + d;
                ++i;
            }
            this.weight[this.in][o] = this.weight[this.in][o] + this.learningRate * deltaE[o];
            ++o;
        }
        int i = 0;
        while (i < this.in) {
            delta[i] = 0.0;
            int o2 = 0;
            while (o2 < this.out) {
                int n = i;
                delta[n] = delta[n] + deltaE[o2] * this.weight[i][o2];
                ++o2;
            }
            ++i;
        }
        return delta;
    }

    public int getInputSize() {
        return this.in;
    }

    public int getOutputSize() {
        return this.out;
    }

    public void randomizeWeight() {
        int i = 0;
        while (i < this.in + 1) {
            int o = 0;
            while (o < this.out) {
                this.weight[i][o] = Math.random() - 0.5;
                ++o;
            }
            ++i;
        }
    }

    public static double sigmoid(double d) {
        return 1.0 / (1.0 + Math.exp(-d));
    }

    public void init() {
        this.input = new double[this.in];
        this.output = new double[this.out];
        this.lastWeightChange = new double[this.in + 1][this.out];
    }

    public void setWeight(double[][] weight) {
        int i = 0;
        while (i < this.in + 1) {
            int j = 0;
            while (j < this.out) {
                this.weight[i][j] = weight[i][j];
                ++j;
            }
            ++i;
        }
    }

    public int getWeightSize() {
        return (this.in + 1) * this.out;
    }
}

