/*
 * Decompiled with CFR 0.152.
 */
package yagami;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class Tidus
extends TeamRobot {
    private static Point2D.Double currentLocation;
    private static Point2D.Double destination;
    private static Rectangle2D.Double field;
    private static HashMap<String, Enemy> enemies;
    private static Enemy target;
    private static double distanceLeft;
    private static Point2D.Double lastPosition;

    public void onPaint(Graphics2D g) {
        g.setColor(Color.RED);
        g.fillRect((int)Tidus.destination.x, (int)Tidus.destination.y, 10, 10);
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        this.setColors(new Color(45, 90, 120), Color.black, Color.black);
        field = new Rectangle2D.Double(37.5, 37.5, this.getBattleFieldWidth() - 75.0, this.getBattleFieldHeight() - 75.0);
        enemies = new HashMap();
        target = new Enemy();
        currentLocation = destination = new Point2D.Double(this.getX(), this.getY());
        lastPosition = destination;
        while (true) {
            currentLocation = new Point2D.Double(this.getX(), this.getY());
            if (Tidus.target.alive) {
                this.doTargeting();
                this.move();
            }
            this.execute();
        }
    }

    private void doTargeting() {
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Tidus.absoluteBearing(currentLocation, Tidus.target.pos) - this.getGunHeadingRadians())));
        this.setFire(3.0 - (20.0 - this.getEnergy()) / 6.0);
    }

    private void move() {
        distanceLeft = currentLocation.distance(destination);
        if (distanceLeft <= 10.0) {
            int i = 0;
            double addLast = 1.0;
            do {
                Point2D.Double test;
                if (!field.contains(test = Tidus.getPoint(currentLocation, (double)i * Math.PI / 50.0, 50.0 + Math.random() * 200.0)) || !(this.getRisk(test, addLast) < this.getRisk(destination, addLast))) continue;
                destination = test;
            } while (i++ < 100);
            lastPosition = currentLocation;
        } else {
            double angle = Tidus.absoluteBearing(currentLocation, destination) - this.getHeadingRadians();
            double direction = 1.0;
            if (Math.cos(angle) < 0.0) {
                angle += Math.PI;
                direction = -1.0;
            }
            this.setAhead(distanceLeft * direction);
            angle = Utils.normalRelativeAngle((double)angle);
            this.setTurnRightRadians(angle);
            this.setMaxVelocity(Math.abs(angle) > 1.0 ? 0.0 : 8.0);
        }
    }

    private double getRisk(Point2D.Double destination, double addLast) {
        double risk = addLast * 0.08 / destination.distanceSq(lastPosition);
        for (Enemy en : enemies.values()) {
            if (!en.alive) continue;
            risk += Math.min(en.energy / this.getEnergy(), 2.0) * (1.0 + Math.abs(Math.cos(Tidus.absoluteBearing(destination, currentLocation) - Tidus.absoluteBearing(currentLocation, en.pos)))) / destination.distanceSq(en.pos);
        }
        return risk;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy en = enemies.get(e.getName());
        if (en == null) {
            en = new Enemy();
            enemies.put(e.getName(), en);
        }
        en.energy = e.getEnergy();
        en.alive = true;
        en.pos = Tidus.getPoint(currentLocation, e.getBearingRadians() + this.getHeadingRadians(), e.getDistance());
        if (!Tidus.target.alive || e.getDistance() < currentLocation.distance(Tidus.target.pos)) {
            target = en;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Tidus.enemies.get((Object)e.getName()).alive = false;
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static Point2D.Double getPoint(Point2D.Double source, double angle, double length) {
        return new Point2D.Double(source.x + Math.sin(angle) * length, source.y + Math.cos(angle) * length);
    }

    class Enemy {
        double energy;
        Point2D.Double pos;
        boolean alive = false;

        Enemy() {
        }
    }
}

