/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import pedersen.core.Combatant;
import pedersen.core.EventHandlerBase;
import pedersen.core.Snapshot;
import pedersen.core.SnapshotImpl;
import pedersen.debug.Debug;
import pedersen.debug.GraphicalDebugger;
import pedersen.debug.Stopwatches;
import pedersen.divination.CombatWaveBase;
import pedersen.divination.WaveInboundBank;
import pedersen.divination.WaveInboundImpl;
import pedersen.divination.WaveOutboundBank;
import pedersen.misc.Arena;
import pedersen.misc.ClearQueueCondition;
import pedersen.misc.Host;
import pedersen.misc.Metrics;
import pedersen.misc.Persistence;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.opponent.TargetFactory;
import pedersen.opponent.TargetStandardImpl;
import pedersen.physics.StaticPositionImpl;
import pedersen.systems.FireControl;
import pedersen.tactics.movement.MovementMethodSet;
import pedersen.tactics.movement.MovementMethodSetBuilder;
import robocode.Bullet;

public abstract class Foundation
extends EventHandlerBase {
    private final Color chassis;
    private final Color turret;
    private final Color radar;
    private boolean recalibrate = false;
    private static boolean operational = false;
    protected static boolean allowProfiles = true;
    private static final boolean killswitch = false;
    private long mostRecentTurnProcessed = -1L;

    protected Foundation(Color newChassis, Color newTurret, Color newRadar) {
        this.chassis = newChassis;
        this.turret = newTurret;
        this.radar = newRadar;
    }

    public void run() {
        this.battleSetup();
        while (true) {
            this.processTurn();
            Host.singleton.applyInstructions(this);
            this.execute();
        }
    }

    private void roundSetup() {
        this.setColors(this.chassis, this.turret, this.radar);
        Debug.singleton.setPrintStream(this.out);
        Persistence.singleton = new Persistence(this.getDataDirectory());
        GraphicalDebugger.singleton.onRoundSetup();
        WaveInboundBank.singleton.roundTeardown();
        WaveOutboundBank.singleton.roundTeardown();
        WaveInboundBank.singleton.purge();
        WaveOutboundBank.singleton.purge();
        Combatant.getCombatant().roundSetup(this);
        this.recalibrateCombatantNextTurn();
        this.addCustomEvent(new ClearQueueCondition());
    }

    private void battleSetup() {
        Debug.singleton.setPrintStream(this.out);
        Persistence.singleton = new Persistence(this.getDataDirectory());
        Host.singleton = new Host(this);
        Arena.init(Host.singleton.getBattleFieldWidth(), Host.singleton.getBattleFieldHeight());
        operational = true;
        if (!operational) {
            Debug.line("This bot will only participate in 35 or 500 round battles.");
        }
    }

    protected void processTurn() {
        long time;
        Stopwatches.foundationTurnProcess.start();
        Host.singleton.initializeTurn(this);
        if (Host.singleton.isFirstTurn()) {
            this.roundSetup();
        }
        if ((time = Host.singleton.getTurn()) > this.mostRecentTurnProcessed) {
            GraphicalDebugger.singleton.onTurnSetup();
            try {
                if (this.recalibrate) {
                    Combatant.getCombatant().recalibrate(this);
                    this.recalibrate = false;
                }
                ++Metrics.turnsProcessed;
                this.turnSetup();
                if (operational) {
                    Combatant.getCombatant().operate(this, time);
                }
                this.turnTeardown();
            }
            catch (Exception ex) {
                ++Metrics.exceptionsThrown;
                ex.printStackTrace();
            }
            this.mostRecentTurnProcessed = time;
        }
        Stopwatches.foundationTurnProcess.stop();
    }

    private void turnSetup() {
    }

    private void turnTeardown() {
        Stopwatches.foundationTurnPostProcess.start();
        long time = Host.singleton.getTurn();
        Stopwatches.foundationTurnPostProcessInboundWave.start();
        WaveInboundBank.singleton.process(time + 1L);
        Stopwatches.foundationTurnPostProcessInboundWave.stop();
        Stopwatches.foundationTurnPostProcessOutboundWave.start();
        WaveOutboundBank.singleton.process(time + 1L);
        Stopwatches.foundationTurnPostProcessOutboundWave.stop();
        Stopwatches.foundationTurnPostProcess.stop();
    }

    protected void processRobotSnapshot(long time, String name, Snapshot snapshot) {
        Target vaultEntry = TargetBank.singleton.findByName(name);
        if (vaultEntry == null) {
            vaultEntry = allowProfiles ? TargetFactory.singleton.produce(name, this) : new TargetStandardImpl(name, this);
            TargetBank.singleton.add(vaultEntry);
        }
        vaultEntry.update(snapshot);
        Combatant.getCombatant().scan(vaultEntry, this);
    }

    private void roundTeardown(boolean complete) {
        if (complete) {
            Combatant.getCombatant().roundTeardown();
            WaveInboundBank.singleton.roundTeardown();
        }
        TargetBank.singleton.roundTearDown();
        WaveOutboundBank.singleton.roundTeardown();
        Metrics.place(Host.singleton.getActiveEnemyCount());
        if (Host.singleton.isLastRound()) {
            this.battleTeardown();
        }
    }

    private void battleTeardown() {
        this.debug();
        TargetBank.singleton.teardown();
        Debug.singleton.teardown();
    }

    private void recalibrateCombatantNextTurn() {
        this.recalibrate = true;
    }

    public abstract MovementMethodSetBuilder getMovementMethods();

    public abstract MovementMethodSet getMovementMethods(int var1);

    public abstract List getDefensiveTargetingMethods(Target var1);

    public abstract List getOffensiveTargetingMethods(Target var1);

    public abstract List getMeleeTargetingMethods(Target var1);

    public abstract FireControl getFireControl();

    protected void onRobotHitByCombatant(long time, String name, Bullet bullet) {
        Metrics.bulletHitTarget(bullet.getPower());
        TargetBank.singleton.onRobotHitByCombatant(name, bullet.getPower());
    }

    protected void onCombatantHitByRobot(long time, String name, Bullet bullet) {
        Metrics.bulletHitCombatant(bullet.getPower());
        TargetBank.singleton.onCombatantHitByRobot(name, bullet.getPower());
        Combatant combatant = Combatant.getCombatant();
        SnapshotImpl bulletSnapshot = new SnapshotImpl(Host.singleton.getRound(), time, new StaticPositionImpl(bullet.getX(), bullet.getY(), combatant.getRelativePosition(Host.singleton.getStaleChassisPosition())), bullet.getHeadingRadians(), bullet.getVelocity(), bullet.getPower());
        WaveInboundImpl wave = WaveInboundBank.singleton.findAssociatedWave(bulletSnapshot);
        if (wave != null) {
            wave.setHeading(bullet.getHeadingRadians());
            combatant.onHitByBullet(wave);
        }
        this.recalibrateCombatantNextTurn();
    }

    protected void onRobotDeath(long time, String name) {
        Target vaultEntry = TargetBank.singleton.findByName(name);
        if (vaultEntry != null) {
            Combatant.getCombatant().retire(vaultEntry, this);
            vaultEntry.deactivate();
        }
    }

    protected void onWin(long time) {
        WaveOutboundBank.singleton.cancelAll();
        this.roundTeardown(false);
    }

    protected void onDeath(long time) {
        WaveInboundBank.singleton.cancelAll();
        WaveOutboundBank.singleton.cancelAll();
        this.roundTeardown(true);
    }

    public void onPaint(Graphics2D console) {
        this.processAllEvents();
        this.processTurn();
        try {
            GraphicalDebugger.singleton.onPaint(console);
        }
        catch (Exception ex) {
            Debug.exception("Foundation.onPaint (or aggregate)", ex);
        }
    }

    public void debug() {
        super.debug();
        Debug.line(Metrics.getStatistics());
        TargetFactory.debug();
        TargetBank.singleton.debug();
        WaveInboundBank.singleton.debug();
        WaveOutboundBank.singleton.debug();
        Debug.debug("Firing angles associated with waves: " + CombatWaveBase.totalFiringAngles);
    }
}

