/*
 * Decompiled with CFR 0.152.
 */
package rjw.pluggablerobot;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import rjw.pluggablerobot.Canvas;
import rjw.pluggablerobot.EventListener;
import robocode.AdvancedRobot;
import robocode.KeyPressedEvent;

public class Hud
implements EventListener._KeyPressed {
    private static final int MESSAGE_BOX_TIME = 3;
    private static final int MESSAGE_BOX_PADDING = 12;
    private static final int MESSAGE_BOX_PADDING_X2 = 24;
    private static final Color MESSAGE_BOX_BACKGROUND = new Color(0, 0, 0, 127);
    private static final Font LAYER_GUIDE_TITLE_FONT = new Font("SansSerif", 1, 18);
    private static final Font LAYER_GUIDE_TEXT_FONT = new Font("SansSerif", 0, 12);
    private static boolean _firstPaint = true;
    private Canvas _canvas;
    private ArrayList<Layer> _layers = new ArrayList();
    private Message _message;

    public Hud(AdvancedRobot bot) {
        this._canvas = new Canvas(bot);
    }

    public void createLayer(int key, String name, boolean enabled) {
        Layer layer = new Layer(key, name, enabled);
        this._layers.add(layer);
    }

    public void registerPainter(int key, Painter painter) {
        for (Layer layer : this._layers) {
            if (layer.getKey() != key) continue;
            layer.addPainter(painter);
            return;
        }
        throw new IllegalArgumentException("No layer bound to that key!");
    }

    @Override
    public void notifyKeyPressed(KeyPressedEvent event) {
        Layer layer = this.getLayer(event.getSourceEvent().getKeyCode());
        if (layer != null) {
            layer.toggle();
            this.showLayerGuide();
        }
    }

    private void showLayerGuide() {
        this._message = new Message(3);
        this._message.addLine("Hud Layers", LAYER_GUIDE_TITLE_FONT, Color.WHITE, Canvas.Align.CENTER);
        for (Layer layer : this._layers) {
            this._message.addLine("[" + (layer.isEnabled() ? "X" : "_") + "] " + KeyEvent.getKeyText(layer.getKey()) + ": " + layer.getName(), LAYER_GUIDE_TEXT_FONT, Color.WHITE, Canvas.Align.LEFT);
        }
    }

    void paint(long tick) {
        if (_firstPaint) {
            this.showLayerGuide();
            _firstPaint = false;
        }
        for (Layer layer : this._layers) {
            layer.paint(this._canvas, tick);
        }
        if (this._message != null) {
            if (this._message.isExpired()) {
                this._message = null;
                return;
            }
            this._message.draw(this._canvas);
        }
    }

    private Layer getLayer(int key) {
        for (Layer layer : this._layers) {
            if (layer.getKey() != key) continue;
            return layer;
        }
        return null;
    }

    private static class Layer {
        private int _key;
        private String _name;
        private boolean _enabled;
        private ArrayList<Painter> _painters = new ArrayList();

        Layer(int key, String name, boolean enabled) {
            this._key = key;
            this._name = name;
            this._enabled = enabled;
        }

        int getKey() {
            return this._key;
        }

        String getName() {
            return this._name;
        }

        void addPainter(Painter painter) {
            this._painters.add(painter);
        }

        boolean isEnabled() {
            return this._enabled;
        }

        void toggle() {
            this._enabled = !this._enabled;
        }

        void paint(Canvas canvas, long tick) {
            if (!this._enabled) {
                return;
            }
            for (Painter painter : this._painters) {
                painter.paint(canvas, tick);
            }
        }
    }

    private class Message {
        private long _expire;
        private ArrayList<MessageLine> _lines = new ArrayList();
        private RoundRectangle2D _box;

        Message(int seconds) {
            this._expire = System.currentTimeMillis() + (long)(seconds * 1000);
        }

        void addLine(String text, Font font, Color color, Canvas.Align align) {
            this._lines.add(new MessageLine(text, font, color, align));
        }

        boolean isExpired() {
            return System.currentTimeMillis() > this._expire;
        }

        void draw(Canvas c) {
            if (this._box == null) {
                double width = 0.0;
                double height = 0.0;
                int lastDescent = -1;
                ArrayList<MessageLine> rev = new ArrayList<MessageLine>(this._lines);
                Collections.reverse(rev);
                for (MessageLine line : rev) {
                    FontMetrics m = c.getFontMetrics(line.getFont());
                    int w = m.stringWidth(line.getText());
                    if ((double)w > width) {
                        width = w;
                    }
                    height += (double)m.getHeight();
                    lastDescent = m.getDescent();
                }
                Point2D.Double center = c.getCenter();
                double x0 = ((Point2D)center).getX() - width / 2.0;
                double x1 = x0 + width;
                double y = ((Point2D)center).getY() - (height -= (double)lastDescent) / 2.0;
                this._box = new RoundRectangle2D.Double(x0 - 12.0, y - 12.0 - (double)lastDescent, width + 24.0, height + 24.0, 24.0, 24.0);
                for (MessageLine line : rev) {
                    y += (double)line.setLocation(c, x0, x1, y);
                }
            }
            c.setColor(MESSAGE_BOX_BACKGROUND);
            c.fill(this._box);
            for (MessageLine line : this._lines) {
                line.draw(c);
            }
        }
    }

    private class MessageLine {
        private String _text;
        private Font _font;
        private Color _color;
        private Canvas.Align _align;
        private double _x;
        private double _y;

        MessageLine(String text, Font font, Color color, Canvas.Align align) {
            this._text = text;
            this._font = font;
            this._color = color;
            this._align = align;
        }

        int setLocation(Canvas c, double x0, double x1, double y) {
            this.initCanvas(c);
            this._x = this._align.calculateX(c, this._text, x0, x1);
            FontMetrics m = c.getFontMetrics();
            this._y = y + (double)m.getDescent();
            return m.getHeight();
        }

        String getText() {
            return this._text;
        }

        Font getFont() {
            return this._font;
        }

        void initCanvas(Canvas c) {
            c.setFont(this._font);
            c.setColor(this._color);
        }

        void draw(Canvas c) {
            this.initCanvas(c);
            c.drawString(this._text, this._x, this._y);
        }
    }

    public static interface Painter {
        public void paint(Canvas var1, long var2);
    }
}

