/*
 * Decompiled with CFR 0.152.
 */
package florent.test;

import florent.test.FUtils;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

class ScanExtrapolator {
    public static int extrapolations;
    private AdvancedRobot me;

    public ScanExtrapolator(AdvancedRobot me) {
        this.me = me;
    }

    public ScannedRobotEvent[] getScans(ScannedRobotEvent start, double startHeading, Point2D.Double startLocation, ScannedRobotEvent last, double lastHeading, Point2D.Double lastLocation) {
        if (last.getTime() - start.getTime() < 2L) {
            return null;
        }
        ScannedRobotEvent[] res = new ScannedRobotEvent[(int)(last.getTime() - start.getTime() - 1L)];
        return res;
    }

    public ScannedRobotEvent getScan(ScannedRobotEvent start, double startHeading, Point2D.Double startLocation, ScannedRobotEvent last, double lastHeading, Point2D.Double lastLocation, double lastFirePower, double lastFireTime) {
        if (last.getTime() - start.getTime() != 2L) {
            return null;
        }
        System.out.println("extrapolating scan " + ++extrapolations);
        double heat = 1.0 + lastFirePower / 5.0 - (lastFireTime - (double)start.getTime() + 1.0) * this.me.getGunCoolingRate();
        double eDrop = last.getEnergy() - start.getEnergy();
        boolean fire = heat < this.me.getGunCoolingRate() && eDrop <= 3.0 && eDrop >= 0.1;
        double energy = fire ? last.getEnergy() : start.getEnergy();
        Point2D.Double startEnemyLocation = FUtils.projectMotion(startLocation, startHeading + start.getBearingRadians(), start.getDistance());
        Point2D.Double lastEnemyLocation = FUtils.projectMotion(lastLocation, lastHeading + last.getBearingRadians(), last.getDistance());
        Point2D.Double enemyLocation = new Point2D.Double((startEnemyLocation.x + lastEnemyLocation.x) / 2.0, (startEnemyLocation.y + lastEnemyLocation.y) / 2.0);
        Point2D.Double myLocation = new Point2D.Double((startLocation.x + lastLocation.x) / 2.0, (startLocation.y + lastLocation.y) / 2.0);
        double distance = myLocation.distance(enemyLocation);
        double myHeading = startHeading + FUtils.absoluteBearing(startLocation, myLocation);
        double bearing = FUtils.absoluteBearing(myLocation, enemyLocation) - myHeading;
        double heading = Utils.normalAbsoluteAngle((double)(start.getHeadingRadians() + FUtils.absoluteBearing(startEnemyLocation, enemyLocation)));
        double velocity = enemyLocation.distance(startEnemyLocation);
        ScannedRobotEvent res = new ScannedRobotEvent(start.getName(), energy, bearing, distance, heading, velocity);
        res.setTime(start.getTime() + 1L);
        return res;
    }
}

