/*
 * Decompiled with CFR 0.152.
 */
package rdm.robots;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import rdm.state.entities.BodyState;
import rdm.state.entities.EnemyState;
import rdm.state.entities.GunState;
import rdm.state.entities.InstantState;
import rdm.state.entities.RadarState;
import rdm.state.entities.SelfState;
import rdm.state.entities.WorldState;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\t*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\t*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\u0011\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u001e\u0010\u0011\u001a\u00020\u000e*\u00020\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\t\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0015"}, d2={"RADAR_LOCK_FACTOR", "", "Lrobocode/AdvancedRobot;", "getRADAR_LOCK_FACTOR", "(Lrobocode/AdvancedRobot;)D", "getBearingFromGun", "event", "Lrobocode/ScannedRobotEvent;", "getEnemyAbsolutePosition", "Lkotlin/Pair;", "getEnemyRelativePosition", "instantStateOf", "Lrdm/state/entities/InstantState;", "lockGunOnTarget", "", "anticipation", "lockRadarOnTarget", "setMoveTo", "targetX", "targetY", "target", "Commons"})
public final class AdvancedRobotExtensionsKt {
    private static final double getRADAR_LOCK_FACTOR(@NotNull AdvancedRobot $receiver) {
        return 2.0;
    }

    public static final void setMoveTo(@NotNull AdvancedRobot $receiver, double targetX, double targetY) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        double vectorX = targetX - $receiver.getX();
        double vectorY = targetY - $receiver.getY();
        double angleToTarget = Math.atan2(vectorX, vectorY);
        double targetAngle = Utils.normalRelativeAngle((double)(angleToTarget - $receiver.getHeadingRadians()));
        double distance = Math.hypot(vectorX, vectorY);
        double turnAngle = Math.atan(Math.tan(targetAngle));
        $receiver.setTurnRightRadians(turnAngle);
        if (targetAngle == turnAngle) {
            $receiver.setAhead(distance);
        } else {
            $receiver.setBack(distance);
        }
    }

    public static final void setMoveTo(@NotNull AdvancedRobot $receiver, @NotNull Pair<Double, Double> target) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(target, "target");
        AdvancedRobotExtensionsKt.setMoveTo($receiver, ((Number)target.getFirst()).doubleValue(), ((Number)target.getSecond()).doubleValue());
    }

    public static final void lockRadarOnTarget(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        double radarTurn = $receiver.getHeadingRadians() + event.getBearingRadians() - $receiver.getRadarHeadingRadians();
        $receiver.setTurnRadarRightRadians(AdvancedRobotExtensionsKt.getRADAR_LOCK_FACTOR($receiver) * Utils.normalRelativeAngle((double)radarTurn));
    }

    public static final void lockGunOnTarget(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event, double anticipation) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        $receiver.setTurnGunRight(AdvancedRobotExtensionsKt.getBearingFromGun($receiver, event) + anticipation);
    }

    public static final double getBearingFromGun(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        double absoluteBearing = $receiver.getHeading() + event.getBearing();
        return Utils.normalRelativeAngleDegrees((double)(absoluteBearing - $receiver.getGunHeading()));
    }

    @NotNull
    public static final InstantState instantStateOf(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        Pair<Double, Double> enemyAbsolutePosition = AdvancedRobotExtensionsKt.getEnemyAbsolutePosition($receiver, event);
        double enemyNormalizedAbsPositionX = ((Number)enemyAbsolutePosition.getFirst()).doubleValue() / $receiver.getBattleFieldWidth() * 2.0 - 1.0;
        double enemyNormalizedAbsPositionY = ((Number)enemyAbsolutePosition.getSecond()).doubleValue() / $receiver.getBattleFieldHeight() * 2.0 - 1.0;
        double enemyNormalizedDistanceFromCenter = Math.sqrt(Math.pow(enemyNormalizedAbsPositionX, 2.0) + Math.pow(enemyNormalizedAbsPositionY, 2.0));
        return new InstantState(new WorldState($receiver.getBattleFieldWidth(), $receiver.getBattleFieldHeight()), new SelfState(new RadarState(), new GunState($receiver.getGunHeading(), $receiver.getGunHeadingRadians()), new BodyState($receiver.getX(), $receiver.getY(), $receiver.getHeading(), $receiver.getHeadingRadians(), $receiver.getEnergy())), new EnemyState(event.getEnergy(), event.getHeading(), event.getHeadingRadians(), event.getBearing(), event.getBearingRadians(), event.getDistance(), event.getVelocity(), ((Number)enemyAbsolutePosition.getFirst()).doubleValue(), ((Number)enemyAbsolutePosition.getSecond()).doubleValue(), enemyNormalizedAbsPositionX, enemyNormalizedAbsPositionY, enemyNormalizedDistanceFromCenter));
    }

    @NotNull
    public static final Pair<Double, Double> getEnemyRelativePosition(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        double absoluteBearing = Math.toRadians($receiver.getHeading() + event.getBearing());
        double relativeX = event.getDistance() * Math.sin(absoluteBearing);
        double relativeY = event.getDistance() * Math.cos(absoluteBearing);
        return new Pair<Double, Double>(relativeX, relativeY);
    }

    @NotNull
    public static final Pair<Double, Double> getEnemyAbsolutePosition(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        Pair<Double, Double> relativePosition = AdvancedRobotExtensionsKt.getEnemyRelativePosition($receiver, event);
        return new Pair<Double, Double>($receiver.getX() + ((Number)relativePosition.getFirst()).doubleValue(), $receiver.getY() + ((Number)relativePosition.getSecond()).doubleValue());
    }
}

