/*
 * Decompiled with CFR 0.152.
 */
package bts.wiki;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import us.bluetorch.robocode.gun.DynamicCluster;
import us.bluetorch.robocode.gun.Gun;
import us.bluetorch.robocode.movement.MinimumRisk;
import us.bluetorch.robocode.movement.Movement;
import us.bluetorch.robocode.targeting.Narrow;
import us.bluetorch.robocode.targeting.Oldest;
import us.bluetorch.robocode.targeting.Radar;

public class RipCurl
extends AdvancedRobot {
    private Radar radar = null;
    private Movement move = null;
    private Gun gun = null;
    private HashMap<String, Point2D> enemies = new HashMap();
    private String lastTarget = null;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.yellow, Color.black, Color.blue);
        this.radar = new Oldest(this);
        this.move = new MinimumRisk(this);
        this.gun = new DynamicCluster(this);
        while (true) {
            this.move.init();
            this.gun.init();
            this.radar.init();
            this.execute();
        }
    }

    public void onStatus(StatusEvent e) {
        if (this.move != null) {
            this.move.onStatus(e);
        }
        if (this.gun != null) {
            this.gun.onStatus(e);
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        double x = this.getX() + event.getDistance() * Math.sin(this.getHeadingRadians() + event.getBearingRadians());
        double y = this.getY() + event.getDistance() * Math.cos(this.getHeadingRadians() + event.getBearingRadians());
        Point2D.Double enemy = new Point2D.Double(x, y);
        this.enemies.put(event.getName(), enemy);
        String target = this.getClosestTarget();
        double power = 3.0;
        if (event.getName().equals(target) && this.getGunHeat() == 0.0 && this.getOthers() == 1) {
            Point2D.Double me = new Point2D.Double(this.getX(), this.getY());
            double distance = me.distance(enemy);
            power = Math.min(Math.min(3.0, 1200.0 / distance), Math.min(this.getEnergy(), event.getEnergy()) / 4.0);
        }
        this.move.setTarget(target);
        this.radar.setTarget(target);
        this.gun.setTarget(target);
        this.radar.onScannedRobot(event);
        this.move.onScannedRobot(event);
        this.gun.onScannedRobot(event, power);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.radar.onRobotDeath(event);
        this.move.onRobotDeath(event);
        this.enemies.remove(event.getName());
        if (this.getOthers() == 1) {
            this.radar = new Narrow(this);
            this.radar.init();
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.move.onHitByBullet(e);
    }

    private String getClosestTarget() {
        Point2D.Double me = new Point2D.Double(this.getX(), this.getY());
        String enemyName = null;
        double distance = Double.POSITIVE_INFINITY;
        for (Map.Entry<String, Point2D> enemy : this.enemies.entrySet()) {
            double eDistance = me.distance(enemy.getValue());
            if (!(eDistance < distance)) continue;
            distance = eDistance;
            enemyName = enemy.getKey();
        }
        return enemyName;
    }
}

