/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Deque;
import pa3k.AimingInfo;
import pa3k.AngleUtils;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.SelfTracking;
import pa3k.Tracking;
import robocode.Bullet;
import robocode.Rules;
import robocode.util.Utils;

public class BulletTracking {
    protected double energy;
    protected Position source;
    protected long time;
    protected Position target;
    protected double targetVelocity;
    protected double targetHeading;
    protected double targetRelativeHeading;
    protected double targetDistanceTraveled5;
    protected double targetDistanceTraveled15;
    protected double targetDistanceTraveled30;
    protected double acceleration;
    protected double evasionTime;
    protected double targetNormalizedWallDistance;
    protected double sourceNormalizedWallDistance;
    protected double targetNormalizedCornerDistance;
    protected double sourceNormalizedCornerDistance;
    protected double midAngleRatio;
    protected Opponent owner;
    protected Position positiveEscapePosition;
    protected Position negativeEscapePosition;
    protected double positiveAngle;
    protected double middleAngle;
    protected double negativeAngle;
    protected Bullet bullet;
    protected Opponent targetOpponent;
    protected double firingAngle;
    protected boolean evaded;
    protected double aimingRatio = -1.0;
    protected double distance = -1.0;
    protected boolean towardWall;
    protected AimingInfo aimingInfo = null;
    private boolean bulletCatcherAdjusted = false;
    private static int timeOffset = 2;
    protected boolean simulated;

    public BulletTracking clone() {
        BulletTracking bulletTracking = new BulletTracking(this.energy, this.time);
        bulletTracking.source = this.source;
        bulletTracking.target = this.target;
        bulletTracking.targetVelocity = this.targetVelocity;
        bulletTracking.targetHeading = this.targetHeading;
        bulletTracking.targetRelativeHeading = this.targetRelativeHeading;
        bulletTracking.owner = this.owner;
        bulletTracking.positiveEscapePosition = this.positiveEscapePosition;
        bulletTracking.negativeEscapePosition = this.negativeEscapePosition;
        bulletTracking.positiveAngle = this.positiveAngle;
        bulletTracking.middleAngle = this.middleAngle;
        bulletTracking.negativeAngle = this.negativeAngle;
        bulletTracking.bullet = this.bullet;
        bulletTracking.targetOpponent = this.targetOpponent;
        bulletTracking.firingAngle = this.firingAngle;
        bulletTracking.evaded = this.evaded;
        bulletTracking.towardWall = this.towardWall;
        bulletTracking.targetDistanceTraveled5 = this.targetDistanceTraveled5;
        bulletTracking.targetDistanceTraveled15 = this.targetDistanceTraveled15;
        bulletTracking.targetDistanceTraveled30 = this.targetDistanceTraveled30;
        bulletTracking.acceleration = this.acceleration;
        bulletTracking.targetNormalizedWallDistance = this.targetNormalizedWallDistance;
        bulletTracking.sourceNormalizedWallDistance = this.sourceNormalizedWallDistance;
        bulletTracking.targetNormalizedCornerDistance = this.targetNormalizedCornerDistance;
        bulletTracking.sourceNormalizedCornerDistance = this.sourceNormalizedCornerDistance;
        bulletTracking.evasionTime = this.evasionTime;
        bulletTracking.midAngleRatio = this.midAngleRatio;
        bulletTracking.aimingInfo = this.aimingInfo;
        bulletTracking.simulated = this.simulated;
        return bulletTracking;
    }

    public static String getARFFHeader() {
        String string = "@RELATION aiming\n@ATTRIBUTE opponent {}\n@ATTRIBUTE source_distance_from_wall NUMERIC\n@ATTRIBUTE target_distance_from_wall NUMERIC\n@ATTRIBUTE distance NUMERIC\n@ATTRIBUTE r_hit_prob NUMERIC\n@ATTRIBUTE mid_angle_ratio NUMERIC\n@ATTRIBUTE energy NUMERIC\n@ATTRIBUTE acceleration NUMERIC\n@ATTRIBUTE relative_heading NUMERIC\n@ATTRIBUTE velocity NUMERIC\n@ATTRIBUTE mid_hitting_wall {true,false}\n@ATTRIBUTE source_distance_from_corner NUMERIC\n@ATTRIBUTE target_distance_from_corner NUMERIC\n@ATTRIBUTE evasion_time NUMERIC\n@ATTRIBUTE last5 NUMERIC\n@ATTRIBUTE last15 NUMERIC\n@ATTRIBUTE last30 NUMERIC\n@ATTRIBUTE angle NUMERIC\n@ATTRIBUTE ratio NUMERIC\n\n@DATA\n";
        return string;
    }

    public String getARFF() {
        double d = AngleUtils.difference(this.firingAngle, this.negativeAngle) / AngleUtils.difference(this.positiveAngle, this.negativeAngle);
        return this.source.getNormalizedWallDistance() + "," + this.target.getNormalizedWallDistance() + "," + this.source.distance(this.target) + "," + this.getRandomHitProbability() + "," + this.midAngleRatio + "," + this.energy + "," + this.acceleration + "," + this.targetRelativeHeading + "," + Math.abs(this.targetVelocity) + "," + this.towardWall + "," + this.sourceNormalizedCornerDistance + "," + this.targetNormalizedCornerDistance + "," + this.evasionTime + "," + this.targetDistanceTraveled5 + "," + this.targetDistanceTraveled15 + "," + this.targetDistanceTraveled30 + "," + d + "," + this.getAimingRatio() + "\n";
    }

    public BulletTracking(double d, Position position, Opponent opponent, Tracking tracking, long l, boolean bl) {
        this(d, position, opponent, tracking, l);
        this.simulated = bl;
    }

    public BulletTracking(double d, Position position, Opponent opponent, Tracking tracking, long l) {
        this.source = new Position(position);
        this.targetOpponent = opponent;
        this.time = l + (long)timeOffset;
        this.towardWall = false;
        try {
            this.target = new Position(opponent.getLastPosition(l));
            this.targetVelocity = opponent.getLastVelocity(l);
            this.targetHeading = opponent.getLastHeading(l);
            this.targetRelativeHeading = Math.abs(AngleUtils.difference(opponent.getLastHeading(), this.target.getDirectionTo(position)));
            this.acceleration = Math.abs(opponent.getLastVelocity(l)) - Math.abs(opponent.getLastVelocity(l - 1L));
            if (l > 40L) {
                this.targetDistanceTraveled5 = this.target.distance(opponent.getLastPosition(l - 5L));
                this.targetDistanceTraveled15 = this.target.distance(opponent.getLastPosition(l - 15L));
                this.targetDistanceTraveled30 = this.target.distance(opponent.getLastPosition(l - 30L));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.energy = d;
        this.bullet = null;
        this.evaded = false;
        Deque<BulletTracking> deque = tracking.getOwnBullets();
        if (deque.size() > 0) {
            assert (this != deque.getLast());
            this.evasionTime = this.getETA(this.target) - deque.getLast().getETA(this.target);
            this.evasionTime /= this.getDistance() / this.getVelocity();
        } else {
            this.evasionTime = 1.0;
        }
        this.computeEscapes(null);
    }

    public BulletTracking(double d, long l) {
        this.energy = d;
        this.time = l;
        this.bullet = null;
        this.evaded = false;
        this.towardWall = false;
    }

    public void setValues(Position position, SelfTracking selfTracking, Tracking tracking, Opponent opponent) throws Exception {
        this.source = new Position(position);
        try {
            this.target = new Position(selfTracking.getLastPosition(1));
            this.targetVelocity = selfTracking.getLastVelocity(1);
            this.targetHeading = selfTracking.getLastHeading(1);
            this.targetRelativeHeading = Math.abs(AngleUtils.difference(selfTracking.getLastHeading(1), this.target.getDirectionTo(position)));
            this.acceleration = Math.abs(selfTracking.getLastVelocity(1)) - Math.abs(selfTracking.getLastVelocity(2));
            this.targetDistanceTraveled5 = this.target.distance(selfTracking.getLastPosition(6));
            this.targetDistanceTraveled15 = this.target.distance(selfTracking.getLastPosition(16));
            this.targetDistanceTraveled30 = this.target.distance(selfTracking.getLastPosition(31));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.owner = opponent;
        this.targetOpponent = null;
        Deque<BulletTracking> deque = tracking.getTrackedBullets();
        if (deque.size() > 0) {
            assert (this != deque.getLast());
            this.evasionTime = this.getETA(this.target) - deque.getLast().getETA(this.target);
            this.evasionTime /= this.getDistance() / this.getVelocity();
        } else {
            this.evasionTime = 1.0;
        }
        this.computeEscapes(selfTracking);
    }

    public void setValues(Bullet bullet, long l) {
        this.time = l;
        this.bullet = bullet;
        this.owner = null;
    }

    private void computeEscapes(SelfTracking selfTracking) {
        assert (this.time != 0L);
        double d = 8.0;
        Position position = this.target;
        this.targetNormalizedWallDistance = this.target.getNormalizedWallDistance();
        this.sourceNormalizedWallDistance = this.source.getNormalizedWallDistance();
        this.targetNormalizedCornerDistance = this.target.getNormalizedCornerDistance();
        this.sourceNormalizedCornerDistance = this.source.getNormalizedCornerDistance();
        try {
            if (this.targetOpponent != null) {
                position = this.target.projectPosition(this.source, this.getVelocity(), this.targetVelocity, this.targetOpponent.getLastVelocity(this.time - (long)timeOffset - 1L), this.targetHeading, this.targetOpponent.getLastHeading(this.time - (long)timeOffset - 1L), timeOffset - 1 + -1);
                this.negativeEscapePosition = this.target.computeEscapePosition(this.targetVelocity, this.targetHeading, this.source, this.getVelocity(), -1, d, timeOffset - 1 + -1);
                this.positiveEscapePosition = this.target.computeEscapePosition(this.targetVelocity, this.targetHeading, this.source, this.getVelocity(), 1, d, timeOffset - 1 + -1);
            } else {
                position = this.target.projectPosition(this.source, this.getVelocity(), selfTracking.getLastVelocity(1), selfTracking.getLastVelocity(2), selfTracking.getLastHeading(1), selfTracking.getLastHeading(2), 0);
                this.negativeEscapePosition = this.target.computeEscapePosition(this.targetVelocity, this.targetHeading, this.source, this.getVelocity(), -1, d, 0);
                this.positiveEscapePosition = this.target.computeEscapePosition(this.targetVelocity, this.targetHeading, this.source, this.getVelocity(), 1, d, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (position.isWallCorrected()) {
            this.towardWall = true;
        }
        this.positiveAngle = this.source.getDirectionTo(this.positiveEscapePosition);
        this.negativeAngle = this.source.getDirectionTo(this.negativeEscapePosition);
        this.middleAngle = this.source.getDirectionTo(position);
        assert (!Double.isNaN(this.positiveAngle));
        assert (!Double.isNaN(this.middleAngle));
        assert (!Double.isNaN(this.negativeAngle));
        if (AngleUtils.difference(this.positiveAngle, this.negativeAngle) > 0.0) {
            if (AngleUtils.difference(this.middleAngle, this.negativeAngle) < 0.0) {
                this.middleAngle = Utils.normalAbsoluteAngle((double)(this.negativeAngle + 0.03));
            } else if (AngleUtils.difference(this.positiveAngle, this.middleAngle) < 0.0) {
                this.middleAngle = Utils.normalAbsoluteAngle((double)(this.positiveAngle - 0.03));
            }
        } else if (AngleUtils.difference(this.middleAngle, this.negativeAngle) > 0.0) {
            this.middleAngle = Utils.normalAbsoluteAngle((double)(this.negativeAngle - 0.03));
        } else if (AngleUtils.difference(this.positiveAngle, this.middleAngle) > 0.0) {
            this.middleAngle = Utils.normalAbsoluteAngle((double)(this.positiveAngle + 0.03));
        }
        this.midAngleRatio = AngleUtils.difference(this.middleAngle, this.negativeAngle) / AngleUtils.difference(this.positiveAngle, this.negativeAngle);
    }

    public double getAngleAdvance() {
        int n = 25;
        if (AngleUtils.difference(this.positiveAngle, this.negativeAngle) > 0.0) {
            return Math.atan2(n, this.source.distance(this.target));
        }
        return Math.atan2(n, this.source.distance(this.target)) * -1.0;
    }

    public double getRandomHitProbability() {
        double d = AngleUtils.difference(this.positiveAngle, this.negativeAngle);
        if (Math.abs(d) < 0.005) {
            return 1.0;
        }
        double d2 = this.getAngleAdvance() / d;
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (d2 <= 0.0) {
            d2 = 1.0;
        }
        return d2;
    }

    public double getVelocity() {
        return Rules.getBulletSpeed((double)this.energy);
    }

    public double getAimingRatio(Position position) {
        return this.getAimingRatio(this.source.getDirectionTo(position));
    }

    public double getAimingRatio() {
        if (this.aimingRatio == -1.0) {
            this.aimingRatio = this.getAimingRatio(this.firingAngle);
        }
        return this.aimingRatio;
    }

    public double getAimingRatio(double d) {
        double d2 = AngleUtils.difference(d, this.negativeAngle) / AngleUtils.difference(this.middleAngle, this.negativeAngle);
        double d3 = AngleUtils.difference(d, this.middleAngle) / AngleUtils.difference(this.positiveAngle, this.middleAngle);
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d3 > 1.0) {
            return 1.0;
        }
        if (d3 < 0.0) {
            return d2 / 2.0;
        }
        return d3 / 2.0 + 0.5;
    }

    public static BulletTracking remove(Deque<BulletTracking> deque, Bullet bullet) {
        BulletTracking bulletTracking2 = null;
        for (BulletTracking bulletTracking2 : deque) {
            if (bulletTracking2.getBullet() != bullet) continue;
            deque.remove(bulletTracking2);
            break;
        }
        return bulletTracking2;
    }

    public long getETA(Position position) {
        return this.time + Math.round(this.source.distance(position) / this.getVelocity()) - 1L;
    }

    public double getEnergy() {
        return this.energy;
    }

    public Opponent getOwner() {
        return this.owner;
    }

    public long getTime() {
        return this.time;
    }

    public Position getSource() {
        return this.source;
    }

    public Bullet getBullet() {
        return this.bullet;
    }

    public Opponent getTargetOpponent() {
        return this.targetOpponent;
    }

    public void onPaint(Graphics2D graphics2D) {
        graphics2D.drawLine((int)this.source.x, (int)this.source.y, (int)this.negativeEscapePosition.x, (int)this.negativeEscapePosition.y);
        graphics2D.drawLine((int)this.source.x, (int)this.source.y, (int)this.positiveEscapePosition.x, (int)this.positiveEscapePosition.y);
    }

    public double getDamage() {
        return Rules.getBulletDamage((double)this.energy);
    }

    public Position getPositiveEscapePosition() {
        return this.positiveEscapePosition;
    }

    public double getFiringAngle() {
        return this.firingAngle;
    }

    public void setFiringAngle(double d) {
        this.firingAngle = d;
        double d2 = 0.0;
        if (AngleUtils.difference(this.positiveAngle, this.negativeAngle) > 0.0) {
            double d3;
            d2 = AngleUtils.difference(d, this.negativeAngle);
            if (d3 < 0.0) {
                Log.log(2, "Firing angle outside the escape bounds:" + d2);
                this.firingAngle = this.negativeAngle + 0.03;
            } else {
                double d4;
                d2 = AngleUtils.difference(this.positiveAngle, d);
                if (d4 < 0.0) {
                    Log.log(2, "Firing angle outside the escape bounds:" + d2);
                    this.firingAngle = this.positiveAngle - 0.03;
                }
            }
        } else {
            double d5;
            d2 = AngleUtils.difference(d, this.negativeAngle);
            if (d5 > 0.0) {
                Log.log(2, "Firing angle outside the escape bounds:" + d2);
                this.firingAngle = this.negativeAngle - 0.03;
            } else {
                double d6;
                d2 = AngleUtils.difference(this.positiveAngle, d);
                if (d6 > 0.0) {
                    Log.log(2, "Firing angle outside the escape bounds:" + d2);
                    this.firingAngle = this.positiveAngle + 0.03;
                }
            }
        }
    }

    public Position getNegativeEscapePosition() {
        return this.negativeEscapePosition;
    }

    public Position getTarget() {
        return this.target;
    }

    public double getPositiveAngle() {
        return this.positiveAngle;
    }

    public double getMiddleAngle() {
        return this.middleAngle;
    }

    public double getNegativeAngle() {
        return this.negativeAngle;
    }

    public String toString() {
        return "Source " + this.source + "@" + this.time + "(" + this.energy + ") -> " + this.negativeAngle + ", " + this.middleAngle + ", " + this.positiveAngle;
    }

    public void setEvaded() {
        this.evaded = true;
    }

    public boolean getEvaded() {
        return this.evaded;
    }

    public double getDistance() {
        if (this.distance == -1.0) {
            this.distance = this.source.distance(this.target);
        }
        return this.distance;
    }

    public double[] getEscapeBins() {
        assert (this.owner != null);
        return this.owner.getOpponentAiming().getEscapeBins(this);
    }

    public boolean isTowardWall() {
        return this.towardWall;
    }

    public void paint(int n, long l) {
        Color color = new Color(255, 255, 255, 70);
        Log.paintCircle(n, this.source, (int)(Rules.getBulletSpeed((double)this.energy) * (double)(l - this.time)), color, 0);
        Log.paintLine(n, this.source, this.negativeAngle, color, 0);
        Log.paintLine(n, this.source, this.positiveAngle, color, 0);
    }

    public double getTatgetDistanceFromWall() {
        return this.targetNormalizedWallDistance;
    }

    public double getSourceDistanceFromWall() {
        return this.sourceNormalizedWallDistance;
    }

    public double getTargetVelocity() {
        return Math.abs(this.targetVelocity);
    }

    public double getMidAngleRatio() {
        return this.midAngleRatio;
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public AimingInfo getAimingInfo() {
        return this.aimingInfo;
    }

    public void setAimingInfo(AimingInfo aimingInfo) {
        this.aimingInfo = aimingInfo;
    }

    public void adjustForBulletCatchers() {
        if (this.bulletCatcherAdjusted) {
            return;
        }
        this.bulletCatcherAdjusted = true;
        double d = Utils.getRandom().nextGaussian() / 10000.0;
        this.setFiringAngle(this.getFiringAngle() + d);
    }

    public boolean isSimulated() {
        return this.simulated;
    }

    public double getRelativeHeading() {
        return this.targetRelativeHeading;
    }

    public double getLast15() {
        return this.targetDistanceTraveled15;
    }
}

