/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import mue.Knowledge;
import mue.Util;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobocodeFileWriter;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.WinEvent;

abstract class RobotBase
extends TeamRobot {
    private static long skippedTurns = 0L;
    private static long turns = 1L;
    private static int rounds = 0;
    private Knowledge knowledge;
    private boolean silent = false;
    private boolean endOfRound;
    private double lastHeading;
    private int lastVelocity = 0;
    private double lastX;
    private double lastY;
    private double oldHeading;
    private int oldVelocity = 0;
    private double oldX;
    private double oldY;
    private int oldAcceleration = 0;
    private double lastEnergy;

    protected void init() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.lastEnergy = this.getEnergy();
        this.knowledge = new Knowledge(this);
        this.endOfRound = false;
    }

    public void run() {
        try {
            this.init();
            this.action();
        }
        catch (RuntimeException runtimeException) {
            try {
                PrintWriter printWriter = new PrintWriter((Writer)new RobocodeFileWriter(this.getLogFile().getAbsolutePath(), true));
                this.printWarnings(printWriter);
                printWriter.println("encountered exception: " + runtimeException.getMessage());
                runtimeException.printStackTrace(printWriter);
                printWriter.close();
                if (printWriter.checkError()) {
                    System.out.println("run: could not write to file.");
                }
                throw runtimeException;
            }
            catch (IOException iOException) {
                System.out.println("run: error while writing to file: " + iOException.getMessage());
            }
        }
    }

    protected abstract void action();

    public void execute() {
        this.oldAcceleration = Math.abs(this.oldVelocity) < Math.abs(this.lastVelocity) ? 1 : (Math.abs(this.oldVelocity) > Math.abs(this.lastVelocity) ? -1 : 0);
        this.oldX = this.lastX;
        this.oldY = this.lastY;
        this.oldHeading = this.lastHeading;
        this.oldVelocity = this.lastVelocity;
        this.lastX = this.getX();
        this.lastY = this.getY();
        this.lastHeading = this.getHeading();
        this.lastVelocity = (int)Math.round(this.getVelocity());
        double d = this.lastEnergy - this.getEnergy();
        if (Math.abs(d) > 1.0E-4 && (!this.knowledge.inactivityTimerExpired() || Math.abs(d - 0.1) > 1.0E-4)) {
            this.knowledge.updateEnergyChange(this.getTime());
        }
        this.lastEnergy = this.getEnergy();
        super.execute();
    }

    protected double setTurn(double d) {
        double d2 = Util.relativeAngle(this.getHeading(), d);
        this.setTurnRight(d2);
        return d2;
    }

    protected double setTurnGun(double d) {
        double d2 = Util.relativeAngle(this.getGunHeading(), d);
        this.setTurnGunRight(d2);
        return d2;
    }

    protected double setTurnRadar(double d) {
        double d2 = Util.relativeAngle(this.getRadarHeading(), d);
        this.setTurnRadarRight(d2);
        return d2;
    }

    protected double setTurnRadians(double d) {
        double d2 = Util.relativeAngleRadians(this.getHeadingRadians(), d);
        this.setTurnRightRadians(d2);
        return d2;
    }

    protected double setTurnGunRadians(double d) {
        double d2 = Util.relativeAngleRadians(this.getGunHeadingRadians(), d);
        this.setTurnGunRightRadians(d2);
        return d2;
    }

    protected double setTurnRadarRadians(double d) {
        double d2 = Util.relativeAngleRadians(this.getRadarHeadingRadians(), d);
        this.setTurnRadarRightRadians(d2);
        return d2;
    }

    protected final boolean isInsideField(double d, double d2) {
        return d >= 18.0 && d2 >= 18.0 && d <= this.getBattleFieldWidth() - 18.0 && d2 <= this.getBattleFieldHeight() - 18.0;
    }

    protected final void setSilent(boolean bl) {
        this.silent = bl;
    }

    protected final boolean isSilent() {
        return this.silent;
    }

    public void print(String string) {
        if (!this.silent) {
            this.out.print(string);
        }
    }

    public void println(String string) {
        if (!this.silent) {
            this.out.println(string);
        }
    }

    protected final long getSkippedTurns() {
        return skippedTurns;
    }

    public final double getOldX() {
        return this.oldX;
    }

    public final double getOldY() {
        return this.oldY;
    }

    public final double getOldHeading() {
        return this.oldHeading;
    }

    public final int getOldVelocity() {
        return this.oldVelocity;
    }

    public final int getOldAcceleration() {
        return this.oldAcceleration;
    }

    public final Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
        ++skippedTurns;
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.knowledge.update(scannedRobotEvent);
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        this.knowledge.update(robotDeathEvent);
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        this.knowledge.update(bulletHitEvent);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        this.knowledge.update(hitByBulletEvent);
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        this.knowledge.update(bulletHitBulletEvent);
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        this.knowledge.update(hitRobotEvent);
    }

    public void onWin(WinEvent winEvent) {
        if (!this.endOfRound) {
            this.onEndOfRound();
            if (this.getRoundNum() == this.getNumRounds() - 1) {
                this.onEndOfBattle();
            }
            this.endOfRound = true;
        }
    }

    public void onDeath(DeathEvent deathEvent) {
        if (!this.endOfRound) {
            this.onEndOfRound();
            if (this.getRoundNum() == this.getNumRounds() - 1) {
                this.onEndOfBattle();
            }
            this.endOfRound = true;
        }
    }

    protected void onEndOfRound() {
        turns += this.getTime();
        ++rounds;
    }

    protected File getLogFile() {
        String string = ((Object)((Object)this)).getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length() - 1) {
            string = string.substring(n + 1);
        }
        return this.getDataFile(String.valueOf(string) + ".log");
    }

    protected void onEndOfBattle() {
        this.println("skipped turns: " + skippedTurns + " (" + (double)skippedTurns * 100.0 / (double)turns + "%)");
        if (rounds != this.getNumRounds()) {
            Util.addWarning("missed " + (this.getNumRounds() - rounds) + " rounds!");
        }
        if (Util.getWarnings().size() > 0) {
            try {
                PrintWriter printWriter = new PrintWriter((Writer)new RobocodeFileWriter(this.getLogFile().getAbsolutePath(), true));
                this.printWarnings(printWriter);
                printWriter.close();
                if (printWriter.checkError()) {
                    System.out.println("onEndOfBattle: could not write to file.");
                }
            }
            catch (IOException iOException) {
                System.out.println("onEndOfBattle: error while writing to file: " + iOException.getMessage());
            }
        }
    }

    protected void printWarnings(PrintWriter printWriter) {
        Iterator iterator = Util.getWarnings().iterator();
        if (iterator.hasNext()) {
            printWriter.println("warnings: ");
        }
        while (iterator.hasNext()) {
            printWriter.println("  " + (String)iterator.next());
            iterator.remove();
        }
    }
}

