/*
 * Decompiled with CFR 0.152.
 */
package rtk;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import robocode.Bullet;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import rtk.Aiming;
import rtk.ArrayListCapped;
import rtk.BulletEnemy;
import rtk.EnemyData;
import rtk.Help;
import rtk.HitMeData;
import rtk.PatternData;
import rtk.Tachikoma;

public class Enemy {
    private static final int HISTORY_CAP = 300;
    private static final int PREDICT_AHEAD_COUNT = 50;
    private static final int RANDOM_POS_MAX_DISTANCE = 30;
    private static final int PATTERN_MATCH_COUNT_WANT = 10;
    private static final double PATTERN_MATCH_MAX_DIF = 1.0;
    private static final int MATCH_PATTERN_START = 0;
    private static final int MATCH_PATTERN_LENGTH = 10;
    private static final int MAX_BULLET_HIT_DISTANCE_ERROR = 60;
    private static List<Enemy> list = new ArrayList<Enemy>();
    private Tachikoma robot;
    private EnemyData data;
    public String name;
    private List<EnemyData> history = new ArrayListCapped<EnemyData>(300);
    private List<HitMeData> hitMeList = new ArrayList<HitMeData>();
    private long lastUpdatedTime = 0L;
    private boolean alive = false;
    private List<EnemyData> predictList = new ArrayList<EnemyData>();
    private List<EnemyData> patternList = new ArrayList<EnemyData>();
    private int lastPatternMatchCount = 0;
    private double lastPatternMatchMaxDif = 0.0;
    private boolean robotFired = false;
    private double hitRobot = 0.0;
    private double gotShotByRobot = 0.0;
    private List<BulletEnemy> bullets = new ArrayList<BulletEnemy>();
    private static List<PatternData> patternDataList = new ArrayList<PatternData>();
    private int currentPatternPos = -1;
    private Aiming aiming;
    private Random random = new Random();
    private double firingAngleMultiplyer = 0.0;
    private double firingAngle = 0.0;
    private EnemyData aimingRandomPos = null;
    private double[] bestAimingHitRate = new double[Aiming.PREDICT_POS_DATA_TIME_DISTANCES.length];
    private Aiming.AimTypeEnemy aimingMethod = Aiming.AimTypeEnemy.LastSeenPlace;
    private Aiming.AimTypeEnemy aimingMethodLast = null;

    public static List<Enemy> getList() {
        ArrayList<Enemy> l = new ArrayList<Enemy>();
        for (Enemy e : list) {
            if (!e.alive) continue;
            l.add(e);
        }
        return l;
    }

    public static List<Enemy> getListAll() {
        return list;
    }

    private static void add(Enemy e) {
        list.add(e);
    }

    public static void removeAll() {
        int i = 0;
        while (i < list.size()) {
            Enemy.remove(i);
            ++i;
        }
    }

    public static void remove(int id) {
        Enemy e = list.get(id);
        e.alive = false;
    }

    public static void deleteAll() {
        list.clear();
    }

    public static void delete(int id) {
        list.remove(id);
    }

    public static Enemy getFromName(String name) {
        Enemy found = null;
        for (Enemy e : list) {
            if (!e.name.equals(name)) continue;
            found = e;
            break;
        }
        return found;
    }

    public static int getIDFromName(String name) {
        int found = -1;
        int i = 0;
        while (i < list.size()) {
            if (Enemy.list.get((int)i).name.equals(name)) {
                found = i;
                break;
            }
            ++i;
        }
        return found;
    }

    private static void bulletTick() {
        for (Enemy e : Enemy.getListAll()) {
            int i = e.bullets.size() - 1;
            while (i >= 0) {
                BulletEnemy be = e.bullets.get(i);
                be.tick();
                if (!be.isActive()) {
                    e.bullets.remove(i);
                }
                --i;
            }
        }
    }

    public static void Tick(Tachikoma robot, boolean robotFired, Bullet hitRobot, List<Bullet> gotShotByRobot, long robotTime, int roundNum) {
        for (Enemy e : Enemy.getList()) {
            e.tick(robotTime, roundNum);
            e.predictList.clear();
            e.robotFired = robotFired;
            e.hitRobot = 0.0;
            if (hitRobot != null && hitRobot.getName().equals(e.name)) {
                e.hitRobot = hitRobot.getPower();
            }
            e.gotShotByRobot = 0.0;
            for (Bullet b : gotShotByRobot) {
                if (!b.getVictim().equals(e.name)) continue;
                e.gotShotByRobot += b.getPower();
            }
        }
        Enemy.bulletTick();
        int i = 0;
        while (i < 50) {
            int j = 0;
            while (j < Enemy.getList().size()) {
                Enemy e = Enemy.getList().get(j);
                EnemyData d = i == 0 ? new EnemyData(e.data) : new EnemyData(e.predictList.get(i - 1));
                d = e.predictData(d, false);
                if (i > 0) {
                    int k = 0;
                    while (k <= j) {
                        Enemy e2 = Enemy.getList().get(k);
                        Point2D pos = k == j ? robot.Pos(-i) : e2.predictList.get(e2.predictList.size() - 1).getPosition();
                        if (d.getPosition().distance(pos) < Tachikoma.TANK_SIZE / 1.38) {
                            d.stop();
                            if (k != j) {
                                e2.predictList.get(e2.predictList.size() - 1).stop();
                            }
                        }
                        ++k;
                    }
                }
                e.predictList.add(d);
                ++j;
            }
            ++i;
        }
    }

    public static Enemy getClosestEnemy(Point2D pos) {
        double closest = Double.MAX_VALUE;
        Enemy closestE = null;
        for (Enemy e : list) {
            double dis;
            if (closestE == null) {
                closestE = e;
            }
            if (!((dis = pos.distance(e.getData(0).getPosition())) < closest)) continue;
            closest = dis;
            closestE = e;
        }
        return closestE;
    }

    public static void setRandomPositions(Point2D robotPos) {
        for (Enemy e : Enemy.getList()) {
            double dis = robotPos.distance(e.getData(0).getPosition()) / Rules.getBulletSpeed((double)1.0);
            e.getRandomPos(dis, true);
        }
    }

    public static Enemy scan(ScannedRobotEvent enemy, Tachikoma robot, long robotTime) {
        Enemy found = Enemy.getFromName(enemy.getName());
        if (found == null) {
            found = new Enemy(enemy, robot, robotTime);
        } else {
            if (!found.alive) {
                found.alive = true;
                found.lastUpdatedTime = 0L;
                found.robot = robot;
                found.bullets.clear();
            }
            found.updateFromScan(enemy, robotTime - found.lastUpdatedTime);
            found.lastUpdatedTime = robotTime;
        }
        return found;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Enemy(ScannedRobotEvent enemy, Tachikoma robot, long robotTime) {
        this.robot = robot;
        this.alive = true;
        this.lastUpdatedTime = 0L;
        this.data = new EnemyData();
        this.updateFromScan(enemy, robotTime - this.lastUpdatedTime);
        this.lastUpdatedTime = robotTime;
        Enemy.add(this);
        this.aiming = new Aiming(this);
    }

    public void updateFromScan(ScannedRobotEvent enemy, double notUpdatedTimeSpanReal) {
        long robotTime = this.robot.getTime();
        double notUpdatedTimeSpan = 1.0;
        this.name = enemy.getName();
        EnemyData d = new EnemyData();
        d.setReal(true);
        d.setBotCount(this.robot.others + 1);
        d.setTime(robotTime);
        d.setBearing(enemy.getBearing());
        d.setDistance(enemy.getDistance());
        d.setHeading(enemy.getHeading());
        d.setVelocity(enemy.getVelocity());
        d.setPosition(Help.calcPos(new Point2D.Double(this.robot.getX(), this.robot.getY()), this.robot.getHeading() + d.getBearing() % 360.0, d.getDistance()));
        d.setVelLat(Help.calcFromDirX(Help.calcAngleDiff(Help.calcDirection(this.robot.Pos(), d.getPosition()), d.getHeading()), d.getVelocity()));
        d.setVelAdv(-Help.calcFromDirY(Help.calcAngleDiff(Help.calcDirection(this.robot.Pos(), d.getPosition()), d.getHeading()), d.getVelocity()));
        d.setClosestWallDistance(Help.calcClosestWallDis(d.getPosition()));
        d.setAheadWallDistance(Help.calcWallAheadDis(d.getPosition(), d.getVelocity(), d.getHeading(), false));
        d.setDPosition(new Point2D.Double((d.getPosition().getX() - this.data.getPosition().getX()) / notUpdatedTimeSpan, (d.getPosition().getY() - this.data.getPosition().getY()) / notUpdatedTimeSpan));
        d.setDHeading(Help.calcAngleDiff(d.getHeading(), this.data.getHeading()) / notUpdatedTimeSpan);
        d.setDVelocity((d.getVelocity() - this.data.getVelocity()) / notUpdatedTimeSpan);
        if (Math.abs(d.getDVelocity()) > Math.max(1.0, 2.0)) {
            if (d.getCloestWallDistance() < Tachikoma.TANK_SIZE) {
                d.setHitWall(Rules.getWallHitDamage((double)this.data.getVelocity()));
            } else {
                d.setHitOther(0.6);
            }
        }
        d.setDDistance((d.getDistance() - this.data.getDistance()) / notUpdatedTimeSpan);
        d.setDVelLat((d.getVelLat() - this.data.getVelLat()) / notUpdatedTimeSpan);
        d.setDVelAdv((d.getVelAdv() - this.data.getVelAdv()) / notUpdatedTimeSpan);
        if (d.getDVelocity() == this.data.getDVelocity()) {
            d.setLastDVelocity(d.getLastDVelocity() + 1);
        } else {
            d.setLastDVelocity(0);
        }
        if (d.getDHeading() == this.data.getDHeading()) {
            d.setLastDHeading(d.getLastDHeading() + 1);
        } else {
            d.setLastDHeading(0);
        }
        d.setEnergy(enemy.getEnergy());
        d.setDEnergy((this.data.getEnergy() - d.getEnergy()) / notUpdatedTimeSpanReal);
        this.data = d = this.checkEnergy(d, robotTime, notUpdatedTimeSpanReal);
        this.historyAdd(this.data);
    }

    private EnemyData checkEnergy(EnemyData d, long robotTime, double notUpdatedTimeSpan) {
        double dEnergy = this.data.getDEnergy();
        d.setFired(0.0);
        d.setHit(0.0);
        d.setGunHeat(this.data.getGunHeat());
        if (this.robot.isOneOnOne()) {
            double dif = dEnergy + Rules.getBulletHitBonus((double)this.hitRobot) - Rules.getBulletDamage((double)this.gotShotByRobot) - this.data.getHitWall();
            for (Enemy e : list) {
                if (e.name == this.name) {
                    if (!(d.getPosition().distance(this.robot.Pos()) <= Tachikoma.TANK_SIZE) || !Utils.isNear((double)dif, (double)0.6)) continue;
                    d.setHitOther(dif);
                    break;
                }
                if (!(d.getPosition().distance(e.getData(0).getPosition()) <= Tachikoma.TANK_SIZE) || !Utils.isNear((double)dif, (double)0.6)) continue;
                d.setHitOther(dif);
                break;
            }
            if (this.data.getHitOther() > 0.0) {
                dif -= this.data.getHitOther();
            }
            if (dif > 0.09 && dif < 3.01) {
                dif = Math.max(dif, 0.1);
                dif = Math.min(dif, 3.0);
                d.setFired(dif);
                d.setGunHeat(Rules.getGunHeat((double)dif));
                double offset = Math.max(notUpdatedTimeSpan / 2.0, 1.0) - 1.0;
                Aiming.AimTypeEnemy[] aimTypeEnemyArray = Aiming.AimTypeEnemy.values();
                int n = aimTypeEnemyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Aiming.AimTypeEnemy aimType = aimTypeEnemyArray[n2];
                    Point2D tarPos = this.robot.calcTarPos(aimType, this.getData((int)(2.0 + offset)).getPosition(), dif);
                    double h = Help.calcDirection(this.getData((int)(2.0 + offset)).getPosition(), tarPos);
                    Point2D pos = new Point2D.Double(this.getData((int)(2.0 + offset)).getPosition().getX(), this.getData((int)(2.0 + offset)).getPosition().getY());
                    pos = Help.calcPos(pos, h, Rules.getBulletSpeed((double)dif) * (offset + 1.0));
                    BulletEnemy be = new BulletEnemy(h, pos.getX(), pos.getY(), dif, this.name, this.robot.name, true, (int)((double)(robotTime - 1L) - offset), this.robot, notUpdatedTimeSpan, aimType);
                    this.bullets.add(be);
                    ++n2;
                }
            }
            d.setHit(this.hitRobot);
            d.setHitRobot(this.hitRobot);
            d.setRobotShot(this.robotFired);
        }
        this.gotShotByRobot = 0.0;
        return d;
    }

    private void tick(long robotTime, int roundNum) {
        if (robotTime > this.lastUpdatedTime) {
            this.data = this.predictData(this.data, true);
            this.historyAdd(this.data);
        }
        this.data.setGunHeat(Math.max(this.data.getGunHeat() - this.robot.getGunCoolingRate(), 0.0));
        if (this.robot.isOneOnOne()) {
            this.patternList.clear();
            this.currentPatternPos = this.matchPattern(0, 10);
        }
        this.aiming.tick(robotTime, roundNum);
        int i = 0;
        while (i < Aiming.PREDICT_POS_DATA_TIME_DISTANCES.length) {
            this.calcBestAimingHitRate(i);
            ++i;
        }
    }

    private EnemyData predictData(EnemyData d, boolean CalcSimpleCollisions) {
        return this.predictData(d, 1, CalcSimpleCollisions, null);
    }

    private EnemyData predictData(EnemyData d, int howFarIntoFuture, boolean CalcSimpleCollisions, EnemyData pastD) {
        if (pastD != null) {
            d.setDVelocity(pastD.getDVelocity());
            d.setDHeading(pastD.getDHeading());
        } else {
            d.setReal(false);
        }
        if (d.getVelocity() >= 0.0 && d.getDVelocity() >= 0.0) {
            d.setDVelocity(Math.min(d.getDVelocity(), 1.0));
            d.setVelocity(Math.min(d.getVelocity() + d.getDVelocity(), 8.0));
        } else if (d.getVelocity() >= 0.0 && d.getDVelocity() < 0.0) {
            d.setDVelocity(Math.min(d.getDVelocity(), 2.0));
            d.setVelocity(Math.max(d.getVelocity() + d.getDVelocity(), -8.0));
        } else if (d.getVelocity() < 0.0 && d.getDVelocity() < 0.0) {
            d.setDVelocity(Math.max(d.getDVelocity(), -1.0));
            d.setVelocity(Math.max(d.getVelocity() + d.getDVelocity(), -8.0));
        } else if (d.getVelocity() < 0.0 && d.getDVelocity() >= 0.0) {
            d.setDVelocity(Math.max(d.getDVelocity(), -2.0));
            d.setVelocity(Math.min(d.getVelocity() + d.getDVelocity(), 8.0));
        }
        d.setHeading((d.getHeading() - d.getDHeading() + 360.0) % 360.0);
        Point2D pos = Help.calcPos(d.getPosition(), d.getHeading(), d.getVelocity());
        if (pos.getX() <= Tachikoma.TANK_SIZE / 10.0 || pos.getX() >= (double)Tachikoma.FIELD_WIDTH - Tachikoma.TANK_SIZE / 10.0 || pos.getY() <= Tachikoma.TANK_SIZE / 10.0 || pos.getY() >= (double)Tachikoma.FIELD_HEIGHT - Tachikoma.TANK_SIZE / 10.0) {
            d.stop();
        }
        if (CalcSimpleCollisions) {
            for (Enemy e : Enemy.getList()) {
                Point2D p = e.name.equals(this.name) ? this.robot.Pos(-howFarIntoFuture) : Help.calcPos(e.getData(0).getPosition(), e.getData(0).getHeading(), (double)howFarIntoFuture * e.getData(0).getVelocity());
                if (!(pos.distance(p) < Tachikoma.TANK_SIZE / 1.38)) continue;
                d.stop();
            }
        }
        d.setPosition(Help.calcPos(d.getPosition(), d.getHeading(), d.getVelocity()));
        return d;
    }

    public EnemyData getData(int howLongAgo) {
        EnemyData d;
        if (howLongAgo >= 0) {
            if (howLongAgo > this.historySize() || howLongAgo == 0) {
                return this.data;
            }
            return this.historyGet(howLongAgo);
        }
        if (-howLongAgo <= this.predictList.size()) {
            d = new EnemyData(this.predictList.get(-howLongAgo - 1));
        } else {
            d = this.predictList.size() > 0 ? new EnemyData(this.predictList.get(this.predictList.size() - 1)) : new EnemyData(this.data);
            ArrayList<EnemyData> l = new ArrayList<EnemyData>();
            int i = 0;
            while (i < -howLongAgo - this.predictList.size()) {
                d = new EnemyData(d);
                d = this.predictData(d, i + this.predictList.size(), true, null);
                l.add(d);
                ++i;
            }
            this.predictList.addAll(l);
        }
        return d;
    }

    public EnemyData getDataFromPattern(int tLength) {
        EnemyData d;
        if (!this.robot.isOneOnOne()) {
            return this.data;
        }
        int tPos = this.getCurrentPatternPos();
        if (tLength < this.patternList.size()) {
            d = new EnemyData(this.patternList.get(tLength));
        } else {
            d = this.patternList.size() > 0 ? new EnemyData(this.patternList.get(this.patternList.size() - 1)) : new EnemyData(this.data);
            ArrayList<EnemyData> l = new ArrayList<EnemyData>();
            int i = 0;
            while (i < tLength - this.patternList.size()) {
                d = new EnemyData(d);
                if (tPos - this.patternList.size() - i >= 0) {
                    EnemyData pastD = this.getData(tPos - this.patternList.size() - i);
                    d = this.predictData(d, i + this.patternList.size(), true, pastD);
                    l.add(d);
                } else {
                    d = this.predictData(d, i, true, null);
                    l.add(d);
                }
                ++i;
            }
            this.patternList.addAll(l);
        }
        return d;
    }

    public int historySize() {
        return this.history.size();
    }

    private void historyAdd(EnemyData d) {
        this.history.add(d);
    }

    private EnemyData historyGet(int n) {
        return this.history.get(this.historySize() - n);
    }

    public void shotMe(Bullet e, boolean hitBulletOnly) {
        BulletEnemy b;
        double closest = Double.MAX_VALUE;
        BulletEnemy foundb = null;
        int i = this.bullets.size() - 1;
        while (i >= 0) {
            b = this.bullets.get(i);
            double dis = b.getPos().distance(new Point2D.Double(e.getX(), e.getY()));
            if (dis < closest) {
                closest = dis;
                foundb = b;
            }
            --i;
        }
        if (foundb != null && closest <= 60.0 * foundb.getPossibleAreaSize()) {
            foundb.setActive(false);
            if (!hitBulletOnly) {
                long robotTime = this.robot.getTime();
                HitMeData hitMeData = new HitMeData(robotTime, foundb.getShotTime());
                this.hitMeList.add(hitMeData);
                this.hitRobot(foundb.getAiming());
            }
            i = this.bullets.size() - 1;
            while (i >= 0) {
                b = this.bullets.get(i);
                if (b.getShotTime() == foundb.getShotTime() && b.getAiming() != foundb.getAiming()) {
                    b.setActive(false);
                }
                --i;
            }
            this.removeInactiveBullets();
        }
    }

    private void removeInactiveBullets() {
        int i = this.bullets.size() - 1;
        while (i >= 0) {
            BulletEnemy b = this.bullets.get(i);
            if (b != null) {
                if (!b.isActive()) {
                    this.bullets.remove(i);
                }
            } else {
                this.bullets.remove(i);
            }
            --i;
        }
    }

    private void hitRobot(Aiming.AimTypeEnemy aimingMethod) {
        if (this.aimingMethodLast == null) {
            this.aimingMethodLast = this.aimingMethod = aimingMethod;
        } else if (aimingMethod == this.aimingMethod) {
            this.aimingMethodLast = this.aimingMethod;
        } else if (aimingMethod == this.aimingMethodLast) {
            this.aimingMethod = this.aimingMethodLast;
        } else {
            this.aimingMethodLast = aimingMethod;
        }
    }

    public List<BulletEnemy> getBullets() {
        return this.bullets;
    }

    public List<HitMeData> getHitMeList() {
        return this.hitMeList;
    }

    public int matchPattern(int tPos, int tLength) {
        double maxDif;
        double a;
        if (tLength > this.historySize()) {
            tLength = this.historySize();
        }
        patternDataList.clear();
        if (this.lastPatternMatchCount < 1) {
            this.lastPatternMatchCount = 1;
        }
        if ((a = (double)(10 - this.lastPatternMatchCount) / (this.lastPatternMatchCount <= 10 ? 10.0 : 1000.0)) > 0.25) {
            a = 0.25;
        }
        if (a < -0.25) {
            a = -0.25;
        }
        if ((maxDif = this.lastPatternMatchMaxDif + a) > 1.0) {
            maxDif = 1.0;
        } else if (maxDif <= 1.0E-4) {
            maxDif = 1.0E-4;
        }
        this.lastPatternMatchMaxDif = maxDif;
        int i = tLength;
        while (i < this.historySize() - tLength) {
            PatternData pat = new PatternData(i);
            double dif = 0.0;
            int j = 0;
            while (j < tLength) {
                EnemyData dPat = this.getData(tPos + j);
                EnemyData dHis = this.getData(i + j);
                double d = Math.pow(Math.pow(dPat.getDVelocity() - dHis.getDVelocity(), 2.0) + Math.pow(dPat.getDHeading() - dHis.getDHeading(), 2.0) + Math.pow(dPat.getLastDHeading() - dHis.getLastDHeading(), 2.0) + Math.pow(dPat.getLastDVelocity() - dHis.getLastDVelocity(), 2.0) + Math.pow((dPat.getAheadWallDistance() < Tachikoma.TANK_SIZE / 2.0 ? 10 : 0) - (dHis.getAheadWallDistance() < Tachikoma.TANK_SIZE / 2.0 ? 10 : 0), 2.0) + Math.pow((dPat.getHit() > 0.0 ? 1 : 0) - (dHis.getHit() > 0.0 ? 1 : 0), 2.0), 0.5);
                if (!dPat.getReal() || !dHis.getReal()) {
                    d += 0.1;
                }
                dif += d;
                pat.add(dHis.getDVelocity(), dHis.getDHeading());
                ++j;
            }
            pat.setDif(dif /= (double)tLength);
            if (pat.getDif() < maxDif) {
                patternDataList.add(pat);
            }
            ++i;
        }
        this.lastPatternMatchCount = patternDataList.size();
        return this.getMostSimilarPatternData();
    }

    public int getCurrentPatternPos() {
        return this.currentPatternPos;
    }

    public double getHitRate(Aiming.AimType aimType, int dis) {
        return this.aiming.getHitRate(aimType, dis);
    }

    public int getHitRateSize(Aiming.AimType aimType, int dis) {
        return this.aiming.getHitRateSize(aimType, dis);
    }

    public double getHitRateTime(Aiming.AimType aimType, int dis) {
        return this.aiming.getHitRateTime(aimType, dis);
    }

    public int getHitRateTimeSize(Aiming.AimType aimType, int dis) {
        return this.aiming.getHitRateTimeSize(aimType, dis);
    }

    public EnemyData getRandomPos(double distance, boolean set) {
        if (distance > 30.0) {
            distance = 30.0;
        }
        EnemyData d = new EnemyData(this.data);
        boolean forward = this.random.nextBoolean();
        int dis = (int)(this.random.nextDouble() * distance);
        int i = 0;
        while (i < dis) {
            if (forward) {
                d.setDVelocity(2.0);
            } else {
                d.setDVelocity(-2.0);
            }
            d = this.predictData(d, i, true, null);
            ++i;
        }
        if (set) {
            this.setAimingRandomPos(d);
        }
        return d;
    }

    private int getMostSimilarPatternData() {
        int i = 0;
        while (i < patternDataList.size()) {
            int j = 0;
            while (j < i) {
                patternDataList.get(i).addOtherVal(patternDataList.get(j).getValue());
                patternDataList.get(j).addOtherVal(patternDataList.get(i).getValue());
                ++j;
            }
            ++i;
        }
        double top = -1.0;
        int topI = -1;
        int i2 = patternDataList.size() - 1;
        while (i2 >= 0) {
            if (patternDataList.get(i2).getSimilarity() > top) {
                top = patternDataList.get(i2).getSimilarity();
                topI = i2;
            }
            --i2;
        }
        int r = -1;
        if (topI != -1) {
            r = patternDataList.get(topI).getTime();
        }
        return r;
    }

    public double getBestAimingHitRate(int dis) {
        return this.bestAimingHitRate[dis];
    }

    private void calcBestAimingHitRate(int dis) {
        double largest = Double.MIN_VALUE;
        Aiming.AimType[] aimTypeArray = Aiming.AimType.values();
        int n = aimTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Aiming.AimType aim = aimTypeArray[n2];
            double hr = this.getHitRate(aim, dis);
            if (this.getHitRateTimeSize(Aiming.AimType.LookAhead, Aiming.PREDICT_POS_DATA_TIME_DISTANCES.length - 1) > 10) {
                hr = this.getHitRateTime(aim, dis);
            }
            if (hr > largest) {
                largest = hr;
            }
            ++n2;
        }
        this.bestAimingHitRate[dis] = largest;
    }

    public Aiming.AimType getBestAiming(int dis) {
        double largest = Double.MIN_VALUE;
        Aiming.AimType aimType = Aiming.AimType.LookAhead;
        Aiming.AimType[] aimTypeArray = Aiming.AimType.values();
        int n = aimTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Aiming.AimType aim = aimTypeArray[n2];
            double hr = this.getHitRate(aim, dis);
            if (this.getHitRateTimeSize(Aiming.AimType.LookAhead, Aiming.PREDICT_POS_DATA_TIME_DISTANCES.length - 1) > 10) {
                hr = this.getHitRateTime(aim, dis);
            }
            if (hr > largest) {
                largest = hr;
                aimType = aim;
            }
            ++n2;
        }
        return aimType;
    }

    public boolean isAlive() {
        return this.alive;
    }

    private EnemyData calcEnemyPositionFromAiming(Aiming.AimType aimType, int time) {
        EnemyData d = this.data;
        if (aimType == Aiming.AimType.LastSeenPlace) {
            d = this.data;
        } else if (aimType == Aiming.AimType.LookAhead) {
            d = this.getData(-time);
        } else if (aimType == Aiming.AimType.PatternPredict) {
            int patPos = this.getCurrentPatternPos();
            d = patPos != -1 ? this.getDataFromPattern(time) : this.getData(-time);
        } else if (aimType == Aiming.AimType.Random) {
            d = this.getAimingRandomPos();
        }
        return d;
    }

    public Point2D calcTarPos(Aiming.AimType aimType, Point2D robotPos, int fireTime, double power) {
        Point2D tarPos = this.calcEnemyPositionFromAiming(aimType, fireTime).getPosition();
        double bSpeed = Rules.getBulletSpeed((double)power);
        int bTime = (int)Math.round(this.robot.Pos(-1).distance(tarPos) / bSpeed);
        int time = fireTime + bTime;
        int i = 0;
        while (i < time) {
            bTime = (int)Math.round(this.robot.Pos(-1).distance(tarPos) / bSpeed);
            time = fireTime + bTime;
            tarPos = this.calcEnemyPositionFromAiming(aimType, time).getPosition();
            ++i;
        }
        this.setFiringAngle(Help.calcDirection(robotPos, tarPos));
        return tarPos;
    }

    public void setFiringAngle(double a) {
        this.firingAngle = a;
    }

    public double getFiringAngle() {
        return this.firingAngle;
    }

    public void setFiringAngleMultiplyer(double a) {
        this.firingAngleMultiplyer = a;
    }

    public double getFiringAngleMultiplyer() {
        return this.firingAngleMultiplyer;
    }

    public EnemyData getAimingRandomPos() {
        return this.aimingRandomPos;
    }

    private void setAimingRandomPos(EnemyData d) {
        this.aimingRandomPos = d;
    }

    public Aiming.AimTypeEnemy getAimingMethod() {
        return this.aimingMethod;
    }

    public Aiming.AimTypeEnemy getAimingMethodLast() {
        return this.aimingMethodLast;
    }
}

