/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.data;

import lazarecki.data.DataSegmentation;
import lazarecki.data.extrapolation.DataExtrapolator;
import lazarecki.robot.RobotInfo;
import lazarecki.wave.Wave;
import robocode.util.Utils;

public class DataSegmentWave
extends Wave {
    private DataSegmentation.DataQueryResult dataSegment;
    private DataSegmentation.DataQueryResult origDataSegment;
    private DataExtrapolator extrapolator;
    private double absBestFireAngle;
    private double bestGuessFactor;

    public DataSegmentWave(RobotInfo shooter, RobotInfo target, double firePower, DataSegmentation.DataQueryResult dataSegment, DataExtrapolator extrapolator) {
        super(shooter, target, firePower);
        this.origDataSegment = dataSegment;
        this.dataSegment = dataSegment;
        this.extrapolator = extrapolator;
        Wave.ClockDirection targetDirection = this.getDirection();
        int minIndex = 0;
        int maxIndex = this.getDataSegment().getSegments() - 1;
        int bestIndex = (this.getDataSegment().getSegments() - 1) / 2;
        int i = minIndex;
        while (i <= maxIndex) {
            if (this.getDataSegment().getValueAt(i) > this.getDataSegment().getValueAt(bestIndex)) {
                bestIndex = i;
            }
            ++i;
        }
        this.bestGuessFactor = Wave.calculateGuessFactor(this.getDataSegment().getSegments(), bestIndex);
        this.absBestFireAngle = Utils.normalAbsoluteAngle((double)(this.getAbsoluteFireAngle() + Wave.calculateFireAngleOffset(targetDirection, this.bestGuessFactor, this.getFirePower())));
    }

    public DataSegmentation.DataQueryResult getDataSegment() {
        return this.dataSegment;
    }

    public DataExtrapolator getExtrapolator() {
        return this.extrapolator;
    }

    public double getAbsoluteBestFireAngle() {
        return this.absBestFireAngle;
    }

    public double getBestGuessFactor() {
        return this.bestGuessFactor;
    }

    @Override
    public void logTargetHit(RobotInfo targetWhenHit, double hitValue) {
        double value;
        double absBearingWhenHit = this.getShooter().absoluteAngle(targetWhenHit);
        double angleOffset = Utils.normalRelativeAngle((double)(absBearingWhenHit - this.getAbsoluteFireAngle()));
        double guessFactor = Wave.GuessFactor.normalizeGuessFactor(angleOffset / this.getMaxEscapeAngle()) * this.getDirection().getFactor();
        double min = Wave.GuessFactor.Min.getGuessFactor();
        double max = Wave.GuessFactor.Max.getGuessFactor();
        int index = this.origDataSegment.getIndexFor(guessFactor, min, max);
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        int i = 0;
        while (i < this.origDataSegment.getSegments()) {
            value = this.origDataSegment.getValueAt(i);
            double avgValue = this.extrapolator.getValue(index, i, value, hitValue);
            minValue = Math.min(minValue, avgValue);
            maxValue = Math.max(maxValue, avgValue);
            this.origDataSegment.setValueAt(i, avgValue);
            ++i;
        }
        if (minValue != maxValue) {
            i = 0;
            while (i < this.origDataSegment.getSegments()) {
                value = this.origDataSegment.getValueAt(i);
                this.origDataSegment.setValueAt(i, (value - minValue) / (maxValue - minValue));
                ++i;
            }
        }
    }
}

