/*
 * Decompiled with CFR 0.152.
 */
package labg.movement;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import labg.Cataclysm;
import labg.movement.GravPoint;
import labg.movement.MovementStrategy;
import labg.util.Enemy;
import labg.util.EnemyBullet;
import labg.util.EvolutionManager;
import labg.util.Geometry;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class OooMovementStrategy
extends MovementStrategy {
    Cataclysm myBot;
    HashMap enemies;
    EvolutionManager evoMan;
    Vector gravPoints;
    Vector antiGravPoints;
    Vector gotoPoints;
    Vector bullets;
    Random numGen;
    double rand = 0.0;
    boolean arrived = false;
    double counter = 0.0;
    double sign = 1.0;
    int currClosestWall = 0;
    int prevBestPoint = 0;
    int bestPoint = 0;
    int count = 0;

    public OooMovementStrategy(Cataclysm myBot, HashMap enemies, EvolutionManager evoMan) {
        super(myBot);
        this.myBot = myBot;
        this.enemies = enemies;
        this.evoMan = evoMan;
        this.numGen = new Random();
        this.gravPoints = new Vector();
        this.gotoPoints = new Vector();
        this.antiGravPoints = new Vector();
        this.bullets = new Vector();
    }

    public void move() {
        this.antiGravMove();
    }

    private void antiGravMove() {
        this.antiGravPoints = this.generateAntiGravPoints();
        double xforce = 0.0;
        double yforce = 0.0;
        int i = 0;
        while (i < this.antiGravPoints.size()) {
            GravPoint p = (GravPoint)this.antiGravPoints.elementAt(i);
            double force = p.power / Math.pow(Geometry.getRange(this.myBot.getX(), this.myBot.getY(), p.x, p.y), p.raiseTo);
            double ang = Geometry.normaliseBearing(1.5707963267948966 - Math.atan2(this.myBot.getY() - p.y, this.myBot.getX() - p.x));
            double tmpXForce = Math.sin(ang) * force;
            double tmpYForce = Math.cos(ang) * force;
            if (this.myBot.getX() < 100.0 && tmpXForce > 0.0) {
                tmpXForce = 0.0;
            }
            if (this.myBot.getX() > this.myBot.getBattleFieldWidth() - 100.0 && tmpXForce < 0.0) {
                tmpXForce = 0.0;
            }
            if (this.myBot.getY() < 100.0 && tmpYForce > 0.0) {
                tmpYForce = 0.0;
            }
            if (this.myBot.getY() > this.myBot.getBattleFieldHeight() - 100.0 && tmpYForce < 0.0) {
                tmpYForce = 0.0;
            }
            xforce += tmpXForce;
            yforce += tmpYForce;
            ++i;
        }
        Geometry.goTo(this.myBot, this.myBot.getX() - xforce, this.myBot.getY() - yforce);
    }

    private Vector generateAntiGravPoints() {
        this.removeExpiredAntiGravPointsAndBullets();
        if (Geometry.getRange(this.myBot.getBattleFieldWidth() / 2.0, this.myBot.getBattleFieldHeight() / 2.0, this.myBot.getX(), this.myBot.getY()) > 200.0) {
            double power = 10000.0;
            GravPoint central = new GravPoint(this.myBot.getBattleFieldWidth() / 2.0, this.myBot.getBattleFieldHeight() / 2.0, power, 1L, 3.0);
            this.antiGravPoints.add(central);
        }
        if (this.enemies.size() > 0) {
            Collection e = this.enemies.values();
            Iterator it = e.iterator();
            GravPoint bl = new GravPoint(0.0, 0.0, -500000.0, 1L, 3.0);
            this.antiGravPoints.add(bl);
            GravPoint br = new GravPoint(this.myBot.getBattleFieldWidth(), 0.0, -500000.0, 1L, 3.0);
            this.antiGravPoints.add(br);
            GravPoint tl = new GravPoint(0.0, this.myBot.getBattleFieldHeight(), -500000.0, 1L, 3.0);
            this.antiGravPoints.add(tl);
            GravPoint tr = new GravPoint(this.myBot.getBattleFieldWidth(), this.myBot.getBattleFieldHeight(), -500000.0, 1L, 3.0);
            this.antiGravPoints.add(tr);
            while (it.hasNext()) {
                Enemy en = (Enemy)it.next();
                if (!en.isAlive) continue;
                GravPoint p = en.distance > 300.0 ? new GravPoint(en.xPos, en.yPos, 1000.0, 1L, 2.0) : new GravPoint(en.xPos, en.yPos, -1000.0, 1L, 2.0);
                if (!en.energyChanged()) continue;
                double vel = 20.0 - 3.0 * en.energyChangedAmount;
                double heading = Geometry.normaliseHeading(this.myBot.getHeadingRadians() + en.currBearing);
                EnemyBullet newBull = new EnemyBullet(this.myBot, this.evoMan, heading, this.myBot.getHeadingRadians(), vel, en.xPosAdjust, en.yPosAdjust, this.myBot.getX(), this.myBot.getY(), en.timeLastSeen);
                this.bullets.add(newBull);
            }
        }
        int j = 0;
        while (j < this.bullets.size()) {
            EnemyBullet temp = (EnemyBullet)this.bullets.get(j);
            GravPoint[] gpa = temp.getGravPoints();
            int k = 0;
            while (k < gpa.length) {
                if (gpa[k] != null) {
                    this.antiGravPoints.add(gpa[k]);
                }
                ++k;
            }
            ++j;
        }
        return this.antiGravPoints;
    }

    private Vector generateGravPoints() {
        if (this.enemies.size() > 0) {
            Collection e = this.enemies.values();
            Iterator it = e.iterator();
            while (it.hasNext()) {
                Enemy en = (Enemy)it.next();
                if (!en.isAlive) continue;
                GravPoint p = new GravPoint(en.xPos, en.yPos, 1000.0, 1L, 2.0);
                this.gravPoints.add(p);
            }
        }
        return this.gravPoints;
    }

    private void removeExpiredGravPoints() {
        int i = 0;
        while (i < this.gravPoints.size()) {
            ((GravPoint)this.gravPoints.get(i)).decTimeLeft();
            if (((GravPoint)this.gravPoints.get((int)i)).timeLeft == 0L) {
                this.gravPoints.removeElementAt(i);
            }
            ++i;
        }
    }

    private void removeExpiredAntiGravPointsAndBullets() {
        int i = 0;
        while (i < this.antiGravPoints.size()) {
            ((GravPoint)this.antiGravPoints.get(i)).decTimeLeft();
            if (((GravPoint)this.antiGravPoints.get((int)i)).timeLeft == 0L) {
                this.antiGravPoints.removeElementAt(i);
            }
            ++i;
        }
        int j = 0;
        while (j < this.bullets.size()) {
            int expired = ((EnemyBullet)this.bullets.get(j)).updatePosition();
            if (expired == -1) {
                this.bullets.removeElementAt(j);
            }
            ++j;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onDeath(DeathEvent e) {
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    public void onWin(WinEvent e) {
    }

    private class Point {
        public double x;
        public double y;
        public double force = 9.9999999E7;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

