/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.move.surf.models;

import catcat20.atom.robot.BotState;
import catcat20.atom.utils.HConstants;
import catcat20.atom.utils.HUtils;
import catcat20.atom.utils.MovementPredictor;
import catcat20.atom.utils.Wave;
import catcat20.atom.utils.knn.DataPointMaker;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.Rules;
import robocode.util.Utils;

public class GeneticASModel
extends DataPointMaker {
    public GeneticASModel() {
        this.weights = new double[]{10.713925220588484, 2.180942855917877, 2.495694703498005, 5.497528337267813, 0.9879555727156668, 7.96987995371324, 6.120225139268232};
    }

    @Override
    public double[] dataPointFromWave(Wave w) {
        BotState previousMyState = w.prevMyState;
        BotState myState = w.myState;
        BotState enState = w.enState;
        double distance = myState.getPosition().distance(enState.getPosition());
        double bft = distance / w.bulletVelocity();
        double latVel = myState.getVelocity() * Math.sin(myState.getHeading() - w.directAngle);
        double advVel = myState.getVelocity() * -Math.cos(myState.getHeading() - w.directAngle);
        double accel = HUtils.limit(-2.0, HUtils.accel(myState.latVel, previousMyState.latVel), 1.0);
        double mea = HUtils.maxEscapeAngle(w.bulletVelocity());
        double wallDistanceForward = this.orbitalWallDistance(HConstants.field, myState, enState, 1, mea, true) / 1.5;
        double wallDistanceReverse = this.orbitalWallDistance(HConstants.field, myState, enState, -1, mea, true) / 1.5;
        double[] meas = this.getMea(w.bulletPower, myState, enState, w.fireTime);
        double meaWallAhead = w.direction < 0 ? meas[0] : meas[1];
        double meaWallReverse = w.direction > 0 ? meas[0] : meas[1];
        return new double[]{bft / 91.0, Math.abs(latVel) / 8.0, (accel + 1.0) / 3.0, HUtils.limit(0.0, w.myDirChangeTime / 4.0, 30.0) / 30.0, w.myDist16 / 128.0, meaWallAhead, meaWallReverse};
    }

    public double[] getMea(double power, BotState en, BotState myState, long time) {
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.getPosition().x, en.getPosition().y, en.getHeading(), en.getVelocity(), time);
        double absBearing = HUtils.absoluteBearing(myState.getPosition(), en.getPosition());
        double distance = myState.getPosition().distance(en.getPosition());
        double bft = distance / Rules.getBulletSpeed((double)power);
        int count = (int)bft;
        MovementPredictor.PredictionStatus dir1 = (MovementPredictor.PredictionStatus)status.clone();
        double distTravel1 = 0.0;
        for (int i = 0; i < count; ++i) {
            distTravel1 += Rules.getBulletSpeed((double)power);
            double dist1 = myState.getPosition().distance(dir1);
            if (!(dist1 - distTravel1 > 0.0)) break;
            double angle = HUtils.absoluteBearing(dir1, myState.getPosition()) + 1.5707963267948966;
            angle = this.wallSmoothing(dir1, angle, -1);
            dir1 = MovementPredictor.predict(dir1, angle, 8.0);
        }
        double distTravel2 = 0.0;
        MovementPredictor.PredictionStatus dir2 = (MovementPredictor.PredictionStatus)status.clone();
        for (int i = 0; i < count; ++i) {
            distTravel2 += Rules.getBulletSpeed((double)power);
            double dist2 = myState.getPosition().distance(dir2);
            if (!(dist2 - distTravel2 > 0.0)) break;
            double angle = HUtils.absoluteBearing(dir2, myState.getPosition()) - 1.5707963267948966;
            angle = this.wallSmoothing(dir2, angle, 1);
            dir2 = MovementPredictor.predict(dir2, angle, 8.0);
        }
        double mea1 = Utils.normalRelativeAngle((double)(HUtils.absoluteBearing(myState.getPosition(), dir1) - absBearing));
        double mea2 = Utils.normalRelativeAngle((double)(HUtils.absoluteBearing(myState.getPosition(), dir2) - absBearing));
        return new double[]{Math.abs(mea1), Math.abs(mea2)};
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!HConstants.field.contains(HUtils.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05 * 2.0;
        }
        return angle;
    }

    public double orbitalWallDistance(Rectangle2D.Double rect, BotState myState, BotState enemyState, int orbitDirection, double maxEscapeAngle, boolean isForward) {
        Point2D.Double myProjectedLocation;
        double wallDistance;
        if (!isForward) {
            orbitDirection *= -1;
        }
        double absoluteBearing = HUtils.absoluteBearing(enemyState.getPosition(), myState.getPosition());
        double distance = myState.getPosition().distance(enemyState.getPosition());
        for (wallDistance = 0.0; wallDistance < 1.5 * maxEscapeAngle + 0.01 && rect.contains(myProjectedLocation = HUtils.project(enemyState.getPosition(), absoluteBearing + (double)orbitDirection * wallDistance, distance)); wallDistance += 0.01) {
        }
        wallDistance /= maxEscapeAngle;
        wallDistance = Math.min(wallDistance, 1.5);
        return wallDistance;
    }
}

