/*
 * Decompiled with CFR 0.152.
 */
package brainfade.melee.utils;

import brainfade.melee.utils.MeleePatternMatcher;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Enemy {
    public String name = "";
    public double energy = 100.0;
    public double heading = 0.0;
    public double velocity = 0.0;
    public double bearing = 0.0;
    public double distance = 100000.0;
    public double lastDistance = 1000.0;
    public double acceleration = 0.0;
    public double advancingVelocity = 0.0;
    public Point2D position = new Point2D.Double(0.0, 0.0);
    public Point2D lastPosition = new Point2D.Double(0.0, 0.0);
    public double headingChange = 0.0;
    public long time = 0L;
    public long timeSinceLastScan = 0L;
    public int direction = 1;
    public boolean isAlive = true;
    public double bulletTravelTime = 0.0;
    public int forward = 1;
    public MeleePatternMatcher pm = new MeleePatternMatcher();
    public double linearShootAngle;
    public double bulletVelocity = 11.0;
    AdvancedRobot AR;

    public void update(ScannedRobotEvent e, AdvancedRobot AR) {
        this.name = e.getName();
        this.AR = AR;
        this.acceleration = (e.getVelocity() - this.velocity) / (double)(AR.getTime() - this.time);
        this.headingChange = (e.getHeadingRadians() - this.heading) / (double)(AR.getTime() - this.time);
        this.lastDistance = this.distance;
        this.distance = e.getDistance();
        this.heading = e.getHeadingRadians();
        this.velocity = e.getVelocity();
        this.bearing = Utils.normalAbsoluteAngle((double)(e.getBearingRadians() + AR.getHeadingRadians()));
        this.timeSinceLastScan = AR.getTime() - this.time;
        this.time = AR.getTime();
        this.energy = e.getEnergy();
        this.advancingVelocity = -this.velocity * Math.cos(this.heading - this.bearing);
        this.lastPosition = new Point2D.Double(this.position.getX(), this.position.getY());
        this.position = this.vectorToLocation(this.bearing, this.distance, new Point2D.Double(AR.getX(), AR.getY()));
        this.linearShootAngle = Math.asin(this.velocity / 11.0 * Math.sin(this.heading - this.bearing));
        this.direction = this.sign(this.velocity);
        this.pm.add(this);
    }

    public Point2D guessPosition(Point2D me, double firepower) {
        double bulletSpeed = 20.0 - 3.0 * Math.max(Math.min(firepower, 3.0), 0.1);
        double diff = this.distance / bulletSpeed;
        double bulletTime = 0.0;
        double totalChange = 0.0;
        double currentVelocity = this.velocity;
        int i = 0;
        while ((double)i < diff) {
            bulletTime += Math.abs(Math.max(Math.min(currentVelocity += this.acceleration, 8.0), -8.0));
            totalChange += this.headingChange;
            ++i;
        }
        double angle = diff * 8.0 / (2.0 * this.distance);
        double realisedDistance = Math.sin(angle) * this.distance * 2.0;
        return this.vectorToLocation(this.heading, realisedDistance, this.position);
    }

    public double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public Point2D predictPosition(Point2D here, double firepower) {
        return this.pm.predict(here, firepower, this);
    }

    public int getDistanceIndex() {
        if (this.distance < 200.0) {
            return 1;
        }
        if (this.distance < 600.0) {
            return 2;
        }
        return 3;
    }

    public double getGravity(Point2D dest) {
        return this.energy / Math.pow(this.position.distance(dest), 2.0);
    }

    public int getHeadingChangeIndex() {
        if (this.headingChange > 0.0) {
            return 1;
        }
        if (this.headingChange < 0.0) {
            return 2;
        }
        return 3;
    }

    public double getAdvancingVelocity(Point2D point) {
        double av = -this.velocity * Math.cos(this.heading - this.absoluteBearing(point, this.position));
        if (av >= -4.0 && av < 0.0) {
            return 1.0 / Math.abs(av);
        }
        return Math.abs(av);
    }

    public double getMyAdvancingVelocity(Point2D myPosition, Point2D point) {
        double av = Math.cos(this.absoluteBearing(myPosition, point) - this.absoluteBearing(this.position, point));
        return Math.abs(av);
    }

    public int getWallIndex() {
        Point2D predicted = this.vectorToLocation(this.heading, this.sign(this.velocity) * 80, this.position);
        return this.fieldRectangle(0.0).contains(predicted) ? 1 : 2;
    }

    public RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin, this.AR.getBattleFieldWidth() - margin * 2.0, this.AR.getBattleFieldHeight() - margin * 2.0, 75.0, 75.0);
    }

    public Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    public Polygon getPolygon(double time) {
        Point2D p2;
        Point2D p1;
        double xOffset = Math.cos(this.heading) * 18.0;
        double yOffset = Math.sin(this.heading) * 18.0;
        Point2D destination = this.vectorToLocation(this.heading, time * this.velocity, this.position);
        int[] xpos = new int[4];
        int[] ypos = new int[4];
        if (this.position.getY() > destination.getY()) {
            p1 = this.position;
            p2 = destination;
        } else {
            p2 = this.position;
            p1 = destination;
        }
        xpos[0] = (int)(p1.getX() - xOffset);
        xpos[1] = (int)(p1.getX() + xOffset);
        xpos[2] = (int)(p2.getX() + xOffset);
        xpos[3] = (int)(p2.getX() - xOffset);
        ypos[0] = (int)(p1.getY() - yOffset);
        ypos[1] = (int)(p1.getY() - yOffset);
        ypos[2] = (int)(p2.getY() + yOffset);
        ypos[3] = (int)(p2.getY() + yOffset);
        return new Polygon(xpos, ypos, 4);
    }

    public boolean whosClosest(Hashtable targets) {
        Enumeration e = targets.elements();
        double myDistance = this.distance;
        int counter = 0;
        while (e.hasMoreElements()) {
            Enemy en = (Enemy)e.nextElement();
            if (!(en.position.distance(this.position) * 0.9 < myDistance)) continue;
            ++counter;
        }
        return counter < 4;
    }

    public int sign(double value) {
        if (value < 0.0) {
            return -1;
        }
        return 1;
    }

    public void reset() {
        this.energy = 100.0;
        this.heading = 0.0;
        this.velocity = 0.0;
        this.bearing = 0.0;
        this.distance = 10000.0;
        this.lastDistance = 1000.0;
        this.acceleration = 0.0;
        this.advancingVelocity = 0.0;
        this.position = new Point2D.Double(0.0, 0.0);
        this.lastPosition = new Point2D.Double(0.0, 0.0);
        this.headingChange = 0.0;
        this.time = 0L;
        this.timeSinceLastScan = 0L;
        this.direction = 1;
        this.isAlive = true;
        this.bulletTravelTime = 0.0;
        this.forward = 1;
    }
}

