/*
 * Decompiled with CFR 0.152.
 */
package knackibot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import knackibot.Enemy;
import knackibot.GuessFactorTargeting;
import knackibot.Logger;
import knackibot.RandomMovement;
import knackibot.Strategy;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class KnackOnOne
extends AdvancedRobot {
    Enemy enemy;
    static Strategy strategy = new Strategy();
    Point2D.Double ownPos;
    Logger logger = new Logger();
    int bulletsFired = 0;
    int nrOfBulletsHitEnemy = 0;
    static int roundNr = 0;

    public void run() {
        this.setBodyColor(Color.pink);
        this.setGunColor(Color.black);
        this.setRadarColor(Color.pink);
        this.enemy = new Enemy();
        strategy.setMovementStrategy(new RandomMovement(this, this.enemy));
        strategy.setTargetStrategy(new GuessFactorTargeting());
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRight(Double.POSITIVE_INFINITY);
        while (true) {
            if (this.getRadarTurnRemainingRadians() == 0.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.ownPos = new Point2D.Double(this.getX(), this.getY());
        this.enemy.processOnScannedRobot(e);
        this.enemy.addPosLog(this);
        this.setTurnRadarRightRadians(this.applyWidthLock(e));
        strategy.move(this.enemy, this);
        strategy.shoot(this.enemy, this);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        ++this.bulletsFired;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.enemy.addShotHitMe();
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onBulletHit(BulletHitEvent event) {
        this.enemy.processOnBulletHit(event);
        ++this.nrOfBulletsHitEnemy;
        ++this.bulletsFired;
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        ++this.bulletsFired;
    }

    public void onRoundEnded(RoundEndedEvent event) {
        block20: {
            double myAccuracy = (double)this.nrOfBulletsHitEnemy / (double)this.bulletsFired;
            double enemyAccuracy = (double)this.enemy.getNrBulletsHitKnackiThisRound() / (double)this.enemy.getNrBulletsFiredThisRound();
            ++roundNr;
            System.out.println("#### Statisctics fot this round #####");
            System.out.println("My own Accuracy: " + myAccuracy);
            System.out.println("Number of Bullets fired: " + this.bulletsFired);
            System.out.println("Number of Bullets hit Enemy: " + this.nrOfBulletsHitEnemy);
            System.out.println("######################################");
            System.out.println("Enemy Accuracy: " + enemyAccuracy);
            System.out.println("#Enemy Bullets fired: " + this.enemy.getNrBulletsFiredThisRound());
            System.out.println("#Number of Bullets hit me: " + this.enemy.getNrBulletsHitKnackiThisRound());
            System.out.println("######################################");
            String writeContent = "";
            try {
                System.out.println("Try reading");
                try (BufferedReader reader = null;){
                    reader = new BufferedReader(new FileReader(this.getDataFile("statistics.txt")));
                    boolean iterate = true;
                    String delims = "[***]";
                    while (iterate) {
                        String readReturn = reader.readLine();
                        if (readReturn != null) {
                            String[] tokens = readReturn.split(delims);
                            if (tokens[0] != "###" && tokens[0] != "##") {
                                String cfr_ignored_0 = tokens[0];
                            }
                            writeContent = String.valueOf(writeContent) + readReturn;
                            writeContent = String.valueOf(writeContent) + "\n";
                            continue;
                        }
                        iterate = false;
                    }
                }
            }
            catch (IOException e) {
                System.out.println("IOException reading statistics.txt");
            }
            catch (NumberFormatException e) {
                System.out.println("NumberFormatException reading statistics.txt");
            }
            PrintStream w = null;
            try {
                try {
                    System.out.println("Trying to write");
                    String s = "statistics.txt";
                    w = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(s)));
                    w.print(writeContent);
                    w.println();
                    w.println("###***" + this.enemy.getName());
                    w.println("##***" + strategy.getTargetStrategyName());
                    w.println("#***->BulShot***" + this.bulletsFired);
                    w.println("#***->BulHit***" + this.nrOfBulletsHitEnemy);
                    w.println();
                    if (w.checkError()) {
                        this.out.println("I could not write the count!");
                    }
                }
                catch (IOException e) {
                    this.out.println("IOException trying to write: ");
                    e.printStackTrace(this.out);
                    if (w != null) {
                        w.close();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (w != null) {
                    w.close();
                }
                throw throwable;
            }
            if (w != null) {
                w.close();
            }
        }
        this.nrOfBulletsHitEnemy = 0;
        this.bulletsFired = 0;
        this.enemy.cleanupMemorySizePosLog(3000);
    }

    private double applyWidthLock(ScannedRobotEvent e) {
        double angleToEnemy = this.getHeadingRadians() + e.getBearingRadians();
        double radarTurn = Utils.normalRelativeAngle((double)(angleToEnemy - this.getRadarHeadingRadians()));
        double extraTurn = Math.min(Math.atan(36.0 / e.getDistance()), Rules.RADAR_TURN_RATE_RADIANS);
        radarTurn = radarTurn < 0.0 ? (radarTurn -= extraTurn) : (radarTurn += extraTurn);
        return radarTurn;
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.GREEN);
        try {
            int i = 0;
            while (i < this.logger.getPosPrediction().size() - 1) {
                g.drawLine((int)this.logger.getPosPrediction().get(i).getX(), (int)this.logger.getPosPrediction().get(i).getY(), (int)this.logger.getPosPrediction().get(i + 1).getX(), (int)this.logger.getPosPrediction().get(i + 1).getY());
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in printing PosPrediction");
        }
        System.out.println("Size PosPrediction: " + this.logger.getPosPrediction().size());
        System.out.println("Size debug_PosPrediction: " + this.logger.getDebug_PosPrediction().size());
        g.setColor(Color.RED);
        try {
            int i = 0;
            while (i < this.logger.getDebug_PosPrediction().size() - 1) {
                g.drawLine((int)this.logger.getDebug_PosPrediction().get(i).getX(), (int)this.logger.getDebug_PosPrediction().get(i).getY(), (int)this.logger.getDebug_PosPrediction().get(i + 1).getX(), (int)this.logger.getDebug_PosPrediction().get(i + 1).getY());
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in printin debug_PosPrediction");
        }
        g.setColor(Color.BLACK);
        double radius = 120.0;
        Ellipse2D.Double theCircle = new Ellipse2D.Double(this.getX() - radius, this.getY() - radius, 2.0 * radius, 2.0 * radius);
        g.draw(theCircle);
        g.setColor(Color.BLUE);
        if (this.enemy.getPosLogSize() > 0) {
            g.drawRect((int)this.enemy.getPosLogAt((int)(this.enemy.getPosLogSize() - 1)).x, (int)this.enemy.getPosLogAt((int)(this.enemy.getPosLogSize() - 1)).y, 5, 5);
        }
        g.setColor(Color.CYAN);
        int logPosPredSize = this.logger.getPosPrediction().size();
        if (logPosPredSize > 0) {
            int predLastIt = logPosPredSize - 1;
            g.drawRect((int)this.logger.getPosPrediction().get(predLastIt).getX(), (int)this.logger.getPosPrediction().get(predLastIt).getY(), 8, 8);
        }
    }
}

