/*
 * Decompiled with CFR 0.152.
 */
package inonit.system;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Logging {
    private static Logging singleton = new Logging();

    public static Logging get() {
        return singleton;
    }

    public boolean isSpecified() {
        return System.getProperty("java.util.logging.config.file") != null || System.getProperty("java.util.logging.config.class") != null;
    }

    public void initialize(Properties properties) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            properties.store(buffer, null);
            buffer.close();
            byte[] encoded = buffer.toByteArray();
            ByteArrayInputStream stream = new ByteArrayInputStream(encoded);
            LogManager.getLogManager().readConfiguration(stream);
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unreachable", e);
        }
    }

    public void log(Class<?> logging, Level level, String message, Throwable throwable) {
        Logger logger = Logger.getLogger(logging.getName());
        if (logger.isLoggable(level)) {
            logger.log(level, message, throwable);
        }
    }

    public void logStackTrace(Class<?> logging, Level level, String message) {
        Logger logger = Logger.getLogger(logging.getName());
        if (logger.isLoggable(level)) {
            logger.log(level, message, new StackTraceThrowable());
        }
    }

    public static class OutputStream
    extends java.io.OutputStream {
        private static final Logger LOG = Logger.getLogger(OutputStream.class.getName());
        private java.io.OutputStream delegate;
        private String name;

        public OutputStream(java.io.OutputStream delegate, String name) {
            this.delegate = delegate;
            this.name = name;
        }

        private void log(Level level, String mask, Object ... substitutions) {
            LOG.log(level, this.name + ": " + mask, substitutions);
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
            this.log(Level.FINEST, "Wrote byte %d.", b);
        }

        @Override
        public void close() throws IOException {
            this.log(Level.FINEST, "Closing...", new Object[0]);
            this.delegate.close();
            this.log(Level.FINE, "Closed.", new Object[0]);
        }

        @Override
        public void flush() throws IOException {
            this.log(Level.FINEST, "Flushing ...", new Object[0]);
            this.delegate.flush();
            this.log(Level.FINEST, "Flushed.", new Object[0]);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.log(Level.FINEST, "Writing %d bytes starting with %d in array of length %d.", len, off, b.length);
            for (int i = 0; i < len; ++i) {
                this.log(Level.FINEST, "Byte %d/%d: %d", i, len, b[off + i]);
            }
            this.delegate.write(b, off, len);
            this.log(Level.FINEST, "Wrote %d bytes from buffer.", len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.log(Level.FINEST, "Writing %d bytes", b.length);
            for (int i = 0; i < b.length; ++i) {
                this.log(Level.FINEST, "Byte %d/%d: %d", i, b.length, b[i]);
            }
            this.delegate.write(b);
            this.log(Level.FINEST, "Wrote %d bytes", b.length);
        }
    }

    public static class InputStream
    extends java.io.InputStream {
        private static final Logger LOG = Logger.getLogger(Logging.class.getName());
        private java.io.InputStream in;
        private boolean wasSystemIn = false;

        private static void log(Level level, String mask, Object ... substitutions) {
            LOG.log(level, mask, substitutions);
        }

        public InputStream(java.io.InputStream in) {
            this.in = new BufferedInputStream(in);
            this.wasSystemIn = in == System.in;
        }

        public String toString() {
            if (this.wasSystemIn) {
                return super.toString() + " delegate=System.in";
            }
            return super.toString() + " delegate=" + this.in;
        }

        @Override
        public int read() throws IOException {
            try {
                int rv = this.in.read();
                InputStream.log(Level.FINEST, "Read byte: %d", rv);
                Logging.get().logStackTrace(InputStream.class, Level.FINEST, "read()");
                return rv;
            }
            catch (IOException e) {
                Logging.get().log(InputStream.class, Level.SEVERE, "Error in read()", e);
                throw e;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            try {
                int rv = this.in.read(b);
                InputStream.log(Level.FINEST, "Read %d bytes into array.", rv);
                Logging.get().logStackTrace(InputStream.class, Level.FINEST, "read(byte[])");
                for (int i = 0; i < rv; ++i) {
                    InputStream.log(Level.FINEST, "Read byte: %d", b[i]);
                }
                return rv;
            }
            catch (IOException e) {
                Logging.get().log(InputStream.class, Level.SEVERE, "Error in read(byte[])", e);
                throw e;
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int rv = this.in.read(b, off, len);
                InputStream.log(Level.FINEST, "Read %d bytes into array.", rv);
                Logging.get().logStackTrace(InputStream.class, Level.FINEST, "read(byte[],int,int)");
                for (int i = 0; i < rv; ++i) {
                    InputStream.log(Level.FINEST, "Read byte: %d", b[i + off]);
                }
                return rv;
            }
            catch (IOException e) {
                Logging.get().log(InputStream.class, Level.SEVERE, "Error in read(byte[],int,int)", e);
                throw e;
            }
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            InputStream.log(Level.FINEST, "Closing %s with delegate %s", this, this.in);
            if (!this.wasSystemIn) {
                this.in.close();
            }
            InputStream.log(Level.FINEST, "Closed %s with delegate %s", this, this.in);
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.in.reset();
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }
    }

    public static abstract class StackTracer {
        public static final StackTracer DEFAULT = new StackTracer(){

            @Override
            public Throwable create(String message) {
                return new Throwable(message);
            }
        };

        public abstract Throwable create(String var1);
    }

    private static class StackTraceThrowable
    extends RuntimeException {
        StackTraceThrowable() {
            super("Stack trace");
        }
    }
}

