/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.movement;

import gf.Centaur.Data;
import gf.Centaur.abstracts.Controll;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.util.LinkedHashMap;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.util.Utils;

public abstract class Movement
extends Controll {
    protected final short AHEAD = 1;
    protected final short BACK = (short)-1;
    protected AdvancedRobot robot;
    protected Data data;
    protected boolean isTurning = false;
    protected boolean isMoving = false;
    protected short direction = 1;
    protected LinkedHashMap<Shape, Paint> shapes = new LinkedHashMap();
    protected final Condition MyTurnCompleteCondition = new Condition("MyTurnCompleteCondition"){

        public boolean test() {
            if (Movement.this.isTurning && Movement.this.robot.getTurnRemaining() == 0.0) {
                Movement.this.isTurning = false;
                return true;
            }
            return false;
        }
    };
    protected final Condition MyMoveCompleteCondition = new Condition("MyMoveCompleteCondition"){

        public boolean test() {
            if (Movement.this.isMoving && Movement.this.robot.getDistanceRemaining() == 0.0) {
                Movement.this.isMoving = false;
                return true;
            }
            return false;
        }
    };

    public Movement(AdvancedRobot robot, Data data) {
        this.robot = robot;
        this.data = data;
        robot.addCustomEvent(this.MyMoveCompleteCondition);
        robot.addCustomEvent(this.MyTurnCompleteCondition);
    }

    @Override
    public void draw(Graphics2D g2d) {
        for (Map.Entry<Shape, Paint> entry : this.shapes.entrySet()) {
            g2d.setPaint(entry.getValue());
            g2d.draw(entry.getKey());
        }
    }

    protected void turn(double angle) {
        double headingAhead = Utils.normalRelativeAngle((double)this.robot.getHeadingRadians());
        double headingBack = Utils.normalRelativeAngle((double)(headingAhead - Math.PI));
        double turnAhead = Utils.normalRelativeAngle((double)(angle - headingAhead));
        double turnBack = Utils.normalRelativeAngle((double)(angle - headingBack));
        if (Math.abs(turnAhead) <= Math.abs(turnBack)) {
            this.robot.setTurnRightRadians(turnAhead);
            this.direction = 1;
        } else {
            this.robot.setTurnRightRadians(turnBack);
            this.direction = (short)-1;
        }
        this.isTurning = true;
    }
}

