/*
 * Decompiled with CFR 0.152.
 */
package ry;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import ry.Enemy;
import ry.Gun;
import utils.Utils;

class PredictiveGun
extends Gun {
    PredictiveGun() {
    }

    @Override
    public String getName() {
        return "PT Gun";
    }

    @Override
    public Color getColor() {
        return Color.BLUE;
    }

    @Override
    public double getFiringAngle(AdvancedRobot robot, Enemy enemy, double bulletPower) {
        Point2D.Double myLoc = new Point2D.Double(robot.getX(), robot.getY());
        double bulletSpeed = Utils.bulletVelocity(bulletPower);
        Point2D.Double futPos = new Point2D.Double(enemy.x, enemy.y);
        int i = 0;
        while (i < 32) {
            long time = robot.getTime() + (long)(myLoc.distance(futPos) / bulletSpeed);
            futPos = this.getFuturePos(time, enemy);
            ++i;
        }
        futPos.x = Utils.limit(18.0, robot.getBattleFieldWidth() - 18.0, futPos.x);
        futPos.y = Utils.limit(18.0, robot.getBattleFieldHeight() - 18.0, futPos.y);
        double absDeg = Utils.absoluteBearing(myLoc, futPos);
        return absDeg;
    }

    public Point2D.Double getFuturePos(long when, Enemy enemy) {
        double futX = enemy.x;
        double futY = enemy.y;
        double timeChange = when - enemy.lastUpdated;
        double change = enemy.heading - enemy.pHeading;
        if (Math.abs(change) > 1.0E-5) {
            double radius = enemy.velocity / change;
            double totalHeadingChange = timeChange * change;
            futX = enemy.x + Math.cos(enemy.heading) * radius - Math.cos(enemy.heading + totalHeadingChange) * radius;
            futY = enemy.y + Math.sin(enemy.heading + totalHeadingChange) * radius - Math.sin(enemy.heading) * radius;
        } else {
            futX = enemy.x + Math.sin(enemy.heading) * enemy.velocity * timeChange;
            futY = enemy.y + Math.cos(enemy.heading) * enemy.velocity * timeChange;
        }
        return new Point2D.Double(futX, futY);
    }
}

