/*
 * Decompiled with CFR 0.152.
 */
package demetrix.info;

import demetrix.misc.Physics;

public class HitStats {
    private static final int ADEQUACY_SHOOTS_LOW = 10;
    private static final int ADEQUACY_SHOOTS_HIGH = 25;
    private static final double GOODSTATS = 0.11;
    private static final double BADSTATS = 0.44;
    private static double[] damage;
    private static double[] power;
    private static int[] shoots;
    private static int segments;
    public final double PERFECTSTATS = 0.055;

    public void onHit(int segment, double bulPower) {
        if (segment < segments) {
            double dmg = Physics.getDamageOnBulletHit(bulPower);
            int n = segment;
            damage[n] = damage[n] + dmg;
            int n2 = segment;
            power[n2] = power[n2] + dmg;
            int n3 = segment;
            shoots[n3] = shoots[n3] + 1;
        }
    }

    public void onShoot(int segment, double bulPower) {
        if (segment < segments && bulPower > 0.0) {
            int n = segment;
            power[n] = power[n] + Physics.getDamageOnBulletHit(bulPower);
            int n2 = segment;
            shoots[n2] = shoots[n2] + 1;
        }
    }

    public double getRatio(int segment) {
        if (segment >= segments) {
            return -1.0;
        }
        if (power[segment] == 0.0) {
            return -2.0;
        }
        return damage[segment] / power[segment];
    }

    public int getReasonableSegment() {
        int minIndex = 0;
        int notAdequacyIndex = -1;
        int i = 0;
        while (i < segments) {
            if (shoots[i] < 10 || !(this.getRatio(i) >= 0.44)) {
                if (shoots[i] < 25) {
                    if (notAdequacyIndex < 0) {
                        notAdequacyIndex = i;
                    }
                } else {
                    if (this.getRatio(i) < 0.11) {
                        return i;
                    }
                    if (this.getRatio(i) < this.getRatio(minIndex)) {
                        minIndex = i;
                    }
                }
            }
            ++i;
        }
        if (notAdequacyIndex < 0) {
            return minIndex;
        }
        return notAdequacyIndex;
    }

    public HitStats(int segmentsNum) {
        segments = segmentsNum;
        damage = new double[segments];
        power = new double[segments];
        shoots = new int[segments];
    }
}

