/*
 * Decompiled with CFR 0.152.
 */
package demetrix.targeting;

import demetrix.info.EnemyInfo;
import demetrix.info.SelfInfo;
import demetrix.misc.Const;
import demetrix.misc.Physics;
import demetrix.targeting.PMTrecord;
import demetrix.targeting.Shoot;
import java.util.Vector;

public class PMT {
    private static final int DATA_LENGTH = 600;
    private static final int MATCHING_LENGTH = 8;
    private static final int PMT_ENABLE_THRESHOLD = 100;
    private static Vector data = new Vector();
    private int MatchingIndex;

    public void setData(double velocity, double headingChange) {
        data.addElement(new PMTrecord(velocity, headingChange));
        if (data.size() > 600) {
            data.removeElementAt(0);
        }
    }

    public PMTrecord getData(int elementIndex) {
        if (elementIndex >= data.size()) {
            return null;
        }
        return (PMTrecord)data.elementAt(elementIndex);
    }

    public boolean getPatternMatching() {
        if (data.size() < 100) {
            return false;
        }
        double minDiff = Double.POSITIVE_INFINITY;
        int startKeyPattern = data.size() - 8;
        int i = 0;
        while (i <= startKeyPattern - 44) {
            double diff = 0.0;
            int j = 0;
            while (j < 8) {
                PMTrecord keyPattern = this.getData(startKeyPattern + j);
                PMTrecord samplePattern = this.getData(i + j);
                diff += samplePattern.getDifference(keyPattern);
                ++j;
            }
            if (diff < minDiff) {
                minDiff = diff;
                this.MatchingIndex = i + 8;
            }
            ++i;
        }
        return true;
    }

    public int getMatchingIndex() {
        return this.MatchingIndex;
    }

    public Shoot execute(SelfInfo self, EnemyInfo enemy, double bulletPower) {
        double dY;
        double dX;
        double S_hit;
        int index = this.getMatchingIndex();
        double Ven = this.getData(index).getVelocity();
        double Vbl = Physics.getBulletVelocity(bulletPower);
        double Head = enemy.getHeading() + this.getData(index).getHeadingChange();
        double predictX = enemy.getNextPosition().getX();
        double predictY = enemy.getNextPosition().getY();
        double Sbl = 0.0;
        int t = 0;
        do {
            ++t;
            dX = (predictX += Ven * Math.sin(Head)) - self.getNextPosition().getX();
            dY = (predictY += Ven * Math.cos(Head)) - self.getNextPosition().getY();
            S_hit = self.getNextPosition().distance(predictX, predictY);
            if (!Const.MOVING_FIELD.contains(predictX, predictY)) {
                bulletPower = Physics.getBulletPower(S_hit / (double)t);
                break;
            }
            Sbl += Vbl;
            if (this.getData(index + t) == null) {
                return new Shoot(self.getGunHeading(), bulletPower);
            }
            Ven = this.getData(index + t).getVelocity();
            Head += this.getData(index + t).getHeadingChange();
        } while (Sbl < S_hit);
        return new Shoot(Math.atan2(dX, dY), bulletPower);
    }
}

