/*
 * Decompiled with CFR 0.152.
 */
package rsalesc.roborio;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;
import rsalesc.roborio.utils.BackAsFrontRobot;
import rsalesc.roborio.utils.Physics;
import rsalesc.roborio.utils.R;
import rsalesc.roborio.utils.geo.AxisRectangle;
import rsalesc.roborio.utils.geo.G;
import rsalesc.roborio.utils.geo.Point;
import rsalesc.roborio.utils.structures.KdTree;
import rsalesc.roborio.utils.structures.WeightedManhattanKdTree;

public class RoborioPorradeiro
extends BackAsFrontRobot {
    private static HashMap<String, Scan> scans = new HashMap();
    private static HashMap<String, KdTree<ScanLog>> trees = new HashMap();
    private static boolean isTC = false;
    private static boolean isMC = false;
    private Point gotoPoint;
    private int MAX_LENGTH = 30;
    private ArrayList<CandidateAngle> _lastAngles;
    private ArrayList<CandidateAngle> _lastShootAngles;
    private double lastSeenEnergy;
    private CandidateAngle _lastBestAngle;
    private CandidateAngle _lastBestShootAngle;
    private double _lastSelectedPower;
    private boolean lostScan = true;
    private boolean hasEnded = false;
    private long _lastFireTime = -1000L;
    private static long bulletsFired = 0L;

    private Scan getScan(ScannedRobotEvent scannedRobotEvent, HashMap<String, Scan> hashMap) {
        if (!hashMap.containsKey(scannedRobotEvent.getName())) {
            hashMap.put(scannedRobotEvent.getName(), new Scan());
        }
        return hashMap.get(scannedRobotEvent.getName());
    }

    public void run() {
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.lastSeenEnergy = 0.0;
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        this.execute();
        while (true) {
            if (!this.hasEnded && !this.lostScan && this.getEnergy() > 1.0E-9) {
                if (this.getGunHeat() == 0.0 && this.getGunTurnRemaining() == 0.0 && this._lastSelectedPower > 0.0) {
                    this._lastShootAngles = this._lastAngles;
                    this._lastBestShootAngle = this._lastBestAngle;
                    this._lastFireTime = this.getTime();
                    ++bulletsFired;
                    this.setFire(this._lastSelectedPower);
                }
                if (!isMC) {
                    this.aim();
                }
                if (!isTC) {
                    this.move();
                }
                if (this.isMelee()) {
                    int n = 0;
                    Scan scan = null;
                    for (Map.Entry<String, Scan> entry : scans.entrySet()) {
                        Scan scan2 = entry.getValue();
                        if (scan2.dead) continue;
                        ++n;
                        if (scan != null && scan.getLatest().time <= scan2.getLatest().time) continue;
                        scan = scan2;
                    }
                    if (scan != null && n >= this.getOthers()) {
                        double d = Physics.absoluteBearing(this.getPoint(), scan.getLatest().position);
                        double d2 = Utils.normalRelativeAngle((double)(d - this.getRadarHeadingRadians()));
                        if (d2 >= 0.0) {
                            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
                        } else {
                            this.setTurnRadarRightRadians(Double.NEGATIVE_INFINITY);
                        }
                    } else {
                        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
                    }
                } else if (this.lostScan) {
                    this.setTurnRadarLeftRadians(Double.POSITIVE_INFINITY);
                }
                if (this.getRadarTurnRemaining() == 0.0) {
                    this.setTurnRadarRight(1.0);
                }
            }
            this.lostScan = true;
            this.execute();
        }
    }

    public void onWin(WinEvent winEvent) {
        this.hasEnded = true;
        this.setTurnRight(Double.POSITIVE_INFINITY);
    }

    public KdTree<ScanLog> getTree(String string) {
        if (!trees.containsKey(string)) {
            trees.put(string, new WeightedManhattanKdTree(ScanLog.WEIGHTS, (Integer)10000));
        }
        return trees.get(string);
    }

    private double selectPower() {
        if (isTC) {
            return 3.0;
        }
        if (isMC) {
            return 0.0;
        }
        if (!this.isMelee() && this.lastSeenEnergy == 0.0) {
            return 0.0;
        }
        if (!this.isMelee() && this.getEnergy() > 2.0 * this.lastSeenEnergy) {
            return Math.min(1.7, this.lastSeenEnergy / 4.0);
        }
        if (!this.isMelee() && this.getEnergy() > 2.0 * this.lastSeenEnergy) {
            return 1.5;
        }
        if (this.getEnergy() > 30.0 && !this.isMelee()) {
            return 2.1;
        }
        if (this.getEnergy() > 20.0) {
            return 1.7;
        }
        if (this.getEnergy() > 10.0) {
            return 1.3;
        }
        if (this.getEnergy() > 0.5) {
            return this.getEnergy() / 10.0;
        }
        return 0.0;
    }

    private void move() {
        if (this.gotoPoint == null || this.gotoPoint.distance(this.getPoint()) < 20.0 || this.tooClose()) {
            Point point = this.getPoint();
            double d = this.test(point);
            for (int i = 0; i < 250; ++i) {
                double d2;
                double d3 = Math.random() * R.PI * 2.0;
                double d4 = Math.random() * 120.0;
                Point point2 = this.getPoint().project(d3, d4);
                if (!this.getBattleField().shrink(30.0, 30.0).contains(point2) || !((d2 = this.test(point2)) < d)) continue;
                d = d2;
                point = point2;
            }
            this.gotoPoint = point;
        }
        this.moveWithBackAsFront(this.gotoPoint);
    }

    private boolean tooClose() {
        for (Map.Entry<String, Scan> entry : scans.entrySet()) {
            Scan scan = entry.getValue();
            ScanLog scanLog = scan.getLatest();
            if (!(scanLog.position.distance(this.getPoint()) < 100.0)) continue;
            return true;
        }
        return false;
    }

    private double test(Point point) {
        double d = 3.0 / point.distance(this.getPoint());
        AxisRectangle axisRectangle = this.getBattleField();
        d += 1.0 / point.distance(axisRectangle.getCenter());
        for (Point object : axisRectangle.getCorners()) {
            d += 2.0 / point.distance(object);
        }
        for (Map.Entry entry : scans.entrySet()) {
            Scan scan = (Scan)entry.getValue();
            ScanLog scanLog = scan.getLatest();
            if (scan.dead) continue;
            double d2 = Utils.normalRelativeAngle((double)(Physics.absoluteBearing(this.getPoint(), point) - Physics.absoluteBearing(this.getPoint(), scanLog.position)));
            double d3 = Math.cos(Math.min(d2, R.PI - d2));
            d += R.constrain(2.5, scanLog.energy / this.getEnergy() * 10.0 * d3, 20.0) / scanLog.position.distance(this.getPoint());
        }
        return d;
    }

    private double getMoveHeading(ScanLog scanLog) {
        if (Math.signum(scanLog.velocity) < 0.0) {
            return Utils.normalAbsoluteAngle((double)(scanLog.heading + R.PI));
        }
        return scanLog.heading;
    }

    private void aim() {
        double d;
        double d2;
        Object object;
        Object object2;
        double d3;
        this._lastSelectedPower = d3 = this.selectPower();
        d3 = Math.max(0.1, d3);
        double d4 = Rules.getBulletSpeed((double)d3);
        ArrayList<CandidateAngle> arrayList = new ArrayList<CandidateAngle>();
        for (Map.Entry<String, Scan> entry : scans.entrySet()) {
            Object object3;
            Object object4;
            object2 = new ArrayList();
            object = entry.getValue();
            if (((Scan)object).dead) continue;
            ScanLog iterator = ((Scan)object).getLatest();
            long l = this.getTime() - iterator.time;
            KdTree<ScanLog> kdTree = this.getTree(entry.getKey());
            int n = Math.max(kdTree.size(), 0);
            if (n == 0) continue;
            int n2 = Math.min(12, (int)Math.sqrt(n));
            List list = kdTree.kNN(iterator.getLocation(), n2);
            for (KdTree.Entry entry2 : list) {
                object3 = object4 = (ScanLog)entry2.payload;
                long l2 = 0L;
                boolean bl = true;
                double d5 = Utils.normalRelativeAngle((double)(this.getMoveHeading((ScanLog)object4) - this.getMoveHeading(iterator)));
                Point point = ((ScanLog)object4).position.subtract(iterator.position);
                Point point2 = this.getPoint().add(point).rotate(d5, ((ScanLog)object4).position);
                Object object5 = object4;
                int n3 = 0;
                while (++n3 <= 100 && object3 != null && ((ScanLog)object3).position.distance(point2) > (double)(l2 - l) * d4) {
                    ScanLog scanLog = ((ScanLog)object3).next;
                    if (scanLog != null) {
                        long l3 = scanLog.time - ((ScanLog)object3).time;
                        if (l3 <= 0L || l3 > 15L) {
                            bl = false;
                            break;
                        }
                        l2 += l3;
                    }
                    object5 = object3;
                    object3 = scanLog;
                }
                if (n3 > 100 || object3 == null || !bl) continue;
                long l4 = ((ScanLog)object3).time - ((ScanLog)object5).time;
                Point point3 = ((ScanLog)object3).position;
                if (l4 > 0L) {
                    long l5 = 0L;
                    long l6 = l4;
                    while (l5 < l6) {
                        long l7 = (l5 + l6) / 2L;
                        double d6 = 1.0 * (double)l7 / (double)l4;
                        Point point4 = ((ScanLog)object5).position.multiply(1.0 - d6).add(((ScanLog)object3).position.multiply(d6));
                        if ((double)(((ScanLog)object5).time + l7 - ((ScanLog)object4).time - l) * d4 >= point2.distance(point4)) {
                            l6 = l7;
                            continue;
                        }
                        l5 = l7 + 1L;
                    }
                    double d7 = 1.0 * (double)l5 / (double)l4;
                    point3 = ((ScanLog)object5).position.multiply(1.0 - d7).add(((ScanLog)object3).position.multiply(d7));
                }
                Point point5 = point3.rotate(-d5, ((ScanLog)object4).position).subtract(point);
                if (!this.getBattleField().contains(point5)) continue;
                ((ArrayList)object2).add(new CandidateAngle(Physics.absoluteBearing(this.getPoint(), point5), entry2.distance, point5));
            }
            d2 = 0.0;
            object4 = ((ArrayList)object2).iterator();
            while (object4.hasNext()) {
                object3 = (CandidateAngle)object4.next();
                d2 += ((CandidateAngle)object3).weight;
            }
            d = 1.0 * (double)((ArrayList)object2).size() / d2;
            Iterator iterator2 = ((ArrayList)object2).iterator();
            while (iterator2.hasNext()) {
                CandidateAngle candidateAngle = (CandidateAngle)iterator2.next();
                candidateAngle.weight *= d;
                arrayList.add(candidateAngle);
            }
        }
        double d8 = Double.NEGATIVE_INFINITY;
        object2 = null;
        for (CandidateAngle candidateAngle : arrayList) {
            double d9 = 0.0;
            for (CandidateAngle candidateAngle2 : arrayList) {
                double d10 = candidateAngle2.point.distance(this.getPoint());
                d2 = candidateAngle2.angle;
                d = Utils.normalRelativeAngle((double)(candidateAngle.angle - d2));
                double d11 = d / (Physics.hitAngle(d10) * 0.8);
                d9 += R.exp(-0.5 * d11 * d11) * candidateAngle2.weight;
            }
            if (!(d9 > d8)) continue;
            d8 = d9;
            object2 = candidateAngle;
        }
        if (object2 == null) {
            this._lastAngles = null;
            object = null;
            for (Map.Entry<String, Scan> entry : scans.entrySet()) {
                Scan scan = entry.getValue();
                double d12 = Utils.normalRelativeAngle((double)(Physics.absoluteBearing(this.getPoint(), scan.getLatest().position) - this.getGunHeadingRadians()));
                if (object != null && !(Math.toDegrees(Math.abs(d12)) < 45.0) && !(((Scan)object).getLatest().position.distance(this.getPoint()) > scan.getLatest().position.distance(this.getPoint()))) continue;
                object = scan;
            }
            if (object != null) {
                double d13 = Utils.normalRelativeAngle((double)(Physics.absoluteBearing(this.getPoint(), ((Scan)object).getLatest().position) - this.getGunHeadingRadians()));
                if (!this.isMelee()) {
                    this.setTurnGunRightRadians(d13);
                } else {
                    this.setTurnGunRightRadians(d13);
                }
            }
        } else {
            this._lastAngles = arrayList;
            this._lastBestAngle = object2;
            double d14 = Utils.normalRelativeAngle((double)(((CandidateAngle)object2).angle - this.getGunHeadingRadians()));
            this.setTurnGunRightRadians(d14);
        }
    }

    public boolean isMelee() {
        return this.getOthers() > 1;
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.lostScan = false;
        this.lastSeenEnergy = scannedRobotEvent.getEnergy();
        Scan scan = this.getScan(scannedRobotEvent, scans);
        this.track(scannedRobotEvent, scan);
    }

    public void track(ScannedRobotEvent scannedRobotEvent, Scan scan) {
        scan.dead = false;
        ScanLog scanLog = scan.log.size() > 0 ? scan.getLatest() : null;
        double d = Utils.normalAbsoluteAngle((double)(this.getHeadingRadians() + scannedRobotEvent.getBearingRadians()));
        Point point = this.getPoint().project(d, scannedRobotEvent.getDistance());
        ScanLog scanLog2 = new ScanLog();
        scanLog2.index = scan.log.size();
        scanLog2.time = this.getTime();
        scanLog2.energy = scannedRobotEvent.getEnergy();
        scanLog2.position = point;
        scanLog2.heading = scannedRobotEvent.getHeadingRadians();
        scanLog2.velocity = scannedRobotEvent.getVelocity();
        scanLog2.closestDistance = 0.0;
        scanLog2.closestLateralVelocity = 0.0;
        scanLog2.gunHeat = this.getTime() - this._lastFireTime <= 5L ? 1.0 : 0.0;
        scanLog2.bulletsFired = bulletsFired;
        Point point2 = this.getClosest(scannedRobotEvent.getName(), point);
        int n = scanLog2.others = point2 != null ? 1 : 0;
        if (point2 != null) {
            scanLog2.closestDistance = point.distance(point2);
            double d2 = Physics.absoluteBearing(point, point2);
            scanLog2.closestLateralVelocity = Physics.getLateralVelocityFromStationary(d2, scanLog2.velocity, scanLog2.heading);
        }
        scanLog2.timeAccel = 0L;
        scanLog2.timeDecel = 0L;
        scanLog2.timeRevert = 0L;
        scanLog2.revertLast20 = 0L;
        scanLog2.accel = 0.0;
        scanLog2.runTime = 30L;
        if (scanLog != null) {
            if (Math.abs(scanLog.velocity) > Math.abs(scanLog2.velocity)) {
                scanLog2.accel = -1.0;
            } else if (Math.abs(scanLog.velocity) < Math.abs(scanLog2.velocity)) {
                scanLog2.accel = 1.0;
            }
            scanLog2.runTime = scanLog.velocity != scanLog2.velocity ? 0L : 30L;
        }
        scanLog2.timeAccel = scanLog2.accel > 0.0 ? 0L : 1L;
        scanLog2.timeDecel = scanLog2.accel < 0.0 ? 0L : 1L;
        for (int i = 1; i < Math.min(30, scan.log.size() - 1); ++i) {
            ScanLog scanLog3 = scan.log.get(scan.log.size() - i);
            ScanLog scanLog4 = scan.log.get(scan.log.size() - i - 1);
            if (scanLog2.timeAccel == (long)i && Math.abs(scanLog4.velocity) < Math.abs(scanLog3.velocity)) {
                ++scanLog2.timeAccel;
            }
            if (scanLog2.timeDecel == (long)i && Math.abs(scanLog4.velocity) > Math.abs(scanLog3.velocity)) {
                ++scanLog2.timeDecel;
            }
            if (scanLog2.runTime != 30L || scanLog4.velocity == scanLog3.velocity) continue;
            scanLog2.runTime = i;
        }
        scanLog2.prev = scan.getLatest();
        scanLog2.next = null;
        if (scan.log.size() > 0) {
            scan.getLatest().next = scanLog2;
        }
        scan.log.add(scanLog2);
        if (scan.log.size() > 10) {
            scan.log.get((int)0).prev = null;
            scan.log.pop();
        }
        this.getTree(scannedRobotEvent.getName()).add(scanLog2.getLocation(), scanLog2);
        if (!this.isMelee()) {
            double d3 = Utils.normalRelativeAngle((double)(d - this.getRadarHeadingRadians()));
            this.setTurnRadarRightRadians(2.0 * d3);
        }
    }

    public ScanLog getClosestEnemy(String string, Point point) {
        ScanLog scanLog = null;
        double d = Double.POSITIVE_INFINITY;
        for (Map.Entry<String, Scan> entry : scans.entrySet()) {
            double d2;
            Scan scan;
            ScanLog scanLog2;
            if (entry.getKey().equals(string) || entry.getValue().dead || (scanLog2 = (scan = entry.getValue()).getLatest()) == null || !((d2 = point.distance(scanLog2.position)) < d)) continue;
            d = d2;
            scanLog = scanLog2;
        }
        return scanLog;
    }

    public Point getClosest(String string, Point point) {
        ScanLog scanLog = this.getClosestEnemy(string, point);
        if (scanLog == null || this.getPoint().distance(point) < scanLog.position.distance(point)) {
            return this.getPoint();
        }
        return scanLog.position;
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        if (scans.containsKey(robotDeathEvent.getName())) {
            RoborioPorradeiro.scans.get((Object)robotDeathEvent.getName()).dead = true;
        }
    }

    public void onPaint(Graphics2D graphics2D) {
        G g = new G(graphics2D);
        if (this._lastShootAngles != null) {
            double d = 1.0E-7;
            for (CandidateAngle candidateAngle : this._lastShootAngles) {
                d = Math.max(d, candidateAngle.weight);
            }
            for (CandidateAngle candidateAngle : this._lastShootAngles) {
                if (candidateAngle == this._lastBestShootAngle) {
                    g.drawPoint(candidateAngle.point, 36.0, Color.GREEN);
                    continue;
                }
                g.drawPoint(candidateAngle.point, 36.0, G.getDangerColor(candidateAngle.weight / d));
            }
        }
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
        System.out.println("Skipped turn " + skippedTurnEvent.getSkippedTurn());
    }

    private static class CircularArray<T> {
        private Object[] buffer = new Object[24];
        private int L = 0;
        private int R = 0;

        public T get(int n) {
            return (T)this.buffer[(this.L + n) % 24];
        }

        public void add(T t) {
            this.buffer[this.R++] = t;
            if (this.R >= 24) {
                this.R = 0;
            }
        }

        public void pop() {
            this.buffer[this.L] = null;
            ++this.L;
            if (this.L >= 24) {
                this.L = 0;
            }
        }

        public int size() {
            return this.R >= this.L ? this.R - this.L : this.R + 24 - this.L;
        }
    }

    private class CandidateAngle {
        double angle;
        double weight;
        Point point;

        public CandidateAngle(double d, double d2, Point point) {
            this.angle = d;
            this.weight = d2;
            this.point = point;
        }
    }

    private static class ScanLog {
        ScanLog prev = null;
        ScanLog next = null;
        int index;
        Point position;
        long time;
        double heading;
        double energy;
        double velocity;
        double gunHeat;
        double accel;
        long timeAccel;
        long timeDecel;
        long timeRevert;
        long revertLast20;
        long runTime;
        int others;
        long bulletsFired;
        double closestDistance;
        double closestLateralVelocity;
        private static final double[] WEIGHTS = new double[]{2.0, 3.0, 6.0, 4.0, 2.0, 1.0, 1.0, 4.0};

        public double[] getLocation() {
            return new double[]{(double)this.runTime / 30.0, (double)this.timeDecel / 50.0, Math.min(this.others, 1), Math.min(this.closestDistance / 400.0, 1.0), this.closestLateralVelocity / 8.0, (this.accel + 1.0) * 0.5, this.gunHeat > 0.1 ? 0.0 : 1.0, Math.abs(this.velocity) / 8.0};
        }
    }

    private static class Scan {
        CircularArray<ScanLog> log = new CircularArray();
        boolean dead = true;

        public ScanLog getLatest() {
            return this.log.size() > 0 ? this.log.get(this.log.size() - 1) : null;
        }
    }
}

