/*
 * Decompiled with CFR 0.152.
 */
package adt;

import adt.Context;
import adt.PredictiveRobotTracker;
import adt.RobotTracker;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.GunTurnCompleteCondition;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MoveCompleteCondition;
import robocode.RadarTurnCompleteCondition;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TurnCompleteCondition;
import robocode.WinEvent;

public class Ar2
extends AdvancedRobot {
    boolean aiming = false;
    String lastTarget = null;
    long lastSighting = 0L;
    double lastRange = 100000.0;
    Context my;
    RobotTracker tracker;
    static int bumpCount = 0;
    static int skipCount = 0;
    boolean leftScan = true;
    double scanDrift = 0.0;
    double scanSize = 22.5;

    public void run() {
        this.addCustomEvent((Condition)new MoveCompleteCondition((AdvancedRobot)this));
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        this.addCustomEvent((Condition)new GunTurnCompleteCondition((AdvancedRobot)this));
        this.addCustomEvent((Condition)new TurnCompleteCondition((AdvancedRobot)this));
        this.setColors(new Color(100, 128, 96), Color.green, new Color(200, 210, 215));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarLeft(360.0);
        this.my = new Context();
        this.tracker = new PredictiveRobotTracker((Robot)this, this.my);
        while (true) {
            this.my.x = this.getX();
            this.my.y = this.getY();
            this.my.vx = this.getVelocity() * Math.sin(this.getHeadingRadians());
            this.my.vy = this.getVelocity() * Math.cos(this.getHeadingRadians());
            this.my.gh = this.getGunHeading();
            if (!this.aiming) {
                this.aiming = true;
                this.aimAt(this.tracker.getAimPoint(this.lastTarget));
            }
            this.execute();
        }
    }

    public void onEndOfRound() {
        this.out.println(bumpCount + " wall bumps.");
        this.out.println(skipCount + " skipped turns.");
    }

    public void onDeath(DeathEvent event) {
        this.onEndOfRound();
    }

    public void onWin(WinEvent event) {
        this.setMaxVelocity(3.0);
        this.driveAt(new Point2D.Double(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0), 0.0);
        this.onEndOfRound();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.tracker.updateBot(e);
        if (this.lastTarget == null || e.getName().equals(this.lastTarget)) {
            this.leftScan = !this.leftScan;
            this.scanDrift = this.scanSize / 2.0 - this.getRadarTurnRemaining() * 1.1;
        }
        if (this.lastTarget != null && !e.getName().equals(this.lastTarget)) {
            if (this.lastSighting < this.getTime() - 30L) {
                this.lastTarget = e.getName();
                this.lastRange = e.getDistance();
            } else if (e.getDistance() < this.lastRange / 10.0 && Math.random() > 0.3) {
                this.lastTarget = e.getName();
                this.lastRange = e.getDistance();
            }
        } else {
            this.lastTarget = e.getName();
            this.lastRange = e.getDistance();
        }
        if (e.getName().equals(this.lastTarget)) {
            this.lastSighting = this.getTime();
        }
    }

    public void aimAt(Point2D.Double aimPoint) {
        if (aimPoint != null) {
            double dy;
            double dx = aimPoint.getX() - this.getX();
            double t = Math.atan2(dx, dy = aimPoint.getY() - this.getY());
            double gunTurn = t - this.getGunHeadingRadians();
            if (Math.abs(gunTurn) > Math.PI) {
                gunTurn = (double)(gunTurn < 0.0 ? 1 : -1) * (Math.PI * 2 - Math.abs(gunTurn));
            }
            if (Math.abs(gunTurn) > 1.5707963267948966) {
                this.out.println("*** Big gun turn: " + gunTurn * 180.0 / Math.PI + " , th: " + t * 180.0 / Math.PI + " , gh: " + this.getGunHeadingRadians() * 180.0 / Math.PI);
            }
            if (gunTurn > 0.0) {
                this.setTurnGunRightRadians(gunTurn);
            } else {
                this.setTurnGunLeftRadians(-gunTurn);
            }
        }
    }

    public void driveAt(Point2D.Double aimPoint, double offset) {
        if (aimPoint != null) {
            double dy;
            double dx = aimPoint.getX() - this.getX();
            double t = Math.atan2(dx, dy = aimPoint.getY() - this.getY());
            double turn = t - this.getHeadingRadians();
            if (Math.abs(turn) > Math.PI) {
                turn = (double)(turn < 0.0 ? 1 : -1) * (Math.PI * 2 - Math.abs(turn));
            }
            if (turn > 0.0) {
                this.setTurnRightRadians(turn % (Math.PI * 2) + offset);
            } else {
                this.setTurnLeftRadians(-turn % (Math.PI * 2) - offset);
            }
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.setTurnLeft((90.0 - e.getBearing()) * 0.75);
        if (!e.getName().equals(this.lastTarget) && Math.random() < 0.05) {
            this.lastTarget = e.getName();
        }
    }

    public void onHitWall(HitWallEvent event) {
        if (Math.abs(event.getBearing()) < 90.0) {
            this.setBack(25.0);
        } else {
            this.setAhead(25.0);
        }
        this.setTurnLeft(0.51 * (180.0 - event.getBearing()));
        ++bumpCount;
    }

    public void onRobotDeath(RobotDeathEvent event) {
        if (event.getName().equals(this.lastTarget)) {
            this.lastTarget = null;
            this.aiming = false;
        }
    }

    public void onHitRobot(HitRobotEvent event) {
        if (event.getBearing() > -90.0 && event.getBearing() <= 90.0) {
            this.setBack(40.0);
            if (event.getBearing() > 0.0) {
                this.setTurnLeft(90.0 - event.getBearing());
            } else {
                this.setTurnRight(90.0 + event.getBearing());
            }
        } else {
            this.setAhead(40.0);
            this.setTurnRight(90.0 + event.getBearing());
        }
        if (this.lastTarget == null || this.lastRange > 100.0) {
            this.lastTarget = event.getName();
            this.lastRange = 80.0;
        }
    }

    public void onCustomEvent(CustomEvent event) {
        if (event.getCondition() instanceof GunTurnCompleteCondition) {
            this.onGunTurnComplete();
        } else if (event.getCondition() instanceof MoveCompleteCondition) {
            this.onMoveComplete();
        } else if (event.getCondition() instanceof RadarTurnCompleteCondition) {
            this.onRadarTurnComplete();
        } else if (event.getCondition() instanceof TurnCompleteCondition) {
            this.onTurnComplete();
        }
    }

    public void onMoveComplete() {
        this.setAhead(100.0 * (1.0 + Math.random()));
    }

    public void onRadarTurnComplete() {
        if (this.leftScan) {
            this.setTurnRadarLeft(this.scanSize + this.scanDrift);
        } else {
            this.setTurnRadarRight(this.scanSize + this.scanDrift);
        }
        this.scanDrift = 0.0;
    }

    public void onGunTurnComplete() {
        if (this.aiming && this.lastTarget != null) {
            this.aiming = false;
            if (this.getEnergy() > 10.0) {
                this.setFire(this.getKillPower(this.lastTarget, 3.0));
            } else {
                this.setFire(this.getKillPower(this.lastTarget, this.getEnergy() / 10.0));
            }
        }
    }

    public double getKillPower(String target, double limit) {
        double enemyEnergy = this.tracker.getEnergy(target);
        double killEnergy = 0.0;
        killEnergy = enemyEnergy > 4.0 ? (enemyEnergy + 2.0) / 6.0 : enemyEnergy / 4.0;
        if (killEnergy > limit) {
            killEnergy = limit;
        }
        return killEnergy;
    }

    public void onTurnComplete() {
        double x = this.getX();
        double y = this.getY();
        double w = this.getBattleFieldWidth();
        double h = this.getBattleFieldHeight();
        int wall = 80;
        double wallTurnSp = 4.0;
        int wallTurn = 40;
        this.setMaxVelocity(8.0 - 2.0 * Math.random() * Math.random());
        if (x < 80.0 || y < 80.0 || x > w - 80.0 || y > h - 80.0) {
            if (x < 80.0 && this.getHeading() > 180.0) {
                if (this.getHeading() < 270.0) {
                    this.setTurnLeft(40.0);
                } else {
                    this.setTurnRight(40.0);
                }
                this.setMaxVelocity(4.0);
            } else if (y < 80.0 && this.getHeading() > 90.0 && this.getHeading() < 270.0) {
                if (this.getHeading() < 180.0) {
                    this.setTurnLeft(40.0);
                } else {
                    this.setTurnRight(40.0);
                }
                this.setMaxVelocity(4.0);
            }
            if (y > h - 80.0 && (this.getHeading() > 270.0 || this.getHeading() < 90.0)) {
                if (this.getHeading() > 270.0) {
                    this.setTurnLeft(40.0);
                } else {
                    this.setTurnRight(40.0);
                }
                this.setMaxVelocity(4.0);
            } else if (x > w - 80.0 && this.getHeading() < 180.0) {
                if (this.getHeading() < 90.0) {
                    this.setTurnLeft(40.0);
                } else {
                    this.setTurnRight(40.0);
                }
                this.setMaxVelocity(4.0);
            }
        } else if (this.lastRange > 200.0 && Math.random() < 0.8) {
            this.driveAt(this.tracker.getAimPoint(this.lastTarget), 1.0);
        } else if (this.lastRange < 150.0 && Math.random() < 0.6) {
            this.driveAt(this.tracker.getAimPoint(this.lastTarget), -2.0);
        } else {
            this.setTurnLeft(3.0 * (Math.random() - Math.random() * 0.999));
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        ++skipCount;
    }
}

