/*
 * Decompiled with CFR 0.152.
 */
package ak;

import ak.AdvancedBullet;
import ak.Fermat;
import ak.FiringStrategy;
import ak.LogData;
import ak.Statistic;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.GunTurnCompleteCondition;

public class OtherBot {
    public double energy;
    public double prevEnergy;
    public double X;
    public double prevX;
    public double Y;
    public double prevY;
    public double heading;
    public double headingChange;
    public double velocity;
    public double avgVelocity;
    public double avgHeadingChange;
    public double avgStopVelocity;
    public double avgStraightHeadingChange;
    public double rollingAvgVelocity;
    public double rollingAvgStopVelocity;
    public double rollingAvgHeadingChange;
    public double rollingAvgStraightHeadingChange;
    public double lastAttackTime;
    public long scanTime;
    public long previousScanTime;
    public long lastBulletTime;
    public long logStartTime;
    public boolean alive;
    public boolean attacking;
    public String name;
    Hashtable logTable;
    int velocityScans;
    int lastWin;
    int headingScans;
    int stopVelocityScans;
    int straightHeadingScans;
    int movementStrategy;
    Vector stats;

    public void update(double energy, double X, double Y, double heading, double velocity, long scanTime) {
        double h = Math.toRadians(this.normalRelativeAngle(heading - this.heading));
        this.headingChange = h / (double)(scanTime - this.scanTime);
        this.prevEnergy = this.energy;
        this.previousScanTime = this.scanTime;
        this.lastBulletTime = this.scanTime - 1L;
        this.energy = energy;
        this.prevX = this.X;
        this.prevY = this.Y;
        this.X = X;
        this.Y = Y;
        this.heading = heading;
        this.velocity = velocity;
        this.scanTime = scanTime;
        LogData prevData = (LogData)this.logTable.get(new Integer((int)this.previousScanTime));
        long time = this.previousScanTime + 1L;
        while (time <= scanTime) {
            this.logTable.put(new Integer((int)time), new LogData(prevData.headingChange + (double)(time - this.previousScanTime) * (this.headingChange - prevData.headingChange) / (double)(scanTime - this.previousScanTime), prevData.velocity + (double)(time - this.previousScanTime) * (velocity - prevData.velocity) / (double)(scanTime - this.previousScanTime)));
            ++time;
        }
        if (velocity != 0.0) {
            ++this.velocityScans;
            this.avgVelocity = (this.avgVelocity * (double)(this.velocityScans - 1) + Math.abs(velocity)) / (double)this.velocityScans;
            this.rollingAvgVelocity = (this.rollingAvgVelocity * (double)4 + Math.abs(velocity)) / (double)5;
        }
        if (energy > 0.0) {
            ++this.stopVelocityScans;
            this.avgStopVelocity = (this.avgStopVelocity * (double)(this.stopVelocityScans - 1) + Math.abs(velocity)) / (double)this.stopVelocityScans;
            ++this.straightHeadingScans;
            this.avgStraightHeadingChange = (this.avgStraightHeadingChange * (double)(this.straightHeadingScans - 1) + Math.abs(this.headingChange)) / (double)this.straightHeadingScans;
            this.rollingAvgStopVelocity = (this.rollingAvgStopVelocity * (double)4 + Math.abs(velocity)) / (double)5;
            this.rollingAvgStraightHeadingChange = (this.rollingAvgStraightHeadingChange * (double)4 + Math.abs(this.headingChange)) / (double)5;
        }
        if (Math.abs(this.headingChange) > 1.0E-5) {
            ++this.headingScans;
            this.avgHeadingChange = (this.avgHeadingChange * (double)(this.headingScans - 1) + Math.abs(this.headingChange)) / (double)this.headingScans;
            this.rollingAvgHeadingChange = (this.rollingAvgHeadingChange * (double)4 + Math.abs(this.headingChange)) / (double)5;
        }
    }

    public void fireBot(Fermat robot) {
        Point2D.Double p;
        double reqdFirePower;
        boolean strategy = false;
        double maxProbability = -1.0E30;
        double firePower = 3;
        double lastHitTime = -1.0;
        double firingPower = 0.0;
        Point2D.Double strategicPos = new Point2D.Double(0.0, 0.0);
        double distance = Math.sqrt((this.X - robot.getX()) * (this.X - robot.getX()) + (this.Y - robot.getY()) * (this.Y - robot.getY()));
        FiringStrategy firingStrategy = new FiringStrategy(this);
        int i = 0;
        while (i < FiringStrategy.count) {
            double probability;
            Statistic stat = (Statistic)this.stats.elementAt(i);
            firePower = 1000.0 / distance;
            if (firePower > (double)3) {
                firePower = 3;
            }
            if (firePower < 0.1) {
                firePower = 0.1;
            }
            if ((reqdFirePower = this.energy + 0.1 < (double)4 ? (this.energy + 0.1) / (double)4 : (this.energy + 2.1) / 6.0) < 0.0) {
                reqdFirePower = 0.1;
            }
            if (reqdFirePower < firePower) {
                firePower = reqdFirePower;
            }
            if (robot.getEnergy() - 0.1 < firePower) {
                firePower = robot.getEnergy() - 0.1;
            }
            if ((probability = stat.getRatio()) > maxProbability) {
                p = firingStrategy.applyStrategy(i, this, firePower, robot);
                if (p.x > 0.0) {
                    maxProbability = probability = stat.getRatio();
                    strategicPos = p;
                    firingPower = firePower;
                }
            }
            ++i;
        }
        double turnAngle = this.findGunTurn(strategicPos.x, strategicPos.y, robot);
        robot.setTurnGunLeft(turnAngle);
        if (Math.abs(robot.getGunTurnRemaining()) < 20.0) {
            long prevTime = robot.getTime();
            robot.waitFor((Condition)new GunTurnCompleteCondition((AdvancedRobot)robot));
            long nextTime = robot.getTime();
            if (robot.getGunHeat() == 0.0 && firingPower > 0.0) {
                if (prevTime != nextTime) {
                    robot.doUpdates();
                }
                robot.previousTarget = robot.target;
                robot.fireBullet(firingPower);
            }
            i = 0;
            while (i < FiringStrategy.count) {
                firePower = 1000.0 / distance;
                if (firePower > (double)3) {
                    firePower = 3;
                }
                if (firePower < 0.1) {
                    firePower = 0.1;
                }
                if ((reqdFirePower = this.energy + 0.1 < (double)4 ? (this.energy + 0.1) / (double)4 : (this.energy + 2.1) / 6.0) < 0.0) {
                    reqdFirePower = 0.1;
                }
                if (reqdFirePower < firePower) {
                    firePower = reqdFirePower;
                }
                if (robot.getEnergy() - 0.1 < firePower) {
                    firePower = robot.getEnergy() - 0.1;
                }
                p = firingStrategy.applyStrategy(i, this, firePower, robot);
                if (p.x > 0.0) {
                    AdvancedBullet adBullet = new AdvancedBullet(robot.getX(), robot.getY(), p, firePower, distance, robot.getTime(), robot.target);
                    adBullet.strategy = i;
                    robot.bulletVector.addElement(adBullet);
                }
                ++i;
            }
        } else {
            robot.execute();
        }
    }

    double findGunTurn(double x, double y, Fermat robot) {
        double angle = this.normalAbsoluteHeading(Math.toDegrees(1.5707963267948966 - Math.atan2(robot.getY() - y, robot.getX() - x)));
        return this.normalRelativeAngle(robot.getGunHeading() - angle + 180.0);
    }

    public double normalAbsoluteHeading(double angle) {
        if (angle < 0.0) {
            return 360.0 + angle % 360.0;
        }
        return angle % 360.0;
    }

    public double normalRelativeAngle(double angle) {
        if (angle > 180.0) {
            return (angle + 180.0) % 360.0 - 180.0;
        }
        if (angle < -180.0) {
            return (angle - 180.0) % 360.0 + 180.0;
        }
        return angle;
    }

    /*
     * Unable to fully structure code
     */
    OtherBot(Fermat robot, double energy, double X, double Y, double heading, double velocity, long scanTime, String name) {
        block4: {
            super();
            this.energy = energy;
            this.prevEnergy = 100.0;
            this.X = this.prevX = X;
            this.Y = this.prevY = Y;
            this.heading = heading;
            this.velocity = velocity;
            this.previousScanTime = 0L;
            this.scanTime = scanTime;
            this.name = name;
            this.rollingAvgStraightHeadingChange = 0.0;
            this.rollingAvgHeadingChange = 0.0;
            this.avgStraightHeadingChange = 0.0;
            this.avgHeadingChange = 0.0;
            this.headingChange = 0.0;
            this.alive = true;
            this.lastAttackTime = 0.0;
            this.lastBulletTime = -1;
            this.attacking = false;
            this.avgVelocity = Math.abs(velocity);
            this.rollingAvgVelocity = this.rollingAvgStopVelocity = Math.abs(velocity);
            this.avgStopVelocity = this.rollingAvgStopVelocity = this.rollingAvgStopVelocity;
            this.straightHeadingScans = 1;
            this.stopVelocityScans = 1;
            this.headingScans = 1;
            this.velocityScans = 1;
            this.stats = new Vector<E>();
            this.logTable = new Hashtable<K, V>();
            this.logTable.put(new Integer((int)robot.getTime()), new LogData(0.0, velocity));
            this.logStartTime = robot.getTime();
            try {
                br = new BufferedReader(new FileReader(robot.getDataFile(name + ".txt")));
                i = 0;
                while (i < FiringStrategy.count) {
                    stat = new Statistic();
                    stat.numShots = Integer.parseInt(br.readLine());
                    stat.numHits = Integer.parseInt(br.readLine());
                    this.stats.addElement(stat);
                    ++i;
                }
                break block4;
            }
            catch (Exception exp1) {
                this.stats.clear();
                i = 0;
                ** while (i < FiringStrategy.count)
            }
lbl-1000:
            // 1 sources

            {
                stat = new Statistic();
                stat.numShots = 2;
                stat.numHits = 1;
                this.stats.addElement(stat);
                ++i;
                continue;
            }
        }
    }
}

