/*
 * Decompiled with CFR 0.152.
 */
package krillr.mega.utils;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import krillr.mega.utils.KrillrRobot;
import krillr.mega.utils.Module;
import krillr.mega.utils.Movement;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class MovementManager
extends Module {
    public Vector movements = new Vector();
    public Rectangle2D fieldRect;
    public Rectangle2D fieldRectWithMargins;
    public Movement currentMover;
    public static final int WALL_MARGIN = 36;

    public MovementManager(KrillrRobot b) {
        this.bot = b;
        this.fieldRect = new Rectangle2D.Double(0.0, 0.0, this.bot.getBattleFieldWidth(), this.bot.getBattleFieldHeight());
        this.fieldRectWithMargins = new Rectangle2D.Double(36.0, 36.0, this.bot.getBattleFieldWidth() - 72.0, this.bot.getBattleFieldHeight() - 72.0);
    }

    public Movement getMovement() {
        double topWeight = Double.NEGATIVE_INFINITY;
        Movement movement = null;
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement m = (Movement)this.movements.get(i);
            if (!(m.weight > topWeight)) continue;
            movement = m;
            topWeight = m.weight;
        }
        return movement;
    }

    public void addMovement(Movement m) {
        this.movements.add(m);
    }

    public void handleStartup() {
        this.currentMover = this.getMovement();
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleStartup();
            this.movements.set(i, movement);
        }
    }

    public void handleTurn(long t) {
        this.currentMover = this.getMovement();
        if (this.currentMover == null) {
            return;
        }
        this.currentMover.handleTurn(this.bot.getTime());
        this.movements.set(this.movements.indexOf(this.currentMover), this.currentMover);
    }

    public void handleScan(ScannedRobotEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleScan(e);
            this.movements.set(i, movement);
        }
    }

    public void handleBulletHit(BulletHitEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleBulletHit(e);
            this.movements.set(i, movement);
        }
    }

    public void handleBulletHitBullet(BulletHitBulletEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleBulletHitBullet(e);
            this.movements.set(i, movement);
        }
    }

    public void handleBulletMissed(BulletMissedEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleBulletMissed(e);
            this.movements.set(i, movement);
        }
    }

    public void handleHitByBullet(HitByBulletEvent e) {
        this.bot.out.println(this.currentMover == null);
        if (this.currentMover == null) {
            return;
        }
        this.bot.out.println("Got bullet.");
        this.currentMover.handleHitByBullet(e);
        this.movements.set(this.movements.indexOf(this.currentMover), this.currentMover);
    }

    public void handleHitRobot(HitRobotEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleHitRobot(e);
            this.movements.set(i, movement);
        }
    }

    public void handleHitWall(HitWallEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleHitWall(e);
            this.movements.set(i, movement);
        }
    }

    public void handleRobotDeath(RobotDeathEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleRobotDeath(e);
            this.movements.set(i, movement);
        }
    }

    public void handleWin(WinEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleWin(e);
            this.movements.set(i, movement);
        }
    }

    public void handleDeath(DeathEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleDeath(e);
            this.movements.set(i, movement);
        }
    }

    public void handleMessage(MessageEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleMessage(e);
            this.movements.set(i, movement);
        }
    }

    public void handleSkippedTurn(SkippedTurnEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleSkippedTurn(e);
            this.movements.set(i, movement);
        }
    }

    public void handlePaint(Graphics2D g) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handlePaint(g);
        }
    }

    public void handleCustomEvent(CustomEvent e) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleCustomEvent(e);
            this.movements.set(i, movement);
        }
    }

    public void handleFiredBullet(Bullet b) {
        for (int i = 0; i < this.movements.size(); ++i) {
            Movement movement = (Movement)this.movements.get(i);
            movement.handleFiredBullet(b);
            this.movements.set(i, movement);
        }
    }
}

