/*
 * Decompiled with CFR 0.152.
 */
package jbot.tracer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jbot.Inherit;
import jbot.Rabbit2;
import jbot.tracer.Ray;
import jbot.tracer.Target;
import jbot.tracer.Wave;
import jbot.tracer.techniques.AvgAngleTechnique;
import jbot.tracer.techniques.ModulatedAvgTechnique;
import jbot.tracer.techniques.MultiAvgTechnique;
import jbot.tracer.techniques.SegmentedAngleTechnique;
import jbot.tracer.techniques.SmoothVelocityTechnique;
import jbot.tracer.techniques.StaticPosTechnique;
import jbot.tracer.techniques.TracerTechnique;
import jbot.tracer.techniques.WallsGravityTechnique;
import jbot.util.MathUtil;
import jbot.util.Vector2;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class Tracer {
    public static double SELF_WAVE_BULLETS_POWER = 1.99999;
    private boolean mIsSetup = false;
    Rabbit2 mBot;
    Inherit mInherit;
    Target mTarget;
    Target mSelf;
    List<TracerTechnique> mTargetTechniques;
    List<TracerTechnique> mSelfTechniques;
    double mFireBulletPower = 0.0;
    private int mTargetTechniquesRealHits = 0;
    public StaticPosTechnique mTargetsStaticPosTechnique = null;
    public SmoothVelocityTechnique mTargetsSmoothVelocityTechnique = null;
    public SegmentedAngleTechnique mTargetsSegmentedAngleTechnique = null;
    public AvgAngleTechnique mTargetsAvgAngleTechnique = null;
    public MultiAvgTechnique mTargetsMultiAvgTechnique = null;
    public ModulatedAvgTechnique mTargetsModulatedAvgTechnique = null;
    public SmoothVelocityTechnique mSmoothVelocityTechnique = null;
    public SegmentedAngleTechnique mSegmentedAngleTechnique = null;
    public AvgAngleTechnique mAvgAngleTechnique = null;
    public MultiAvgTechnique mMultiAvgTechnique = null;
    public ModulatedAvgTechnique mModulatedAvgTechnique = null;
    public WallsGravityTechnique mWallsGravityTechnique = null;
    static final double HIT_REWARD_FACTOR = 1.0;
    static final double NEAR_REWARD_FACTOR = 0.1;
    static final double HIT_RANGE = 20.0;
    static final double NEAR_RANGE = 40.0;

    public int getTargetTechniquesRealHits() {
        return this.mTargetTechniquesRealHits;
    }

    public Tracer(Rabbit2 rabbit, Target self, Target target, Inherit inherit) {
        this.mBot = rabbit;
        this.mTarget = target;
        this.mSelf = self;
        this.mInherit = inherit;
        this.mTargetTechniques = new ArrayList<TracerTechnique>();
        this.mSelfTechniques = new ArrayList<TracerTechnique>();
    }

    public boolean setup() {
        if (this.mIsSetup) {
            return false;
        }
        this.mTargetsStaticPosTechnique = new StaticPosTechnique("SP_TargetTech", this.mBot, this.mTarget, this.mSelf, 0.6283185307179586, 0.5);
        this.mTargetsSmoothVelocityTechnique = new SmoothVelocityTechnique("SV_TargetTech", this.mBot, this.mTarget, this.mSelf, 0.6283185307179586, 0.5);
        this.mTargetsAvgAngleTechnique = new AvgAngleTechnique("AA_TargetTech", this.mBot, this.mTarget, this.mSelf, 0.6283185307179586, 0.5);
        this.mTargetsMultiAvgTechnique = new MultiAvgTechnique("MulA_TargetTech", this.mBot, this.mTarget, this.mSelf, 0.6283185307179586, 0.5);
        this.mTargetsModulatedAvgTechnique = new ModulatedAvgTechnique("ModA_TargetTech", this.mBot, this.mTarget, this.mSelf, 0.6283185307179586, 0.5);
        SegmentedAngleTechnique.presetOrbiAvgVelAbs(true);
        SegmentedAngleTechnique.presetOrbiAvgVelSegments(3);
        SegmentedAngleTechnique.presetOrbiVelSegments(9);
        SegmentedAngleTechnique.presetVertiVelSegments(3);
        SegmentedAngleTechnique.presetTimeDistSegments(1);
        this.mTargetsSegmentedAngleTechnique = new SegmentedAngleTechnique("SA_TargetTech", this.mBot, this.mTarget, this.mSelf, 0.6283185307179586, 0.5);
        this.mTargetTechniques.clear();
        this.mTargetTechniques.add(this.mTargetsStaticPosTechnique);
        this.mTargetTechniques.add(this.mTargetsSmoothVelocityTechnique);
        this.mTargetTechniques.add(this.mTargetsSegmentedAngleTechnique);
        this.mTargetTechniques.add(this.mTargetsAvgAngleTechnique);
        this.mTargetTechniques.add(this.mTargetsMultiAvgTechnique);
        this.mTargetTechniques.add(this.mTargetsModulatedAvgTechnique);
        this.mSmoothVelocityTechnique = new SmoothVelocityTechnique("SV_SelfTech", this.mBot, this.mSelf, this.mTarget, 0.3141592653589793, 0.3);
        this.mAvgAngleTechnique = new AvgAngleTechnique("AA_SelfTech", this.mBot, this.mSelf, this.mTarget, 0.39269908169872414, 0.3);
        this.mMultiAvgTechnique = new MultiAvgTechnique("MulA_SelfTech", this.mBot, this.mSelf, this.mTarget, 0.6283185307179586, 0.3);
        this.mModulatedAvgTechnique = new ModulatedAvgTechnique("ModA_SelfTech", this.mBot, this.mSelf, this.mTarget, 0.39269908169872414, 0.3);
        this.mWallsGravityTechnique = new WallsGravityTechnique("WG_SelfTech", this.mBot, this.mSelf, this.mTarget, 0.39269908169872414, 0.3);
        SegmentedAngleTechnique.presetOrbiAvgVelAbs(true);
        SegmentedAngleTechnique.presetOrbiAvgVelSegments(9);
        SegmentedAngleTechnique.presetOrbiVelSegments(5);
        SegmentedAngleTechnique.presetVertiVelSegments(5);
        SegmentedAngleTechnique.presetTimeDistSegments(12);
        this.mSegmentedAngleTechnique = new SegmentedAngleTechnique("SA_SelfTech", this.mBot, this.mSelf, this.mTarget, 0.6283185307179586, 0.3);
        this.mSelfTechniques.clear();
        this.mSelfTechniques.add(this.mSmoothVelocityTechnique);
        this.mSelfTechniques.add(this.mSegmentedAngleTechnique);
        this.mSelfTechniques.add(this.mAvgAngleTechnique);
        this.mSelfTechniques.add(this.mMultiAvgTechnique);
        this.mSelfTechniques.add(this.mModulatedAvgTechnique);
        this.mSelfTechniques.add(this.mWallsGravityTechnique);
        this.extractData();
        this.mIsSetup = true;
        return true;
    }

    public boolean collectData() {
        Inherit.Container c;
        if (!this.mIsSetup) {
            return false;
        }
        TracerContainer container = new TracerContainer();
        container.mSavedTargetTechniquesRealHits = this.mTargetTechniquesRealHits;
        this.mInherit.addContainer(container);
        for (TracerTechnique t : this.mSelfTechniques) {
            c = t.collectData();
            if (c == null) continue;
            this.mInherit.addContainer(c);
        }
        for (TracerTechnique t : this.mTargetTechniques) {
            c = t.collectData();
            if (c == null) continue;
            this.mInherit.addContainer(c);
        }
        return true;
    }

    public boolean extractData() {
        TracerContainer o = (TracerContainer)this.mBot.getInherit().getContainerBy("Tracer");
        if (o == null) {
            return false;
        }
        this.mTargetTechniquesRealHits = o.mSavedTargetTechniquesRealHits;
        if (this.mTargetTechniquesRealHits > 7) {
            this.mTargetTechniquesRealHits = 7;
        }
        double hitsChange = (double)this.mTargetTechniquesRealHits / (double)o.mSavedTargetTechniquesRealHits;
        for (TracerTechnique t : this.mTargetTechniques) {
            t.recalcRealHits(hitsChange);
        }
        return true;
    }

    public Target getEnemyTarget() {
        return this.mTarget;
    }

    public Target getSelfTarget() {
        return this.mSelf;
    }

    public boolean isSetup() {
        return this.mIsSetup;
    }

    public static double getClearShootAngle(double distance) {
        return Math.tan(21.0 / distance);
    }

    public static double getMaxKeepDirAngle(Vector2 shootPos, Target target, double bulletPower) {
        if (target.getRecentVelSign() >= 0) {
            return Tracer.getMaxForwardEscapeAngle(shootPos, target, bulletPower);
        }
        return Tracer.getMaxBackwardEscapeAngle(shootPos, target, bulletPower);
    }

    public static double getMaxReverseDirAngle(Vector2 shootPos, Target target, double bulletPower) {
        if (target.getRecentVelSign() >= 0) {
            return Tracer.getMaxBackwardEscapeAngle(shootPos, target, bulletPower);
        }
        return Tracer.getMaxForwardEscapeAngle(shootPos, target, bulletPower);
    }

    public static double getMaxForwardEscapeAngle(Vector2 shootPos, Target target, double bulletPower) {
        double start_d;
        bulletPower = MathUtil.trunc(bulletPower, 0.1, 3.0);
        Vector2 distance = target.getPosition().sub(shootPos);
        double vb = Rules.getBulletSpeed((double)bulletPower);
        double vt = target.getSpeed();
        double d = start_d = distance.getLength();
        double sb = vb;
        double st = 0.0;
        int t = 1;
        if (vt > 0.0) {
            double a = target.getDirection().getAngleTo(distance.clone().invert());
            a = Math.abs(Math.cos(a));
            vt -= a * 8.0;
        }
        while (sb < d) {
            ++t;
            sb += vb;
            if (vt < 0.0) {
                vt = (vt += 2.0) > 0.0 ? 0.0 : vt;
            } else if (vt < 8.0) {
                vt = (vt += 1.0) > 8.0 ? 8.0 : vt;
            }
            d = Math.sqrt(start_d * start_d + (st += vt) * st);
        }
        distance.normalize().rotateByHalfPiLeft();
        if (distance.dot(target.getDirection()) < 0.0) {
            distance.invert();
        }
        Vector2 targetPos = target.getPosition().add(distance.multiply(st));
        distance = targetPos.sub(shootPos);
        return distance.getAngle();
    }

    public static double getMaxBackwardEscapeAngle(Vector2 shootPos, Target target, double bulletPower) {
        double start_d;
        bulletPower = MathUtil.trunc(bulletPower, 0.1, 3.0);
        Vector2 distance = target.getPosition().sub(shootPos);
        double vb = Rules.getBulletSpeed((double)bulletPower);
        double vt = target.getSpeed();
        double d = start_d = distance.getLength();
        double sb = vb;
        double st = 0.0;
        int t = 1;
        if (vt < 0.0) {
            double a = target.getDirection().getAngleTo(distance.clone().invert());
            a = Math.abs(Math.cos(a));
            vt += a * 8.0;
        }
        while (sb < d) {
            ++t;
            sb += vb;
            if (vt > 0.0) {
                vt = (vt -= 2.0) < 0.0 ? 0.0 : vt;
            } else if (vt > -8.0) {
                vt = (vt -= 1.0) < -8.0 ? -8.0 : vt;
            }
            d = Math.sqrt(start_d * start_d + (st += vt) * st);
        }
        distance.normalize().rotateByHalfPiLeft();
        if (distance.dot(target.getDirection()) < 0.0) {
            distance.invert();
        }
        Vector2 targetPos = target.getPosition().add(distance.multiply(st));
        distance = targetPos.sub(shootPos);
        return distance.getAngle();
    }

    public TracerTechnique getBestSelfTechnique() {
        if (this.mSelfTechniques.isEmpty()) {
            return null;
        }
        TracerTechnique best = this.mSelfTechniques.get(0);
        double distance = this.mTarget.getRelativePos().getLength();
        for (TracerTechnique t : this.mSelfTechniques) {
            if (!(t.getHitProbability(distance) > best.getHitProbability(distance))) continue;
            best = t;
        }
        return best;
    }

    public TracerTechnique getBestTargetTechnique() {
        if (this.mTargetTechniques.isEmpty()) {
            return null;
        }
        TracerTechnique best = this.mTargetTechniques.get(0);
        double distance = this.mTarget.getRelativePos().getLength();
        for (TracerTechnique t : this.mTargetTechniques) {
            if (!(t.getHitProbability(distance) > best.getHitProbability(distance))) continue;
            best = t;
        }
        return best;
    }

    public TracerTechnique getBestTargetTechniqueByHits() {
        if (this.mTargetTechniques.isEmpty()) {
            return null;
        }
        TracerTechnique best = this.mTargetTechniques.get(0);
        for (TracerTechnique t : this.mTargetTechniques) {
            if (t.getRealHits() <= best.getRealHits()) continue;
            best = t;
        }
        return best;
    }

    public Ray getRecentSelfRay(TracerTechnique tech) {
        if (this.mSelf.mWavesList.isEmpty()) {
            return null;
        }
        Wave w = this.mSelf.mWavesList.get(this.mSelf.mWavesList.size() - 1);
        return w.getRayBy(tech);
    }

    public void frame(double deltaTime) {
        if ((double)this.mBot.getTime() > this.mTarget.getGunHeat()) {
            this.mTarget.estimatedFrame(deltaTime);
            this.mSelf.estimatedFrame(deltaTime);
        }
    }

    public void onScannedTarget(double deltaTime, ScannedRobotEvent evt) {
        if (!this.isSetup()) {
            this.setup();
        }
        this.updateTargetsTime(evt);
        this.updateTargetsWaves(deltaTime);
        this.traceTargetsMovement(deltaTime, evt);
        this.traceTargetsEnergy(deltaTime, evt);
        this.mTarget.updateHistory();
        this.mSelf.updateHistory();
        for (TracerTechnique t : this.mSelfTechniques) {
            t.frame(this.mBot.getTime());
        }
        for (TracerTechnique t : this.mTargetTechniques) {
            t.frame(this.mBot.getTime());
        }
        this.testSelfWaves();
        this.testTargetsWaves();
        this.createSelfWave();
        this.createTargetsWave();
    }

    public void setFireBullet(double power) {
        this.mFireBulletPower = power;
        ++this.mSelf.mBulletsFired;
    }

    public void onBulletHit(BulletHitEvent evt) {
        this.mTarget.mEnergy -= Rules.getBulletDamage((double)evt.getBullet().getPower());
        ++this.mTarget.mBulletsHitedBy;
    }

    public void onHitRobot(HitRobotEvent evt) {
        this.mTarget.mEnergy = evt.getEnergy();
    }

    public void onHitByBullet(HitByBulletEvent evt) {
        ++this.mSelf.mBulletsHitedBy;
        this.mTarget.mEnergy += Rules.getBulletHitBonus((double)evt.getPower());
        Wave w = null;
        ListIterator<Wave> i = this.mTarget.mWavesList.listIterator(0);
        while (i.hasNext()) {
            w = i.next();
            double distToMe = w.getDistanceTo(this.mBot.getPosition(), evt.getTime());
            double clearAngle = Tracer.getClearShootAngle(w.getDistToTarget());
            if (MathUtil.cmp(w.getPower(), evt.getPower()) == 0 && Math.abs(distToMe) < 25.0) {
                for (Ray r : w.mRaysList) {
                    Vector2 distance = this.mSelf.getPosition().sub(w.getShotPos());
                    double aimError = distance.getAngleTo(r.getDirection());
                    if (aimError <= clearAngle * 1.3) {
                        ++this.mTargetTechniquesRealHits;
                        r.mTechnique.addRealHit();
                    }
                    r.mTechnique.rewardAccuracy(aimError, w.isRealBullet());
                    r.mTechnique.selfLearn(w, r, aimError);
                }
                i.remove();
                break;
            }
            if (!(distToMe < -50.0)) continue;
            i.remove();
        }
    }

    public void onDeath(DeathEvent event) {
    }

    public void onWin(WinEvent evt) {
    }

    protected void updateTargetsTime(ScannedRobotEvent evt) {
        this.mTarget.updateTime(evt.getTime());
        this.mSelf.updateTime(this.mBot.getTime());
    }

    void updateTargetsWaves(double deltaTime) {
        Wave w = null;
        ListIterator<Wave> i = this.mTarget.mWavesList.listIterator(0);
        while (i.hasNext()) {
            w = i.next();
            w.updateTraveledDistance(deltaTime);
            if (!w.isOverField()) continue;
            i.remove();
        }
        i = this.mSelf.mWavesList.listIterator(0);
        while (i.hasNext()) {
            w = i.next();
            w.updateTraveledDistance(deltaTime);
            if (!w.isOverField()) continue;
            i.remove();
        }
    }

    void traceTargetsMovement(double deltaTime, ScannedRobotEvent evt) {
        Vector2 direction = new Vector2(evt.getHeadingRadians());
        Vector2 relativePos = new Vector2(this.mBot.getHeadingRadians() + evt.getBearingRadians());
        relativePos.multiply(evt.getDistance());
        Vector2 position = this.mBot.getPosition().add(relativePos);
        this.mTarget.updatePosition(position, relativePos);
        this.mTarget.updateMovement(evt.getVelocity(), direction);
        this.mSelf.updatePosition(this.mBot.getPosition(), relativePos.invert());
        this.mSelf.updateMovement(this.mBot.getVelocity(), new Vector2(this.mBot.getHeadingRadians()));
    }

    void traceTargetsEnergy(double deltaTime, ScannedRobotEvent evt) {
        double gunHeat;
        if (this.mTarget.getHistorySize() == 0) {
            return;
        }
        if (this.mTarget.getRelativePos().getLength() < 60.0) {
            return;
        }
        if (MathUtil.cmp(evt.getEnergy(), this.mTarget.mEnergy) == -1 && this.mTarget.mGunHeat < this.mBot.getGunCoolingRate()) {
            ++this.mTarget.mBulletsFired;
            double bulletPower = this.mTarget.mEnergy - evt.getEnergy();
            bulletPower = MathUtil.trunc(bulletPower, 0.1, 3.0);
            this.mTarget.mGunHeat = Rules.getGunHeat((double)bulletPower);
            this.mTarget.mAvgBulletPower = this.mTarget.mAvgBulletPower < 0.01 ? bulletPower : this.mTarget.mAvgBulletPower * 0.9 + bulletPower * 0.1;
            long shotTime = evt.getTime() - 1L;
            Vector2 myPos = this.mSelf.getHistoryAt(shotTime).getPosition();
            Vector2 enemyPos = this.mTarget.getHistoryAt(shotTime).getPosition();
            Wave newWave = new Wave(shotTime, this.mBot.getTime(), enemyPos, myPos, bulletPower, true);
            for (TracerTechnique technique : this.mTargetTechniques) {
                technique.addEstimatedRay(newWave);
            }
            this.mTarget.mWavesList.add(newWave);
        }
        if (MathUtil.cmp(gunHeat = this.mTarget.mGunHeat, 0.0) == 1) {
            gunHeat -= this.mBot.getGunCoolingRate() * deltaTime;
        }
        this.mTarget.updateEnergy(evt.getEnergy(), this.mBot.getEnergy(), gunHeat);
        this.mSelf.updateEnergy(this.mBot.getEnergy(), evt.getEnergy(), this.mBot.getGunHeat());
    }

    void testSelfWaves() {
        Vector2 targetPos = this.mTarget.getPosition();
        Wave w = null;
        ListIterator<Wave> i = this.mSelf.mWavesList.listIterator(0);
        while (i.hasNext()) {
            w = i.next();
            double wavesDist = w.getDistanceTo(targetPos, this.mBot.getTime());
            if (!(Math.abs(wavesDist) < w.getSpeed() * 0.6)) continue;
            for (Ray r : w.mRaysList) {
                Vector2 distance = targetPos.clone().sub(w.getShotPos());
                double aimError = distance.getAngleTo(r.getDirection());
                r.mTechnique.rewardAccuracy(aimError, w.isRealBullet());
                r.mTechnique.selfLearn(w, r, aimError);
            }
            i.remove();
        }
    }

    void testTargetsWaves() {
        Vector2 selfPos = this.mSelf.getPosition();
        Wave w = null;
        ListIterator<Wave> i = this.mTarget.mWavesList.listIterator(0);
        while (i.hasNext()) {
            w = i.next();
            double wavesDist = w.getDistanceTo(selfPos, this.mBot.getTime());
            if (!(Math.abs(wavesDist) < w.getSpeed() * 0.6)) continue;
            for (Ray r : w.mRaysList) {
                Vector2 distance = selfPos.clone().sub(w.getShotPos());
                double aimError = distance.getAngleTo(r.getDirection());
                r.mTechnique.selfLearn(w, r, aimError);
            }
            i.remove();
        }
    }

    void createSelfWave() {
        boolean realBulletWave = false;
        if (this.mFireBulletPower != 0.0 && MathUtil.cmp(this.mFireBulletPower, SELF_WAVE_BULLETS_POWER) == 0) {
            realBulletWave = true;
            this.mFireBulletPower = 0.0;
        }
        Wave newWave = new Wave(this.mBot.getTime(), this.mBot.getTime(), this.mBot.getPosition(), this.mTarget.getPosition(), SELF_WAVE_BULLETS_POWER, realBulletWave);
        for (TracerTechnique tech : this.mSelfTechniques) {
            tech.addEstimatedRay(newWave);
        }
        this.mSelf.mWavesList.add(newWave);
    }

    void createTargetsWave() {
        Wave newWave = new Wave(this.mBot.getTime(), this.mBot.getTime(), this.mTarget.getPosition(), this.mBot.getPosition(), this.mTarget.mAvgBulletPower, false);
        for (TracerTechnique tech : this.mTargetTechniques) {
            tech.addEstimatedRay(newWave);
        }
        this.mTarget.mWavesList.add(newWave);
    }

    public void logStatusToConsole() {
        this.mBot.out.print("\n\nTRACER STATUS DUMP:\n\nSELF techniques num: " + this.mSelfTechniques.size());
        int c = 0;
        for (TracerTechnique t : this.mSelfTechniques) {
            this.mBot.out.print("\n" + ++c + ". " + t.toString());
            this.mBot.out.print("\ninaccuracy angle = ( " + t.getInaccuracy() / 3.14 * 180.0 + ", dev: " + t.getInaccuracyDev() / 3.14 * 180.0 + ", avg: " + t.getInaccuracyAvg() / 3.14 * 180.0 + " )");
            this.mBot.out.print("\nreal inaccuracy angle = ( " + t.getRealInaccuracy() / 3.14 * 180.0 + ", dev: " + t.getRealInaccuracyDev() / 3.14 * 180.0 + ", avg: " + t.getRealInaccuracyAvg() / 3.14 * 180.0 + " )");
            this.mBot.out.print("\nprobability for dist 200 = " + t.getHitProbability(200.0));
            this.mBot.out.print("\nprobability for dist 300 = " + t.getHitProbability(300.0));
            this.mBot.out.print("\n            for dist 400 = " + t.getHitProbability(400.0));
            this.mBot.out.print(t.prepareLogString());
        }
        this.mBot.out.print("\n\nTARGET techniques num: " + this.mTargetTechniques.size());
        c = 0;
        for (TracerTechnique t : this.mTargetTechniques) {
            this.mBot.out.print("\n" + ++c + ". " + t.toString());
            this.mBot.out.print("\ninaccuracy angle = ( " + t.getInaccuracy() / 3.14 * 180.0 + ", dev: " + t.getInaccuracyDev() / 3.14 * 180.0 + ", avg: " + t.getInaccuracyAvg() / 3.14 * 180.0 + " )");
            this.mBot.out.print("\nreal inaccuracy angle = ( " + t.getRealInaccuracy() / 3.14 * 180.0 + ", dev: " + t.getRealInaccuracyDev() / 3.14 * 180.0 + ", avg: " + t.getRealInaccuracyAvg() / 3.14 * 180.0 + " )");
            this.mBot.out.print("\nhit ratio = " + (double)t.getRealHits() / (double)this.mTargetTechniquesRealHits);
            this.mBot.out.print("\nprobability for dist 300 = " + t.getHitProbability(300.0));
            this.mBot.out.print(t.prepareLogString());
        }
        this.mBot.out.print("\n\n");
    }

    public void onPaint(Graphics2D g) {
        TracerTechnique t2;
        if (!this.mTarget.isLocked()) {
            return;
        }
        for (TracerTechnique t2 : this.mSelfTechniques) {
            t2.onPaint(g);
        }
        if (this.mTarget.getHistorySize() > 0) {
            Vector2 max = new Vector2(Tracer.getMaxForwardEscapeAngle(this.mSelf.getPosition(), this.mTarget, 1.99999));
            Vector2 min = new Vector2(Tracer.getMaxBackwardEscapeAngle(this.mSelf.getPosition(), this.mTarget, 1.99999));
            max.multiply(800.0).add(this.mSelf.getPosition());
            min.multiply(800.0).add(this.mSelf.getPosition());
            g.setColor(Color.red);
            g.drawLine((int)this.mSelf.getPosition().getX(), (int)this.mSelf.getPosition().getY(), (int)max.getX(), (int)max.getY());
            g.setColor(Color.yellow);
            g.drawLine((int)this.mSelf.getPosition().getX(), (int)this.mSelf.getPosition().getY(), (int)min.getX(), (int)min.getY());
        }
        for (Wave w : this.mTarget.mWavesList) {
            if (!w.isRealBullet()) continue;
            g.setColor(new Color(255, 255, 0, 20));
            g.drawOval((int)(w.mShotPos.getX() - w.getTraveledDistance()), (int)(w.mShotPos.getY() - w.getTraveledDistance()), (int)(2.0 * w.getTraveledDistance()), (int)(2.0 * w.getTraveledDistance()));
            for (Ray r : w.mRaysList) {
                Vector2 p = r.mDirection.clone().multiply(w.getTraveledDistance());
                p.add(w.mShotPos);
                double size = 10.0;
                g.setColor(r.mTechnique.getColor());
                g.drawOval((int)(p.getX() - size / 2.0), (int)(p.getY() - size / 2.0), (int)size, (int)size);
            }
        }
        t2 = null;
        ListIterator<TracerTechnique> i = this.mSelfTechniques.listIterator(0);
        while (i.hasNext()) {
            t2 = i.next();
            g.setColor(t2.getColor());
            if (t2.mEstimatedPath.isEmpty()) continue;
            Vector2 lv = t2.mEstimatedPath.get(0);
            ListIterator<Vector2> k = t2.mEstimatedPath.listIterator(1);
            while (k.hasNext()) {
                Vector2 v = k.next();
                g.drawLine((int)lv.getX(), (int)lv.getY(), (int)v.getX(), (int)v.getY());
                lv = v;
            }
        }
    }

    protected static class TracerContainer
    extends Inherit.Container {
        private static final long serialVersionUID = -5981579166623741270L;
        int mSavedTargetTechniquesRealHits;

        protected TracerContainer() {
            super("Tracer");
        }
    }
}

