/*
 * Decompiled with CFR 0.152.
 */
package rdm.gunners;

import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rdm.gunners.Gunner;
import rdm.precepts.GunPrecept;
import rdm.state.entities.State;
import robocode.Bullet;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u001f\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lrdm/gunners/TensorFlowGunner;", "Lrdm/gunners/Gunner;", "()V", "outputBuffer", "Ljava/nio/FloatBuffer;", "kotlin.jvm.PlatformType", "dispose", "", "handle", "Lrdm/precepts/GunPrecept;", "state", "Lrdm/state/entities/State;", "saveShot", "bullet", "Lrobocode/Bullet;", "precept", "saveShotResult", "hit", "", "(Lrobocode/Bullet;Ljava/lang/Boolean;)V", "Companion", "Commons"})
public final class TensorFlowGunner
implements Gunner {
    private final FloatBuffer outputBuffer = FloatBuffer.allocate(2);
    private static final String GUN_MODEL = "models/gun.pb";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public GunPrecept handle(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        float[] array = new float[4];
        array[0] = (float)state.getInstant().getEnemyBearingFromGun();
        array[1] = (float)state.getInstant().getEnemyHeadingFromGun();
        boolean shouldFire = (double)this.outputBuffer.get(0) > 0.9;
        double gunRotation = this.outputBuffer.get(1);
        return new GunPrecept(shouldFire, gunRotation, 0.0);
    }

    @Override
    public void saveShot(@NotNull Bullet bullet, @NotNull State state, @NotNull GunPrecept precept) {
        Intrinsics.checkParameterIsNotNull(bullet, "bullet");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(precept, "precept");
    }

    @Override
    public void saveShotResult(@NotNull Bullet bullet, @Nullable Boolean hit) {
        Intrinsics.checkParameterIsNotNull(bullet, "bullet");
    }

    @Override
    public void dispose() {
    }

    static {
        GUN_MODEL = GUN_MODEL;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lrdm/gunners/TensorFlowGunner$Companion;", "", "()V", "GUN_MODEL", "", "getGUN_MODEL", "()Ljava/lang/String;", "readAllBytesOrExit", "", "path", "Ljava/nio/file/Path;", "Commons"})
    public static final class Companion {
        private final String getGUN_MODEL() {
            return GUN_MODEL;
        }

        private final byte[] readAllBytesOrExit(Path path) {
            try {
                return Files.readAllBytes(path);
            }
            catch (IOException exception) {
                exception.printStackTrace();
                System.exit(1);
                return null;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

