/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import metal.shared.MMath;
import metal.shared.MPoint;

public class MPolar {
    double bearing;
    double distance;

    public MPolar(double bearing, double distance) {
        this.bearing = bearing;
        this.distance = distance;
    }

    public MPolar() {
    }

    public static MPoint getPoint(MPoint origin, double bearing, double distance) {
        double x = origin.getX() + distance * MMath.sin(bearing);
        double y = origin.getY() + distance * MMath.cos(bearing);
        return new MPoint(x, y);
    }

    public static MPolar getPolar(MPoint origin, MPoint object) {
        double distance = object.distance(origin);
        if (distance == 0.0) {
            return new MPolar(0.0, 0.0);
        }
        double dx = object.getX() - origin.getX();
        double dy = object.getY() - origin.getY();
        double bearing = MMath.acos(dy / distance);
        if (dx < 0.0) {
            bearing = 360.0 - bearing;
        }
        return new MPolar(bearing, distance);
    }
}

