/*
 * Decompiled with CFR 0.152.
 */
package demetrix.nano;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class SledgeHammer
extends AdvancedRobot {
    public void run() {
        this.setColors(new Color(96, 128, 160), null, Color.orange);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double enemyAbsBearing = this.getHeadingRadians() + e.getBearingRadians();
        int n = 0;
        if (e.getDistance() < 200.0) {
            n = 1;
        }
        double bulletPower = n + 2;
        int direction = Math.cos(e.getBearingRadians()) >= 0.0 ? 1 : -1;
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(enemyAbsBearing + Math.asin(e.getVelocity() / 8.0 * Math.sin(Math.PI - (e.getHeadingRadians() - enemyAbsBearing))) * 0.5 - this.getHeadingRadians() - (double)((direction - 1) / 2) * Math.PI)));
        this.setMaxVelocity(Math.abs(this.getTurnRemaining()) > 40.0 ? 0.0 : 8.0);
        this.setAhead((double)direction * 120.0);
        this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsBearing + Math.asin(e.getVelocity() / (20.0 - (double)3 * bulletPower) * Math.sin(Math.PI - (e.getHeadingRadians() - enemyAbsBearing))) - this.getGunHeadingRadians())));
        this.setFire(bulletPower);
    }
}

