/*
 * Decompiled with CFR 0.152.
 */
package oog.micro;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class MagicD3
extends AdvancedRobot {
    static final double BULLET_POWER = 2.0;
    static final double BULLET_SPEED = 14.0;
    static final double DIR_CHANCE = 0.375;
    static final double BEST_DIST = 200.0;
    static final double APPROACH = 600.0;
    static final Rectangle2D.Double fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    static double enemyEnergy;
    static int dir;
    static int deaths;
    static ArrayList<wave> waves;
    static ArrayList<wave> firingAngles;

    static {
        firingAngles = new ArrayList();
    }

    public void run() {
        dir = 1;
        waves = new ArrayList();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        wave w = new wave();
        double dist = e.getDistance();
        double absBearing = e.getBearingRadians();
        this.setTurnRightRadians(Math.cos(absBearing) + (double)dir * (200.0 - e.getDistance()) / 600.0);
        Point2D.Double ePos = this.project(e.getDistance(), absBearing += this.getHeadingRadians());
        double d2 = enemyEnergy;
        enemyEnergy = e.getEnergy();
        double adSeg = d2 - enemyEnergy;
        if (d >= 0.1 && adSeg <= 3.0 && deaths != 0) {
            if (Math.random() > 0.5 || deaths == 1) {
                dir = -dir;
            }
            this.setAhead(1000 * dir);
            this.setMaxVelocity(8.0 * Math.random() + 2.0);
        }
        if (!fieldRect.contains(this.project(100 * dir, this.getHeadingRadians()))) {
            dir = -dir;
            this.setAhead(1000 * dir);
            this.setMaxVelocity(8.0);
        }
        adSeg = e.getVelocity() * Math.cos(e.getHeadingRadians() - absBearing);
        double velSeg = e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing);
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        if (this.getGunHeat() == 0.0) {
            w.startTime = this.getTime();
            w.velSeg = velSeg;
            w.startPos = new Point2D.Double(this.getX(), this.getY());
            w.startBearing = absBearing;
            w.distSeg = dist;
            w.adSeg = adSeg;
            waves.add(w);
        }
        if (deaths == 0) {
            this.setAhead(1000 * dir);
            this.setMaxVelocity(750.0 / dist);
        }
        int i = 0;
        while (i < waves.size()) {
            w = waves.get(i);
            if (((double)this.getTime() - w.startTime) * 14.0 >= Point2D.distance(ePos.x, ePos.y, w.startPos.x, w.startPos.y)) {
                w.angle = Utils.normalRelativeAngle((double)Utils.normalAbsoluteAngle((double)(Math.atan2(ePos.x - w.startPos.x, ePos.y - w.startPos.y) - w.startBearing)));
                firingAngles.add(w);
                waves.remove(w);
            }
            ++i;
        }
        double aim = 0.0;
        double maxMatch = Double.POSITIVE_INFINITY;
        i = 0;
        while (i < firingAngles.size()) {
            w = firingAngles.get(i);
            dist = 2.0 * Math.pow(velSeg - w.velSeg, 2.0) + Math.pow(adSeg - w.adSeg, 2.0) + Math.pow((w.distSeg - e.getDistance()) / 200.0, 2.0);
            if (dist < maxMatch) {
                maxMatch = dist;
                aim = w.angle;
            }
            ++i;
        }
        this.setFire(e.getDistance() < 100.0 ? 3.0 : 2.0);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians())) + aim);
    }

    public void onDeath(DeathEvent e) {
        ++deaths;
    }

    public Point2D.Double project(double dist, double angle) {
        return new Point2D.Double(this.getX() + dist * Math.sin(angle), this.getY() + dist * Math.cos(angle));
    }

    public static class wave {
        Point2D.Double startPos;
        double startBearing;
        double velSeg;
        double angle;
        double distSeg;
        double startTime;
        double adSeg;
    }
}

