/*
 * Decompiled with CFR 0.152.
 */
package tw;

import java.awt.geom.Point2D;
import robocode.util.Utils;

public class OurWave {
    private double _startX;
    private double _startY;
    private double _startBearing;
    private double _power;
    private long _fireTime;
    private int _direction;
    private int[] _returnSegment;

    public OurWave(double x, double y, double bearing, double power, int direction, long time, int[] segment) {
        this._startX = x;
        this._startY = y;
        this._startBearing = bearing;
        this._power = power;
        this._direction = direction;
        this._fireTime = time;
        this._returnSegment = segment;
    }

    public double getBulletSpeed() {
        return 20.0 - this._power * 3.0;
    }

    public double maxEscapeAngle() {
        return Math.asin(8.0 / this.getBulletSpeed());
    }

    public boolean checkHit(double enemyX, double enemyY, long currentTime) {
        if (Point2D.distance(this._startX, this._startY, enemyX, enemyY) <= (double)(currentTime - this._fireTime) * this.getBulletSpeed()) {
            int index;
            double desiredDirection = Math.atan2(enemyX - this._startX, enemyY - this._startY);
            double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - this._startBearing));
            double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / this.maxEscapeAngle())) * (double)this._direction;
            int n = index = (int)Math.round((double)((this._returnSegment.length - 1) / 2) * (guessFactor + 1.0));
            this._returnSegment[n] = this._returnSegment[n] + 1;
            return true;
        }
        return false;
    }
}

