/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import robocode.ScannedRobotEvent;
import tcf.Bot;
import tcf.SimBot;

class HistoryBot
implements Bot {
    public static final int N_PAST = 50;
    SimBot[] m_past = new SimBot[50];

    HistoryBot() {
        for (int i = 0; i < 50; ++i) {
            this.m_past[i] = new SimBot();
        }
    }

    HistoryBot(HistoryBot historyBot) {
        for (int i = 0; i < 50; ++i) {
            this.m_past[i] = new SimBot(historyBot.m_past[i]);
        }
    }

    void initHistory(ScannedRobotEvent scannedRobotEvent, Bot bot) {
        for (int i = 0; i < 50; ++i) {
            this.m_past[i].copyFrom(scannedRobotEvent, bot);
        }
    }

    public String name() {
        return this.m_past[0].m_name;
    }

    public long time() {
        return this.m_past[0].m_time;
    }

    public boolean isDead() {
        return false;
    }

    public double x() {
        return this.m_past[0].m_x;
    }

    public double y() {
        return this.m_past[0].m_y;
    }

    public double speed() {
        return this.m_past[0].m_speed;
    }

    public double heading() {
        return this.m_past[0].m_heading;
    }

    private void rotatePastBots() {
        SimBot simBot = this.m_past[49];
        for (int i = 48; i >= 0; --i) {
            this.m_past[i + 1] = this.m_past[i];
        }
        this.m_past[0] = simBot;
    }

    void update(Bot bot) {
        this.rotatePastBots();
        this.m_past[0].copyFrom(bot);
    }

    void update(ScannedRobotEvent scannedRobotEvent, Bot bot) {
        this.rotatePastBots();
        this.m_past[0].copyFrom(scannedRobotEvent, bot);
    }

    void update(String string, long l, double d, double d2, double d3, double d4) {
        this.rotatePastBots();
        this.m_past[0].init(string, l, d, d2, d3, d4);
    }

    Bot past() {
        return this.m_past[1];
    }

    Bot past(int n) {
        return this.m_past[n];
    }
}

