/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.moves.MeleeMove;

import gre.svman4.LeonidasInfo;
import gre.svman4.useful.FieldPoint;
import gre.svman4.useful.Force;
import gre.svman4.useful.RobotState;
import java.awt.Color;

public class LastPointForce
extends Force {
    public double[] calculate(RobotState mineRobot, FieldPoint[] fieldPoints, int saveInfo) {
        double xForce = 0.0;
        double yForce = 0.0;
        int index = 0;
        while (index < fieldPoints.length) {
            FieldPoint point = fieldPoints[index];
            double angle = mineRobot.getAngleTo(point);
            double distanceSq = mineRobot.distanceSq(point);
            double dampingParameter = 1.0 / Math.pow(LeonidasInfo.LAST_POINT_FORCE_DAMPING_FACTOR + Double.MIN_NORMAL, index);
            xForce += -Math.sin(angle) / (distanceSq + 1.0) * dampingParameter;
            yForce += -Math.cos(angle) / (distanceSq + 1.0) * dampingParameter;
            ++index;
        }
        if (saveInfo == 1) {
            this.setX(xForce);
            this.setY(yForce);
        }
        return new double[]{xForce, yForce};
    }

    @Override
    public Color getColor() {
        return Color.magenta;
    }

    @Override
    protected String getName() {
        return "LastPointForce";
    }
}

