/*
 * Decompiled with CFR 0.152.
 */
package oog.melee;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Mercutio
extends AdvancedRobot {
    static Rectangle2D.Double fieldRect;
    static double enemyDist;
    static String enemyName;
    static double eEnergy;
    static Point2D.Double[] ePos;
    static int enemyCount;
    static Point2D.Double[][] myPos;

    static {
        ePos = new Point2D.Double[9];
    }

    public void run() {
        fieldRect = new Rectangle2D.Double(50.0, 50.0, this.getBattleFieldWidth() - 100.0, this.getBattleFieldHeight() - 100.0);
        myPos = new Point2D.Double[50000][2];
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.white, Color.gray, Color.red);
        enemyDist = Double.POSITIVE_INFINITY;
        while (true) {
            Point2D.Double myPosition;
            Mercutio.myPos[(int)this.getTime()][0] = myPosition = new Point2D.Double(this.getX(), this.getY());
            Mercutio.myPos[(int)this.getTime()][1] = this.project(myPosition, enemyDist / 20.0 * this.getVelocity(), this.getHeadingRadians());
            if (this.getGunHeat() >= 1.0 || Mercutio.bulletPower() <= 1.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            try {
                double bestRating = Double.POSITIVE_INFINITY;
                double moveAngle = 0.0;
                while (moveAngle < Math.PI * 2) {
                    double rating = 0.0;
                    Point2D.Double movePoint = this.project(myPosition, 36.0, moveAngle);
                    int i = 0;
                    while (i < this.getOthers()) {
                        rating += 3.0 / Math.pow(ePos[i].distance(movePoint), 2.0);
                        ++i;
                    }
                    rating += 2.0 / Math.pow(movePoint.distance(myPos[(int)Math.max(0.0, (double)this.getTime() - enemyDist / 20.0)][0]), 2.0);
                    rating += 3.0 / Math.pow(movePoint.distance(myPos[(int)Math.max(0.0, (double)this.getTime() - enemyDist / 20.0)][1]), 2.0);
                    if ((rating += 5.0 / Math.pow(movePoint.distance(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0), 2.0)) < bestRating && fieldRect.contains(movePoint)) {
                        bestRating = rating;
                        int pointDir = Math.abs(moveAngle - this.getHeadingRadians()) < 1.5707963267948966 ? 1 : -1;
                        this.setAhead(1000 * pointDir);
                        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(moveAngle + (pointDir == -1 ? Math.PI : 0.0) - this.getHeadingRadians())));
                    }
                    moveAngle += 0.19634954084936207;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.setMaxVelocity(400.0 / this.getTurnRemaining());
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        Mercutio.ePos[Mercutio.enemyCount++] = this.project(new Point2D.Double(this.getX(), this.getY()), e.getDistance(), absBearing);
        if (e.getDistance() < enemyDist || e.getName() == enemyName) {
            enemyDist = e.getDistance();
            enemyName = e.getName();
            eEnergy = e.getEnergy();
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians())) + Math.min(1.0, 400.0 / e.getDistance()) * (e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing) / (20.0 - 3.0 * Mercutio.bulletPower())));
            this.setFire(Mercutio.bulletPower());
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        }
        if (enemyCount >= this.getOthers()) {
            enemyCount = 0;
        }
    }

    Point2D.Double project(Point2D.Double origin, double dist, double angle) {
        return new Point2D.Double(origin.x + dist * Math.sin(angle), origin.y + dist * Math.cos(angle));
    }

    public void onRobotDeath(RobotDeathEvent e) {
        enemyDist = Double.POSITIVE_INFINITY;
    }

    public static double bulletPower() {
        return Math.min(3.0, Math.max(0.1, Math.min(eEnergy / 3.0, 500.0 / enemyDist)));
    }
}

