/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import java.util.ArrayList;
import starpkg.EnemyType;
import starpkg.HelperTools;
import starpkg.Position;

public class EnemyData {
    public String name = "";
    public double bearing_deg = 0.0;
    public double heading_deg = 0.0;
    public double heading_rad = 0.0;
    public long lastTime = 0L;
    public double velocity = 0.0;
    public double realSpeed = 0.0;
    public double life = 100.0;
    public boolean alive = true;
    public double headingTurn = 0.0;
    public double headingTurnSpeed = 0.0;
    public double distance = 10000.0;
    public Position pos = new Position();
    private HelperTools tools = new HelperTools();
    private Position lastRealSpeedPos = new Position();
    private long lastRealSpeedTime = 0L;
    public int missedCounter = 0;
    public int hitCounter = 0;
    public EnemyType type = new EnemyType();
    public int id = -1;
    public ArrayList moveRecList = new ArrayList();
    public final int MAX_AVESPEED_ARRAY = 10;
    public int aveSpeedPtr = 0;
    public double averageSpeed = 0.0;
    public double averageSpeedHalf = 0.0;
    public double averageRealSpeed = 0.0;
    public double[] aveSpeedArray = new double[10];
    public boolean aveSpeedArryFull = false;

    public EnemyData() {
        this.Reset();
    }

    public void Reset() {
        this.distance = 10000.0;
        this.heading_deg = 0.0;
        this.lastTime = 0L;
        this.velocity = 0.0;
        this.realSpeed = 0.0;
        this.life = 100.0;
        this.headingTurn = 0.0;
        this.headingTurnSpeed = 0.0;
        this.missedCounter = 0;
        this.hitCounter = 0;
        int i = 0;
        while (i < 10) {
            this.aveSpeedArray[i] = 0.0;
            ++i;
        }
        this.aveSpeedPtr = 0;
        this.averageSpeed = 0.0;
        this.alive = true;
    }

    public void Update(String cName, long cTime, double cHeading, double cHeadingRad, double cVelocity, double cDistance, double cLife, double cBearing, Position cPos) {
        if (cName != this.name) {
            this.Reset();
            this.lastRealSpeedPos = cPos;
        }
        this.name = cName;
        double headingAngle = this.pos.DegreeTo(cPos);
        if (headingAngle < 0.0) {
            headingAngle += 360.0;
        }
        if ((headingAngle = Math.abs(cHeading - headingAngle)) > 90.0 && headingAngle < 270.0) {
            headingAngle = cHeading + 180.0;
            if (headingAngle >= 360.0) {
                headingAngle -= 360.0;
            }
        } else {
            headingAngle = cHeading;
        }
        this.heading_deg = headingAngle;
        this.headingTurnSpeed = this.tools.NormaliseBearing(cHeadingRad - this.heading_rad) / (double)(cTime - this.lastTime);
        this.heading_rad = cHeadingRad;
        this.velocity = cVelocity;
        if (this.realSpeed == 0.0) {
            this.realSpeed = cPos.Distance(this.pos) / (double)(cTime - this.lastTime);
            this.lastRealSpeedPos = new Position(cPos);
            this.lastRealSpeedTime = cTime;
        } else if (cTime - this.lastRealSpeedTime >= 5L) {
            this.realSpeed = cPos.Distance(this.lastRealSpeedPos) / (double)(cTime - this.lastRealSpeedTime);
            this.lastRealSpeedPos = new Position(cPos);
            this.lastRealSpeedTime = cTime;
            this.SetAverageSpeed(this.realSpeed);
        }
        this.lastTime = cTime;
        this.distance = cDistance;
        this.life = cLife;
        this.pos = new Position(cPos);
        this.bearing_deg = cBearing;
    }

    public void SetAverageSpeed(double speed) {
        this.aveSpeedArray[this.aveSpeedPtr] = speed;
        ++this.aveSpeedPtr;
        if (this.aveSpeedPtr >= 10) {
            this.aveSpeedPtr = 0;
            this.aveSpeedArryFull = true;
        }
        if (this.aveSpeedArryFull) {
            double totalSpeed = 0.0;
            int i = 0;
            while (i < 10) {
                totalSpeed += this.aveSpeedArray[i];
                ++i;
            }
            this.averageSpeed = totalSpeed / 10.0;
            totalSpeed = 0.0;
            int tmpPtr = this.aveSpeedPtr;
            int i2 = 0;
            while (i2 < 5) {
                totalSpeed += this.aveSpeedArray[tmpPtr];
                if (--tmpPtr < 0) {
                    tmpPtr = 9;
                }
                ++i2;
            }
            this.averageSpeedHalf = totalSpeed / 5.0;
            totalSpeed = 0.0;
            tmpPtr = this.aveSpeedPtr;
            int i3 = 0;
            while (i3 < 3) {
                totalSpeed += this.aveSpeedArray[tmpPtr];
                if (--tmpPtr < 0) {
                    tmpPtr = 9;
                }
                ++i3;
            }
            this.averageRealSpeed = totalSpeed / 3.0;
        } else {
            this.averageSpeed = this.realSpeed;
            this.averageSpeedHalf = this.realSpeed;
        }
    }

    public void AddHitBullet(int btype, int totalEnemy) {
        ++this.hitCounter;
        if (totalEnemy > 1) {
            if (btype == 1) {
                ++this.type.count_gf_Linear.hit;
                this.type.hitPer_gf_Linear = (int)((double)this.type.count_gf_Linear.hit / (double)this.type.count_gf_Linear.total * 100.0);
            } else if (btype == 2) {
                ++this.type.count_gf_Circular.hit;
                this.type.hitPer_gf_Circular = (int)((double)this.type.count_gf_Circular.hit / (double)this.type.count_gf_Circular.total * 100.0);
            } else if (btype == 4) {
                ++this.type.count_gf_Jiggling.hit;
                this.type.hitPer_gf_Jiggling = (int)((double)this.type.count_gf_Jiggling.hit / (double)this.type.count_gf_Jiggling.total * 100.0);
            } else if (btype == 8) {
                ++this.type.count_gf_JigglingForward.hit;
                this.type.hitPer_gf_JigglingForward = (int)((double)this.type.count_gf_JigglingForward.hit / (double)this.type.count_gf_JigglingForward.total * 100.0);
            } else if (btype == 256) {
                ++this.type.count_gf_Direct.hit;
                this.type.hitPer_gf_Direct = (int)((double)this.type.count_gf_Direct.hit / (double)this.type.count_gf_Direct.total * 100.0);
            } else if (btype == 128) {
                ++this.type.count_gf_RightAngle.hit;
                this.type.hitPer_gf_RightAngle = (int)((double)this.type.count_gf_RightAngle.hit / (double)this.type.count_gf_RightAngle.total * 100.0);
            }
        } else if (btype == 1) {
            ++this.type.count_1v1_Linear.hit;
            this.type.hitPer_1v1_Linear = (int)((double)this.type.count_1v1_Linear.hit / (double)this.type.count_1v1_Linear.total * 100.0);
        } else if (btype == 2) {
            ++this.type.count_1v1_Circular.hit;
            this.type.hitPer_1v1_Circular = (int)((double)this.type.count_1v1_Circular.hit / (double)this.type.count_1v1_Circular.total * 100.0);
        } else if (btype == 4) {
            ++this.type.count_1v1_Jiggling.hit;
            this.type.hitPer_1v1_Jiggling = (int)((double)this.type.count_1v1_Jiggling.hit / (double)this.type.count_1v1_Jiggling.total * 100.0);
        } else if (btype == 8) {
            ++this.type.count_1v1_JigglingForward.hit;
            this.type.hitPer_1v1_JigglingForward = (int)((double)this.type.count_1v1_JigglingForward.hit / (double)this.type.count_1v1_JigglingForward.total * 100.0);
        } else if (btype == 256) {
            ++this.type.count_1v1_Direct.hit;
            this.type.hitPer_1v1_Direct = (int)((double)this.type.count_1v1_Direct.hit / (double)this.type.count_1v1_Direct.total * 100.0);
        } else if (btype == 128) {
            ++this.type.count_1v1_RightAngle.hit;
            this.type.hitPer_1v1_RightAngle = (int)((double)this.type.count_1v1_RightAngle.hit / (double)this.type.count_1v1_RightAngle.total * 100.0);
        }
        ++this.hitCounter;
    }

    public void AddMissedBullet() {
        ++this.missedCounter;
        if (this.alive) {
            this.CalHitPercentage();
        }
    }

    public void CalHitPercentage() {
        if (this.type.count_1v1_Linear.total > 0) {
            this.type.hitPer_1v1_Linear = (int)((double)this.type.count_1v1_Linear.hit / (double)this.type.count_1v1_Linear.total * 100.0);
        }
        if (this.type.count_1v1_Circular.total > 0) {
            this.type.hitPer_1v1_Circular = (int)((double)this.type.count_1v1_Circular.hit / (double)this.type.count_1v1_Circular.total * 100.0);
        }
        if (this.type.count_1v1_Jiggling.total > 0) {
            this.type.hitPer_1v1_Jiggling = (int)((double)this.type.count_1v1_Jiggling.hit / (double)this.type.count_1v1_Jiggling.total * 100.0);
        }
        if (this.type.count_1v1_JigglingForward.total > 0) {
            this.type.hitPer_1v1_JigglingForward = (int)((double)this.type.count_1v1_JigglingForward.hit / (double)this.type.count_1v1_JigglingForward.total * 100.0);
        }
        if (this.type.count_1v1_Direct.total > 0) {
            this.type.hitPer_1v1_Direct = (int)((double)this.type.count_1v1_Direct.hit / (double)this.type.count_1v1_Direct.total * 100.0);
        }
        if (this.type.count_1v1_RightAngle.total > 0) {
            this.type.hitPer_1v1_RightAngle = (int)((double)this.type.count_1v1_RightAngle.hit / (double)this.type.count_1v1_RightAngle.total * 100.0);
        }
        if (this.type.count_gf_Linear.total > 0) {
            this.type.hitPer_gf_Linear = (int)((double)this.type.count_gf_Linear.hit / (double)this.type.count_gf_Linear.total * 100.0);
        }
        if (this.type.count_gf_Circular.total > 0) {
            this.type.hitPer_gf_Circular = (int)((double)this.type.count_gf_Circular.hit / (double)this.type.count_gf_Circular.total * 100.0);
        }
        if (this.type.count_gf_Jiggling.total > 0) {
            this.type.hitPer_gf_Jiggling = (int)((double)this.type.count_gf_Jiggling.hit / (double)this.type.count_gf_Jiggling.total * 100.0);
        }
        if (this.type.count_gf_JigglingForward.total > 0) {
            this.type.hitPer_gf_JigglingForward = (int)((double)this.type.count_gf_JigglingForward.hit / (double)this.type.count_gf_JigglingForward.total * 100.0);
        }
        if (this.type.count_gf_Direct.total > 0) {
            this.type.hitPer_gf_Direct = (int)((double)this.type.count_gf_Direct.hit / (double)this.type.count_gf_Direct.total * 100.0);
        }
        if (this.type.count_gf_RightAngle.total > 0) {
            this.type.hitPer_gf_RightAngle = (int)((double)this.type.count_gf_RightAngle.hit / (double)this.type.count_gf_RightAngle.total * 100.0);
        }
    }

    public void FireMe(int btype, int totalEnemy) {
        if (totalEnemy > 1) {
            if (btype == 1) {
                ++this.type.count_gf_Linear.total;
            } else if (btype == 2) {
                ++this.type.count_gf_Circular.total;
            } else if (btype == 4) {
                ++this.type.count_gf_Jiggling.total;
            } else if (btype == 8) {
                ++this.type.count_gf_JigglingForward.total;
            } else if (btype == 256) {
                ++this.type.count_gf_Direct.total;
            } else if (btype == 128) {
                ++this.type.count_gf_RightAngle.total;
            }
        } else if (btype == 1) {
            ++this.type.count_1v1_Linear.total;
        } else if (btype == 2) {
            ++this.type.count_1v1_Circular.total;
        } else if (btype == 4) {
            ++this.type.count_1v1_Jiggling.total;
        } else if (btype == 8) {
            ++this.type.count_1v1_JigglingForward.total;
        } else if (btype == 256) {
            ++this.type.count_1v1_Direct.total;
        } else if (btype == 128) {
            ++this.type.count_1v1_RightAngle.total;
        }
    }

    public void CalTotalHitPercentage() {
        if (this.type.count_1v1_Linear.total > 0) {
            if (this.type.hitPer_1v1_Linear_o < 0) {
                this.type.hitPer_1v1_Linear_o = this.type.hitPer_1v1_Linear;
            }
            this.type.hitPer_1v1_Linear_o = (int)(((double)this.type.hitPer_1v1_Linear_o + (double)this.type.hitPer_1v1_Linear) / 2.0);
        }
        if (this.type.count_1v1_Circular.total > 0) {
            if (this.type.hitPer_1v1_Circular_o < 0) {
                this.type.hitPer_1v1_Circular_o = this.type.hitPer_1v1_Circular;
            }
            this.type.hitPer_1v1_Circular_o = (int)(((double)this.type.hitPer_1v1_Circular_o + (double)this.type.hitPer_1v1_Circular) / 2.0);
        }
        if (this.type.count_1v1_Jiggling.total > 0) {
            if (this.type.hitPer_1v1_Jiggling_o < 0) {
                this.type.hitPer_1v1_Jiggling_o = this.type.hitPer_1v1_Jiggling;
            }
            this.type.hitPer_1v1_Jiggling_o = (int)(((double)this.type.hitPer_1v1_Jiggling_o + (double)this.type.hitPer_1v1_Jiggling) / 2.0);
        }
        if (this.type.count_1v1_JigglingForward.total > 0) {
            if (this.type.hitPer_1v1_JigglingForward_o < 0) {
                this.type.hitPer_1v1_JigglingForward_o = this.type.hitPer_1v1_JigglingForward;
            }
            this.type.hitPer_1v1_JigglingForward_o = (int)(((double)this.type.hitPer_1v1_JigglingForward_o + (double)this.type.hitPer_1v1_JigglingForward) / 2.0);
        }
        if (this.type.count_1v1_Direct.total > 0) {
            if (this.type.hitPer_1v1_Direct_o < 0) {
                this.type.hitPer_1v1_Direct_o = this.type.hitPer_1v1_Direct;
            }
            this.type.hitPer_1v1_Direct_o = (int)(((double)this.type.hitPer_1v1_Direct_o + (double)this.type.hitPer_1v1_Direct) / 2.0);
        }
        if (this.type.count_1v1_RightAngle.total < 0) {
            if (this.type.hitPer_1v1_RightAngle_o == -1) {
                this.type.hitPer_1v1_RightAngle_o = this.type.hitPer_1v1_RightAngle;
            }
            this.type.hitPer_1v1_RightAngle_o = (int)(((double)this.type.hitPer_1v1_RightAngle_o + (double)this.type.hitPer_1v1_RightAngle) / 2.0);
        }
    }

    public void CheckErrorLog() {
        int errCount = 0;
        if (this.type.hitPer_1v1_Linear_o >= 0 && this.type.hitPer_1v1_Linear_o <= 10) {
            ++errCount;
        }
        if (this.type.hitPer_1v1_Circular_o >= 0 && this.type.hitPer_1v1_Circular_o <= 10) {
            ++errCount;
        }
        if (this.type.hitPer_1v1_Jiggling_o >= 0 && this.type.hitPer_1v1_Jiggling_o <= 10) {
            ++errCount;
        }
        if (this.type.hitPer_1v1_JigglingForward_o >= 0 && this.type.hitPer_1v1_JigglingForward_o <= 10) {
            ++errCount;
        }
        if (this.type.hitPer_1v1_Direct_o >= 0 && this.type.hitPer_1v1_Direct_o <= 10) {
            ++errCount;
        }
        if (this.type.hitPer_1v1_RightAngle_o >= 0 && this.type.hitPer_1v1_RightAngle_o <= 10) {
            ++errCount;
        }
        if (errCount >= 5) {
            this.type.Reset();
        }
    }

    public void CalTypeResult() {
    }

    private class HitBullet {
        public int bType = 0;
    }
}

