/*
 * Decompiled with CFR 0.152.
 */
package kid.movement.gun;

import java.awt.geom.Point2D;
import kid.info.GunInfo;
import kid.robot.RobotData;
import kid.targeting.Targeting;
import robocode.AdvancedRobot;
import robocode.Robot;

public class GunMovement {
    private Robot robot;
    private AdvancedRobot advancedRobot;
    private GunInfo info;

    public GunMovement(Robot myRobot) {
        this.init(myRobot);
    }

    private void init(Robot myRobot) {
        this.robot = myRobot;
        if (this.robot instanceof AdvancedRobot) {
            this.advancedRobot = (AdvancedRobot)this.robot;
        }
        this.info = new GunInfo(myRobot);
    }

    public void right(double a) {
        this.robot.turnGunRight(a);
    }

    public void setRight(double a) {
        if (this.advancedRobot != null) {
            this.advancedRobot.setTurnGunRight(a);
        }
    }

    public void left(double a) {
        this.robot.turnGunLeft(a);
    }

    public void setLeft(double a) {
        if (this.advancedRobot != null) {
            this.advancedRobot.setTurnGunLeft(a);
        }
    }

    public final void turnTo(double angle) {
        double theta = this.info.bearing(angle);
        this.right(theta);
    }

    public final void setTurnTo(double angle) {
        double theta = this.info.bearing(angle);
        this.setRight(theta);
    }

    public final void turnTo(double x, double y) {
        double theta = this.info.bearing(x, y);
        this.right(theta);
    }

    public final void setTurnTo(double x, double y) {
        double theta = this.info.bearing(x, y);
        this.setRight(theta);
    }

    public final void turnTo(Point2D point) {
        double theta = this.info.bearing(point);
        this.right(theta);
    }

    public final void setTurnTo(Point2D point) {
        double theta = this.info.bearing(point);
        this.setRight(theta);
    }

    public final void turnTo(RobotData robot) {
        if (robot != null && !robot.isDead()) {
            double theta = this.info.bearing(robot);
            this.right(theta);
        }
    }

    public final void setTurnTo(RobotData robot) {
        if (robot != null && !robot.isDead()) {
            double theta = this.info.bearing(robot);
            this.setRight(theta);
        }
    }

    public final void turnTo(Targeting targeting, RobotData robot, double firePower) {
        if (robot != null && !robot.isDead() && targeting != null) {
            this.turnTo(targeting.getAngle(robot, firePower));
        }
    }

    public final void setTurnTo(Targeting targeting, RobotData robot, double firePower) {
        if (robot != null && !robot.isDead() && targeting != null) {
            this.setTurnTo(targeting.getAngle(robot, firePower));
        }
    }
}

