/*
 * Decompiled with CFR 0.152.
 */
package mue;

import mue.Knowledge;
import mue.Movement;
import mue.RobotData;
import mue.Util;
import robocode.AdvancedRobot;

abstract class MovementBase
implements Movement {
    private AdvancedRobot robot;
    private Knowledge knowledge;

    public MovementBase(AdvancedRobot advancedRobot, Knowledge knowledge) {
        this.robot = advancedRobot;
        this.knowledge = knowledge;
    }

    protected final Knowledge getKnowledge() {
        return this.knowledge;
    }

    protected double setTurn(double d) {
        double d2 = Util.relativeAngle(this.robot.getHeading(), d);
        this.robot.setTurnRight(d2);
        double d3 = 0.75 * Math.abs(this.robot.getVelocity());
        if (d2 > 10.0 - d3) {
            d2 -= 10.0 - d3;
        }
        if (d2 < -10.0 + d3) {
            d2 += -10.0 + d3;
        }
        return d2;
    }

    protected final void setTurnRight(double d) {
        this.robot.setTurnRight(d);
    }

    protected final void setTurnLeft(double d) {
        this.robot.setTurnLeft(d);
    }

    protected final void setAhead(double d) {
        this.robot.setAhead(d);
    }

    protected final void setBack(double d) {
        this.robot.setBack(d);
    }

    protected final double getVelocity() {
        return this.robot.getVelocity();
    }

    protected final double getHeading() {
        return this.robot.getHeading();
    }

    protected final double getX() {
        return this.robot.getX();
    }

    protected final double getY() {
        return this.robot.getY();
    }

    protected final long getTime() {
        return this.robot.getTime();
    }

    protected final double getBattleFieldHeight() {
        return this.robot.getBattleFieldHeight();
    }

    protected final double getBattleFieldWidth() {
        return this.robot.getBattleFieldWidth();
    }

    protected final double getTurnRemaining() {
        return this.robot.getTurnRemaining();
    }

    protected final double getDistanceRemaining() {
        return this.robot.getDistanceRemaining();
    }

    protected double getNextHeading() {
        double d;
        double d2 = this.robot.getTurnRemaining();
        if (d2 > 10.0 - (d = 0.75 * Math.abs(this.robot.getVelocity()))) {
            d2 = 10.0 - d;
        }
        if (d2 < -10.0 + d) {
            d2 = -10.0 + d;
        }
        return this.robot.getHeading() + d2;
    }

    protected final boolean isInsideField(double d, double d2) {
        return d >= 18.0 && d2 >= 18.0 && d <= this.robot.getBattleFieldWidth() - 18.0 && d2 <= this.robot.getBattleFieldHeight() - 18.0;
    }

    protected final double directionTo(RobotData robotData) {
        return Util.direction(this.robot.getX(), this.robot.getY(), robotData.getX(), robotData.getY());
    }

    protected final double directionTo(double d, double d2) {
        return Util.direction(this.robot.getX(), this.robot.getY(), d, d2);
    }

    protected final double distanceTo(double d, double d2) {
        return Util.distance(this.robot.getX(), this.robot.getY(), d, d2);
    }

    protected final double distanceToWall(double d) {
        return Math.min(this.xDistanceToWall(this.robot.getX(), d), this.yDistanceToWall(this.robot.getY(), d));
    }

    protected final double xDistanceToWall(double d, double d2) {
        if ((d2 = Util.relativeAngle(0.0, d2)) > 0.0 && d2 < 180.0) {
            return (this.robot.getBattleFieldWidth() - 18.0 - d) / Math.sin(Math.toRadians(d2));
        }
        if (d2 < 0.0 && d2 > -180.0) {
            return (18.0 - d) / Math.sin(Math.toRadians(d2));
        }
        return this.robot.getBattleFieldWidth();
    }

    protected final double yDistanceToWall(double d, double d2) {
        if ((d2 = Util.relativeAngle(0.0, d2)) > -90.0 && d2 < 90.0) {
            return (this.robot.getBattleFieldHeight() - 18.0 - d) / Math.cos(Math.toRadians(d2));
        }
        if (d2 < -90.0 || d2 > 90.0) {
            return (18.0 - d) / Math.cos(Math.toRadians(d2));
        }
        return this.robot.getBattleFieldHeight();
    }
}

