/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns;

import rdt.Wraith.Guns.FiringData;
import rdt.Wraith.Guns.Gun;
import rdt.Wraith.IRobot;
import rdt.Wraith.MEA.MEA;
import rdt.Wraith.Utils.FastMoveInterceptLookup;
import rdt.Wraith.Utils.FastOutsideOfBattlefield;
import rdt.Wraith.Utils.MathUtils;

public final class FiringSolution {
    public double AbsoluteAngle;
    public double GunWeighting;
    public double InterceptWeight;
    public double DistanceWeight;
    public double MEAWeight;
    public Gun Gun;
    public double FinalWeight;
    public boolean Valid = false;

    public void SetExtendedWeights(FiringData firingData, IRobot robot, FastOutsideOfBattlefield outsideOfBattlefield, MEA mea) {
        double currentTargetX = firingData.TargetAtFiringTick.LocationX;
        double currentTargetY = firingData.TargetAtFiringTick.LocationY;
        double currentTargetAbsHeading = firingData.TargetAtFiringTick.AbsoluteHeadingAlongVelocityVector;
        double currentTargetAbsVelocity = firingData.TargetAtFiringTick.AbsoluteVelocity;
        double bulletVelocity = firingData.BulletVelocity;
        double bulletDX = MathUtils.FastSin(this.AbsoluteAngle) * bulletVelocity;
        double bulletDY = MathUtils.FastCos(this.AbsoluteAngle) * bulletVelocity;
        double currentBulletX = firingData.SourceX;
        double currentBulletY = firingData.SourceY;
        long totalTicksForBulletToGoOutsideBattlefield = 0L;
        long numTicksToFirstIntercept = -1L;
        while (true) {
            boolean interceptPossible;
            ++totalTicksForBulletToGoOutsideBattlefield;
            if (outsideOfBattlefield.Check(currentBulletX += bulletDX, currentBulletY += bulletDY) > 0.0) break;
            if (numTicksToFirstIntercept >= 0L || !(interceptPossible = FastMoveInterceptLookup.CanBeIntercepted(currentTargetX, currentTargetY, currentTargetAbsHeading, currentTargetAbsVelocity, currentBulletX, currentBulletY, totalTicksForBulletToGoOutsideBattlefield))) continue;
            numTicksToFirstIntercept = totalTicksForBulletToGoOutsideBattlefield;
        }
        this.InterceptWeight = numTicksToFirstIntercept >= 0L ? 1.0 : 0.0;
        double bulletDistanceTravelledX = currentBulletX - firingData.SourceX;
        double bulletDistanceTravelledY = currentBulletY - firingData.SourceY;
        double bulletDistanceTravelledSq = bulletDistanceTravelledX * bulletDistanceTravelledX + bulletDistanceTravelledY * bulletDistanceTravelledY;
        double targetDistanceSq = firingData.TargetAtFiringTick.DistanceToItsTarget * firingData.TargetAtFiringTick.DistanceToItsTarget;
        this.DistanceWeight = bulletDistanceTravelledSq >= targetDistanceSq ? 1.0 : Math.sqrt(bulletDistanceTravelledSq) / firingData.TargetAtFiringTick.DistanceToItsTarget;
    }
}

