/*
 * Decompiled with CFR 0.152.
 */
package ender;

import java.awt.geom.Point2D;

public class ScanStatus {
    public static final int SELF_LOCATION = 0;
    public static final int ENEMY_LOCATION = 1;
    public static final int SELF_HEADING = 2;
    public static final int ENEMY_HEADING = 3;
    public static final int ENEMY_BEARING = 4;
    public static final int ENEMY_DISTANCE = 5;
    public static final int SELF_ENERGY = 6;
    public static final int ENEMY_ENERGY = 7;
    public static final int SELF_VELOCITY = 8;
    public static final int ENEMY_VELOCITY = 9;
    public static final int TIME = 10;
    private Point2D.Double mSelfLocation;
    private Point2D.Double mEnemyLocation;
    private double mSelfHeading;
    private double mEnemyHeading;
    private double mEnemyBearing;
    private double mEnemyDistance;
    private double mSelfEnergy;
    private double mEnemyEnergy;
    private double mSelfVelocity;
    private double mEnemyVelocity;
    private long mTime;

    public ScanStatus(Point2D.Double selflocation, double selfheading, double enemyheading, double enemydistance, double enemybearing, double selfenergy, double enemyenergy, double selfvelocity, double enemyvelocity, long time) {
        this.mSelfLocation = selflocation;
        this.mEnemyLocation = new Point2D.Double(selflocation.x + enemydistance * Math.sin(selfheading + enemybearing), selflocation.y + enemydistance * Math.cos(selfheading + enemybearing));
        this.mSelfHeading = selfheading;
        this.mEnemyHeading = enemyheading;
        this.mEnemyDistance = enemydistance;
        this.mEnemyBearing = enemybearing;
        this.mSelfEnergy = selfenergy;
        this.mEnemyEnergy = enemyenergy;
        this.mSelfVelocity = selfvelocity;
        this.mEnemyVelocity = enemyvelocity;
        this.mTime = time;
    }

    public Point2D.Double getLocation(int attr) {
        Point2D.Double ret = null;
        switch (attr) {
            case 0: {
                ret = this.mSelfLocation;
                break;
            }
            case 1: {
                ret = this.mEnemyLocation;
            }
        }
        return ret;
    }

    public double getAttr(int attr) {
        switch (attr) {
            case 2: {
                return this.mSelfHeading;
            }
            case 3: {
                return this.mEnemyHeading;
            }
            case 4: {
                return this.mEnemyBearing;
            }
            case 5: {
                return this.mEnemyDistance;
            }
            case 6: {
                return this.mSelfEnergy;
            }
            case 7: {
                return this.mEnemyEnergy;
            }
            case 8: {
                return this.mSelfVelocity;
            }
            case 9: {
                return this.mEnemyVelocity;
            }
        }
        return -1.0;
    }

    public long getTime() {
        return this.mTime;
    }
}

