/*
 * Decompiled with CFR 0.152.
 */
package awl;

import java.awt.geom.Line2D;
import robocode.Rules;
import robocode.util.Utils;

class Wave {
    Line2D.Double Ray;
    double time;
    double Power;
    double OriginX;
    double OriginY;
    double Heading;
    int Gun;
    boolean Real;

    Wave() {
        this.Power = -1.0;
    }

    Wave(double originx, double originy, double power, double heading, int gun, boolean real) {
        this.OriginX = originx;
        this.OriginY = originy;
        this.Power = power;
        this.time = 0.0;
        this.Heading = Utils.normalAbsoluteAngle((double)heading);
        this.Ray = new Line2D.Double(originx, originy, originx + Math.sin(this.Heading) * 10000.0, originy + Math.cos(this.Heading) * 10000.0);
        this.Gun = gun;
        this.Real = real;
    }

    Wave(double originx, double originy, double power, double endx, double endy) {
        this(originx, originy, power, Math.atan2(endx - originx, endy - originy), 0, true);
    }

    Wave(double originx, double originy, double power) {
        this(originx, originy, power, -1.0, -1.0);
    }

    public void setOffset(double offset) {
        this.Heading += offset;
        this.Ray = new Line2D.Double(this.OriginX, this.OriginY, this.OriginX + Math.sin(this.Heading) * 10000.0, this.OriginY + Math.cos(this.Heading) * 10000.0);
    }

    public void tick() {
        this.time += 1.0;
    }

    public double getSpeed() {
        return Rules.getBulletSpeed((double)this.Power);
    }

    public double getPower() {
        return this.Power;
    }

    public double getOriginX() {
        return this.OriginX;
    }

    public double getOriginY() {
        return this.OriginY;
    }

    public double getRange() {
        return Rules.getBulletSpeed((double)this.Power) * this.time;
    }

    public double getHeading() {
        return Math.toDegrees(this.Heading);
    }

    public double getHeadingRadians() {
        return this.Heading;
    }

    public double getX() {
        return this.OriginX + Rules.getBulletSpeed((double)this.Power) * this.time * Math.sin(this.Heading);
    }

    public double getY() {
        return this.OriginY + Rules.getBulletSpeed((double)this.Power) * this.time * Math.cos(this.Heading);
    }

    public Line2D.Double getRay() {
        return this.Ray;
    }

    public int getDodge(double x, double y, int defaultValue) {
        int direction = this.Ray.relativeCCW(x, y);
        if (defaultValue == 0) {
            if (direction == 0) {
                return 1;
            }
            return direction;
        }
        return defaultValue;
    }

    public double getGuessFactor(double x, double y) {
        return Math.sqrt(Math.pow(this.getX() - x, 2.0) + Math.pow(this.getY() - y, 2.0)) / (8.0 * this.time) * (double)this.Ray.relativeCCW(x, y);
    }

    public boolean doesHit(double x, double y) {
        return this.Ray.intersects(x - 30.73, y - 30.73, 61.46, 61.46);
    }

    public int getGun() {
        return this.Gun;
    }

    public boolean isReal() {
        return this.Real;
    }
}

