/*
 * Decompiled with CFR 0.152.
 */
package dk.predict;

import dk.Base;
import dk.Enemy;
import dk.Histogram;
import dk.Point;
import dk.Util;
import dk.predict.Factors;
import dk.predict.Predictor;
import dk.predict.Tracer;

public class Random
extends Predictor {
    protected int bucketCount = 30;
    protected double possibleTravel = 100.0;
    protected int sampleMinimum = this.bucketCount * 10;
    protected double bucketSize;
    protected Histogram aimingOffset;

    public Random(Enemy enemy) {
        super(enemy);
        this.init();
    }

    protected void init() {
        this.bucketSize = this.possibleTravel / ((double)this.bucketCount / 2.0);
        this.aimingOffset = new Histogram(this.bucketCount);
    }

    public static Predictor.Factory factory() {
        return new Predictor.Factory(){

            public Predictor newInstance(Enemy e) {
                return new Random(e);
            }
        };
    }

    protected Point getEstimatedPosition(Point robotPosition, Point enemyPosition, long timeInterval) {
        int i = this.aimingOffset.getBestIndex();
        double percent = ((double)i - (double)this.bucketCount / 2.0) * this.bucketSize;
        double bearing = Util.bearing(robotPosition, enemyPosition);
        double normal = Util.normalizeHeading(bearing + 1.5707963267948966);
        double distance = percent / 100.0 * 8.0 * (double)timeInterval;
        Point p = Util.applyHeading(enemyPosition, normal, distance);
        return Util.clamp(p);
    }

    public Point getEstimatedPosition(Base robot, long time) {
        return this.getEstimatedPosition(robot.getPosition(), this.enemy_.getPosition(), time - this.enemy_.getLastSeen());
    }

    public double getGunTurnAngleToEnemy(Base robot, double power) {
        Point enemyEstimatedPosition = this.getEstimatedPosition(robot, robot.getTime());
        double estimatedDistance = Util.range(robot.getPosition(), enemyEstimatedPosition);
        int bulletTravelTime = Util.bulletTravelTime(estimatedDistance, power);
        enemyEstimatedPosition = this.enemy_.getEstimatedPosition(robot.getTime() + (long)bulletTravelTime);
        double enemyBearing = Util.bearing(robot.getPosition(), enemyEstimatedPosition);
        double angle = Math.abs(Util.normalizeBearing(enemyBearing - robot.getGunHeadingRadians()));
        int timeToTurn = (int)(angle / Base.RATE_GUN_TURN);
        int timeToCool = (int)(robot.getGunHeat() / robot.getGunCoolingRate());
        int timeToFire = Math.max(timeToTurn, timeToCool);
        long fireTime = robot.getTime() + (long)timeToFire;
        Point estimatedPosition = robot.getEstimatedPosition(fireTime);
        estimatedDistance = Util.range(estimatedPosition, enemyEstimatedPosition);
        bulletTravelTime = Util.bulletTravelTime(estimatedDistance, power);
        enemyEstimatedPosition = timeToFire > 5 ? this.enemy_.getEstimatedPosition(fireTime + (long)bulletTravelTime) : this.getEstimatedPosition(robot, fireTime + (long)bulletTravelTime);
        enemyBearing = Util.bearing(estimatedPosition, enemyEstimatedPosition);
        angle = Util.normalizeBearing(enemyBearing - robot.getGunHeadingRadians());
        return Util.normalizeBearing(angle);
    }

    public Point getEstimatedPosition(Base robot, Tracer t, long time) {
        return this.getEstimatedPosition(t.getRobotStartPosition(), t.getFactors().getPosition(), time - t.getStart());
    }

    public void tracerDidHit(Base robot, Tracer t, Histogram h) {
        Factors f = t.getFactors();
        double actualAngle = t.getActualAngle();
        double originalAngle = Util.bearing(t.getRobotStartPosition(), f.getPosition());
        double bearing = Util.normalizeBearing(actualAngle - originalAngle);
        double distanceTraveledOnNormal = Math.sin(bearing) * f.getDistance();
        int estimatedBulletTravelTime = Util.bulletTravelTime(f.getDistance(), t.getPower());
        if (estimatedBulletTravelTime > 0) {
            double maxDistanceTraveled = (double)estimatedBulletTravelTime * 8.0;
            double percent = distanceTraveledOnNormal / maxDistanceTraveled * 100.0;
            int offset = (int)(percent / this.bucketSize);
            offset = bearing >= 0.0 ? (offset += this.bucketCount / 2) : this.bucketCount / 2 - offset;
            if (offset >= 0 && offset < this.bucketCount) {
                this.aimingOffset.recordSuccess(offset);
            }
        }
        if (this.aimingOffset.getTotalSuccesses() > this.sampleMinimum) {
            Point p = this.getEstimatedPosition(robot, t, robot.getTime());
            double shotAtBearing = Util.bearing(t.getRobotStartPosition(), p);
            double estimatedDistance = Util.range(t.getRobotStartPosition(), t.getTarget().getEstimatedPosition(robot.getTime()));
            double missDistance = Math.sin(Math.abs(shotAtBearing - actualAngle)) * estimatedDistance;
            if (missDistance <= 18.0) {
                h.recordSuccess(this);
            } else {
                h.recordFailure(this);
            }
        }
    }
}

